/*     */ package org.jboss.deployers.spi.deployer;
/*     */ 
/*     */ public class DeploymentStage
/*     */ {
/*     */   private String name;
/*     */   private String after;
/*     */   private String before;
/*     */ 
/*     */   private static String getStageName(DeploymentStage stage, String context)
/*     */   {
/*  51 */     if (stage == null)
/*  52 */       throw new IllegalArgumentException("Null " + context);
/*  53 */     return stage.getName();
/*     */   }
/*     */ 
/*     */   public DeploymentStage(String name)
/*     */   {
/*  64 */     this(name, (String)null);
/*     */   }
/*     */ 
/*     */   public DeploymentStage(String name, String after)
/*     */   {
/*  76 */     this(name, after, null);
/*     */   }
/*     */ 
/*     */   public DeploymentStage(String name, DeploymentStage after)
/*     */   {
/*  88 */     this(name, getStageName(after, "after"), null);
/*     */   }
/*     */ 
/*     */   public DeploymentStage(String name, DeploymentStage after, DeploymentStage before)
/*     */   {
/* 101 */     this(name, getStageName(after, "after"), getStageName(before, "before"));
/*     */   }
/*     */ 
/*     */   public DeploymentStage(String name, String after, String before)
/*     */   {
/* 114 */     if (name == null)
/* 115 */       throw new IllegalArgumentException("Null name");
/* 116 */     this.name = name;
/* 117 */     this.after = after;
/* 118 */     this.before = before;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 128 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getAfter()
/*     */   {
/* 138 */     return this.after;
/*     */   }
/*     */ 
/*     */   public String getBefore()
/*     */   {
/* 148 */     return this.before;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 154 */     return getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.DeploymentStage
 * JD-Core Version:    0.6.0
 */