/*    */ package org.jboss.deployers.spi.attachments.helpers;
/*    */ 
/*    */ import java.util.Map;
/*    */ import java.util.Map.Entry;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ 
/*    */ public abstract class AbstractMutableAttachments extends AbstractAttachments
/*    */   implements MutableAttachments
/*    */ {
/*    */   private static final long serialVersionUID = -1692116584854666016L;
/*    */ 
/*    */   public <T> T addAttachment(String name, T attachment, Class<T> expectedType)
/*    */   {
/* 42 */     if (expectedType == null)
/* 43 */       throw new IllegalArgumentException("Null expectedType");
/* 44 */     Object result = addAttachment(name, attachment);
/* 45 */     if (result == null)
/* 46 */       return null;
/* 47 */     return expectedType.cast(result);
/*    */   }
/*    */ 
/*    */   public void setAttachments(Map<String, Object> map)
/*    */   {
/* 52 */     if (map == null) {
/* 53 */       throw new IllegalArgumentException("Null map");
/*    */     }
/* 55 */     clear();
/*    */ 
/* 57 */     for (Map.Entry entry : map.entrySet())
/* 58 */       addAttachment((String)entry.getKey(), entry.getValue());
/*    */   }
/*    */ 
/*    */   public <T> T addAttachment(Class<T> type, T attachment)
/*    */   {
/* 63 */     if (type == null)
/* 64 */       throw new IllegalArgumentException("Null type");
/* 65 */     return addAttachment(type.getName(), attachment, type);
/*    */   }
/*    */ 
/*    */   public <T> T removeAttachment(String name, Class<T> expectedType)
/*    */   {
/* 70 */     if (expectedType == null)
/* 71 */       throw new IllegalArgumentException("Null expectedType");
/* 72 */     Object result = removeAttachment(name);
/* 73 */     if (result == null)
/* 74 */       return null;
/* 75 */     return expectedType.cast(result);
/*    */   }
/*    */ 
/*    */   public <T> T removeAttachment(Class<T> type)
/*    */   {
/* 80 */     if (type == null)
/* 81 */       throw new IllegalArgumentException("Null type");
/* 82 */     return removeAttachment(type.getName(), type);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.attachments.helpers.AbstractMutableAttachments
 * JD-Core Version:    0.6.0
 */