/*    */ package org.jboss.deployers.spi.attachments.helpers;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import org.jboss.deployers.spi.attachments.Attachments;
/*    */ 
/*    */ public abstract class AbstractAttachments
/*    */   implements Attachments, Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = -4084792454892396925L;
/*    */ 
/*    */   public <T> T getAttachment(String name, Class<T> expectedType)
/*    */   {
/* 44 */     if (expectedType == null)
/* 45 */       throw new IllegalArgumentException("Null expectedType");
/* 46 */     Object result = getAttachment(name);
/* 47 */     if (result == null)
/* 48 */       return null;
/* 49 */     return expectedType.cast(result);
/*    */   }
/*    */ 
/*    */   public <T> T getAttachment(Class<T> type)
/*    */   {
/* 54 */     if (type == null)
/* 55 */       throw new IllegalArgumentException("Null type");
/* 56 */     return getAttachment(type.getName(), type);
/*    */   }
/*    */ 
/*    */   public boolean isAttachmentPresent(String name, Class<?> expectedType)
/*    */   {
/* 61 */     if (expectedType == null)
/* 62 */       throw new IllegalArgumentException("Null expectedType");
/* 63 */     Object result = getAttachment(name);
/* 64 */     if (result == null)
/* 65 */       return false;
/*    */     try
/*    */     {
/* 68 */       expectedType.cast(result);
/*    */     }
/*    */     catch (ClassCastException e)
/*    */     {
/* 72 */       return false;
/*    */     }
/* 74 */     return true;
/*    */   }
/*    */ 
/*    */   public boolean isAttachmentPresent(Class<?> type)
/*    */   {
/* 79 */     if (type == null)
/* 80 */       throw new IllegalArgumentException("Null type");
/* 81 */     return isAttachmentPresent(type.getName(), type);
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out)
/*    */     throws IOException
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.attachments.helpers.AbstractAttachments
 * JD-Core Version:    0.6.0
 */