/*     */ package org.jboss.deployers.plugins.sort;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.Ordered;
/*     */ 
/*     */ public class DominoOrdering<T extends Domino>
/*     */ {
/*     */   protected String message;
/*     */   protected List<T> dominoes;
/*     */   protected int size;
/*     */   protected int[][] connections;
/*     */ 
/*     */   public DominoOrdering(String message)
/*     */   {
/*  47 */     this.message = message;
/*     */   }
/*     */ 
/*     */   protected void init(List<T> dominoes, Object cause)
/*     */   {
/*  53 */     this.dominoes = dominoes;
/*  54 */     this.size = dominoes.size();
/*  55 */     this.connections = new int[this.size][this.size];
/*     */ 
/*  57 */     for (int i = 0; i < this.size - 1; i++)
/*     */     {
/*  59 */       for (int j = i + 1; j < this.size; j++)
/*     */       {
/*  61 */         Domino one = (Domino)dominoes.get(i);
/*  62 */         Domino two = (Domino)dominoes.get(j);
/*  63 */         Dots oneHead = one.getHead();
/*  64 */         Dots oneTail = one.getTail();
/*  65 */         Dots twoHead = two.getHead();
/*  66 */         Dots twoTail = two.getTail();
/*  67 */         boolean fstXsnd = oneTail.match(twoHead);
/*  68 */         boolean sndXfst = twoTail.match(oneHead);
/*  69 */         int relation = 0;
/*  70 */         if ((fstXsnd) && (sndXfst))
/*     */         {
/*  73 */           if ((one.getHead().match(twoHead)) && (oneTail.match(twoTail))) {
/*  74 */             relation = Ordered.COMPARATOR.compare(one, two);
/*     */           }
/*     */           else
/*  77 */             throwCycleException(cause);
/*     */         }
/*     */         else
/*  80 */           relation = sndXfst ? 1 : fstXsnd ? -1 : 0;
/*  81 */         if (relation == 0)
/*     */         {
/*  84 */           if ((one.getRelativeOrder() != 0) && (two.getRelativeOrder() != 0))
/*  85 */             relation = one.getRelativeOrder() - two.getRelativeOrder();
/*     */         }
/*  87 */         this.connections[i][j] = relation;
/*  88 */         this.connections[j][i] = (-this.connections[i][j]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<T> orderDominoes(List<T> dominoes, Object cause)
/*     */   {
/*  96 */     init(dominoes, cause);
/*     */ 
/*  98 */     int cycle = fillTransitions(true);
/*  99 */     if (cycle >= 0) {
/* 100 */       throwCycleException(cause);
/*     */     }
/* 102 */     fillCompareNames();
/*     */ 
/* 104 */     List indexes = new ArrayList();
/* 105 */     for (int i = 0; i < this.size; i++)
/* 106 */       indexes.add(Integer.valueOf(i));
/* 107 */     Collections.sort(indexes, new IndexComparator());
/*     */ 
/* 109 */     List list = new ArrayList(this.size);
/* 110 */     for (Integer index : indexes)
/* 111 */       list.add(dominoes.get(index.intValue()));
/* 112 */     return list;
/*     */   }
/*     */ 
/*     */   protected int fillTransitions(boolean fillTransitions)
/*     */   {
/* 123 */     boolean changed = true;
/* 124 */     while (changed)
/*     */     {
/* 126 */       changed = false;
/* 127 */       for (int i = 0; i < this.size; i++)
/*     */       {
/* 129 */         for (int j = 0; j < this.size; j++)
/*     */         {
/* 131 */           int current = this.connections[i][j];
/* 132 */           if ((j == i) || (current == 0))
/*     */             continue;
/* 134 */           for (int k = 0; k < this.size; k++)
/*     */           {
/* 136 */             if ((k == i) || (k == j))
/*     */               continue;
/* 138 */             int lookup = this.connections[j][k];
/*     */ 
/* 140 */             if (current * lookup <= 0)
/*     */               continue;
/* 142 */             int next = this.connections[i][k];
/*     */ 
/* 144 */             if (next * current < 0)
/*     */             {
/* 146 */               return i;
/*     */             }
/* 148 */             if ((!fillTransitions) || (next != 0))
/*     */               continue;
/* 150 */             this.connections[i][k] = current;
/* 151 */             changed = true;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 158 */     return -1;
/*     */   }
/*     */ 
/*     */   protected void fillCompareNames()
/*     */   {
/* 163 */     for (int i = 0; i < this.size - 1; i++)
/*     */     {
/* 165 */       for (int j = i + 1; j < this.size; j++)
/*     */       {
/* 167 */         if (this.connections[i][j] != 0)
/*     */           continue;
/* 169 */         Domino one = (Domino)this.dominoes.get(i);
/* 170 */         Domino two = (Domino)this.dominoes.get(j);
/* 171 */         this.connections[i][j] = Ordered.COMPARATOR.compare(one, two);
/* 172 */         this.connections[j][i] = (-this.connections[i][j]);
/* 173 */         int cycle = fillTransitions(false);
/*     */ 
/* 175 */         if (cycle < 0)
/*     */           continue;
/* 177 */         this.connections[i][j] = (-this.connections[i][j]);
/* 178 */         this.connections[j][i] = (-this.connections[i][j]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void throwCycleException(Object cause)
/*     */   {
/* 187 */     StringBuilder builder = new StringBuilder();
/* 188 */     builder.append(String.format(this.message, new Object[] { cause }));
/* 189 */     for (Domino d : this.dominoes)
/* 190 */       builder.append(d.getInfo());
/* 191 */     throw new IllegalStateException(builder.toString());
/*     */   }
/*     */   protected class IndexComparator implements Comparator<Integer> {
/*     */     protected IndexComparator() {
/*     */     }
/*     */ 
/*     */     public int compare(Integer i1, Integer i2) {
/* 198 */       return DominoOrdering.this.connections[i1.intValue()][i2.intValue()];
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.sort.DominoOrdering
 * JD-Core Version:    0.6.0
 */