/*     */ package org.jboss.deployers.plugins.main;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock.ReadLock;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock.WriteLock;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.DeploymentState;
/*     */ import org.jboss.deployers.spi.deployer.Deployers;
/*     */ import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.StructuralDeployers;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.util.graph.Graph;
/*     */ import org.jboss.util.graph.Vertex;
/*     */ 
/*     */ public class MainDeployerImpl
/*     */   implements MainDeployer, MainDeployerStructure
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(MainDeployerImpl.class);
/*     */ 
/*  65 */   private AtomicBoolean shutdown = new AtomicBoolean(false);
/*     */   private Deployers deployers;
/*     */   private StructuralDeployers structuralDeployers;
/*  74 */   private ManagedDeploymentCreator mgtDeploymentCreator = null;
/*     */ 
/*  77 */   private Map<String, DeploymentContext> topLevelDeployments = new ConcurrentHashMap();
/*     */ 
/*  80 */   private Map<String, DeploymentContext> allDeployments = new ConcurrentHashMap();
/*     */ 
/*  83 */   private Map<String, DeploymentContext> errorDeployments = new ConcurrentHashMap();
/*     */ 
/*  86 */   private Map<String, Deployment> missingDeployers = new ConcurrentHashMap();
/*     */ 
/*  89 */   private List<DeploymentContext> undeploy = new CopyOnWriteArrayList();
/*     */ 
/*  92 */   private List<DeploymentContext> deploy = new CopyOnWriteArrayList();
/*     */ 
/*  95 */   private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
/*     */ 
/*     */   public synchronized Deployers getDeployers()
/*     */   {
/* 104 */     return this.deployers;
/*     */   }
/*     */ 
/*     */   public synchronized void setDeployers(Deployers deployers)
/*     */   {
/* 115 */     if (deployers == null)
/* 116 */       throw new IllegalArgumentException("Null deployers");
/* 117 */     this.deployers = deployers;
/*     */   }
/*     */ 
/*     */   public synchronized StructuralDeployers getStructuralDeployers()
/*     */   {
/* 127 */     return this.structuralDeployers;
/*     */   }
/*     */ 
/*     */   public synchronized void setStructuralDeployers(StructuralDeployers deployers)
/*     */   {
/* 138 */     if (deployers == null)
/* 139 */       throw new IllegalArgumentException("Null deployers");
/* 140 */     this.structuralDeployers = deployers;
/*     */   }
/*     */ 
/*     */   public ManagedDeploymentCreator getMgtDeploymentCreator()
/*     */   {
/* 145 */     return this.mgtDeploymentCreator;
/*     */   }
/*     */ 
/*     */   public void setMgtDeploymentCreator(ManagedDeploymentCreator mgtDeploymentCreator)
/*     */   {
/* 150 */     this.mgtDeploymentCreator = mgtDeploymentCreator;
/*     */   }
/*     */ 
/*     */   public Deployment getDeployment(String name)
/*     */   {
/* 155 */     DeploymentContext context = getTopLevelDeploymentContext(name);
/* 156 */     if (context == null)
/* 157 */       return null;
/* 158 */     return context.getDeployment();
/*     */   }
/*     */ 
/*     */   public DeploymentContext getDeploymentContext(String name)
/*     */   {
/* 163 */     if (name == null) {
/* 164 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 166 */     return (DeploymentContext)this.allDeployments.get(name);
/*     */   }
/*     */ 
/*     */   public DeploymentContext getDeploymentContext(String name, boolean errorNotFound) throws DeploymentException
/*     */   {
/* 171 */     DeploymentContext context = getDeploymentContext(name);
/* 172 */     if ((errorNotFound) && (context == null))
/* 173 */       throw new DeploymentException("Context " + name + " not found");
/* 174 */     return context;
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit(String name)
/*     */   {
/* 179 */     DeploymentContext context = getDeploymentContext(name);
/* 180 */     if (context == null)
/* 181 */       return null;
/* 182 */     return context.getDeploymentUnit();
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit(String name, boolean errorNotFound) throws DeploymentException
/*     */   {
/* 187 */     DeploymentUnit unit = getDeploymentUnit(name);
/* 188 */     if ((errorNotFound) && (unit == null))
/* 189 */       throw new DeploymentException("Unit " + name + " not found");
/* 190 */     return unit;
/*     */   }
/*     */ 
/*     */   public DeploymentContext getTopLevelDeploymentContext(String name)
/*     */   {
/* 201 */     if (name == null)
/* 202 */       throw new IllegalArgumentException("Null name");
/* 203 */     return (DeploymentContext)this.topLevelDeployments.get(name);
/*     */   }
/*     */ 
/*     */   public Collection<DeploymentContext> getAll()
/*     */   {
/* 208 */     return Collections.unmodifiableCollection(this.allDeployments.values());
/*     */   }
/*     */ 
/*     */   public Collection<DeploymentContext> getErrors()
/*     */   {
/* 213 */     return Collections.unmodifiableCollection(this.errorDeployments.values());
/*     */   }
/*     */ 
/*     */   public Collection<Deployment> getMissingDeployer()
/*     */   {
/* 218 */     return Collections.unmodifiableCollection(this.missingDeployers.values());
/*     */   }
/*     */ 
/*     */   public Collection<Deployment> getTopLevel()
/*     */   {
/* 223 */     List result = new ArrayList();
/* 224 */     for (DeploymentContext context : this.topLevelDeployments.values())
/*     */     {
/* 226 */       Deployment deployment = context.getDeployment();
/* 227 */       if (deployment != null)
/* 228 */         result.add(deployment);
/*     */       else
/* 230 */         throw new IllegalStateException("Context has no deployment? " + context.getName());
/*     */     }
/* 232 */     return result;
/*     */   }
/*     */ 
/*     */   public void addDeployment(Deployment deployment) throws DeploymentException
/*     */   {
/* 237 */     addDeployment(deployment, true);
/*     */   }
/*     */ 
/*     */   protected void addDeployment(Deployment deployment, boolean addToDeploy)
/*     */     throws DeploymentException
/*     */   {
/* 249 */     if (deployment == null) {
/* 250 */       throw new DeploymentException("Null context");
/*     */     }
/* 252 */     lockRead();
/*     */     try
/*     */     {
/* 255 */       if (this.shutdown.get()) {
/* 256 */         throw new DeploymentException("The main deployer is shutdown");
/*     */       }
/* 258 */       String name = deployment.getName();
/* 259 */       log.debug("Add deployment: " + name);
/*     */ 
/* 261 */       DeploymentContext previous = (DeploymentContext)this.topLevelDeployments.get(name);
/* 262 */       boolean topLevelFound = false;
/* 263 */       if (previous != null)
/*     */       {
/* 265 */         log.debug("Removing previous deployment: " + previous.getName());
/* 266 */         removeContext(previous, addToDeploy);
/* 267 */         topLevelFound = true;
/*     */       }
/*     */ 
/* 270 */       if (!topLevelFound)
/*     */       {
/* 272 */         previous = (DeploymentContext)this.allDeployments.get(name);
/* 273 */         if (previous != null) {
/* 274 */           throw new IllegalStateException("Deployment already exists as a subdeployment: " + name);
/*     */         }
/*     */       }
/* 277 */       DeploymentContext context = null;
/*     */       try
/*     */       {
/* 280 */         context = determineStructure(deployment);
/* 281 */         if (DeploymentState.ERROR.equals(context.getState())) {
/* 282 */           this.errorDeployments.put(name, context);
/*     */         }
/* 284 */         this.topLevelDeployments.put(name, context);
/* 285 */         addContext(context, addToDeploy);
/*     */       }
/*     */       catch (DeploymentException e)
/*     */       {
/* 289 */         this.missingDeployers.put(name, deployment);
/* 290 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 295 */         if (context == null) {
/* 296 */           this.missingDeployers.put(name, deployment);
/*     */         }
/* 298 */         throw DeploymentException.rethrowAsDeploymentException("Error determining deployment structure for " + name, t);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 303 */       unlockRead();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean removeDeployment(Deployment deployment) throws DeploymentException
/*     */   {
/* 309 */     return removeDeployment(deployment, true);
/*     */   }
/*     */ 
/*     */   protected boolean removeDeployment(Deployment deployment, boolean addToUndeploy)
/*     */     throws DeploymentException
/*     */   {
/* 322 */     if (deployment == null) {
/* 323 */       throw new DeploymentException("Null deployment");
/*     */     }
/* 325 */     return removeDeployment(deployment.getName(), addToUndeploy);
/*     */   }
/*     */ 
/*     */   public boolean removeDeployment(String name) throws DeploymentException
/*     */   {
/* 330 */     return removeDeployment(name, true);
/*     */   }
/*     */ 
/*     */   protected boolean removeDeployment(String name, boolean addToUndeploy)
/*     */     throws DeploymentException
/*     */   {
/* 343 */     if (name == null) {
/* 344 */       throw new DeploymentException("Null name");
/*     */     }
/* 346 */     lockRead();
/*     */     try
/*     */     {
/* 349 */       if (this.shutdown.get()) {
/* 350 */         throw new IllegalStateException("The main deployer is shutdown");
/*     */       }
/* 352 */       log.debug("Remove deployment context: " + name);
/*     */ 
/* 354 */       DeploymentContext context = (DeploymentContext)this.topLevelDeployments.remove(name);
/* 355 */       if (context == null) {
/* 356 */         i = 0;
/*     */         return i;
/*     */       }
/* 358 */       removeContext(context, addToUndeploy);
/*     */ 
/* 360 */       int i = 1;
/*     */       return i; } finally { unlockRead(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void deploy(Deployment[] deployments)
/*     */     throws DeploymentException
/*     */   {
/* 370 */     if (deployments == null) {
/* 371 */       throw new IllegalArgumentException("Null deployments.");
/*     */     }
/* 373 */     lockRead();
/*     */     try
/*     */     {
/* 376 */       if (this.shutdown.get()) {
/* 377 */         throw new IllegalStateException("The main deployer is shutdown");
/*     */       }
/* 379 */       DeploymentContext[] contexts = new DeploymentContext[deployments.length];
/* 380 */       for (int i = 0; i < deployments.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 384 */           addDeployment(deployments[i], false);
/* 385 */           DeploymentContext context = getDeploymentContext(deployments[i].getName(), true);
/* 386 */           this.deployers.process(Collections.singletonList(context), null);
/* 387 */           contexts[i] = context;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 391 */           DeploymentContext[] deployedContexts = new DeploymentContext[i];
/* 392 */           System.arraycopy(contexts, 0, deployedContexts, 0, i);
/* 393 */           this.deployers.process(null, Arrays.asList(deployedContexts));
/* 394 */           throw DeploymentException.rethrowAsDeploymentException("Unable to deploy deployments, cause: " + deployments[i], t);
/*     */         }
/*     */       }
/*     */       try
/*     */       {
/* 399 */         this.deployers.checkComplete(contexts);
/*     */       }
/*     */       catch (DeploymentException e)
/*     */       {
/* 403 */         this.deployers.process(null, Arrays.asList(contexts));
/* 404 */         throw e;
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 409 */       unlockRead();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(Deployment[] deployments) throws DeploymentException
/*     */   {
/* 415 */     if (deployments == null) {
/* 416 */       throw new IllegalArgumentException("Null deployments.");
/*     */     }
/* 418 */     lockRead();
/*     */     try
/*     */     {
/* 421 */       if (this.shutdown.get()) {
/* 422 */         throw new IllegalStateException("The main deployer is shutdown");
/*     */       }
/* 424 */       for (Deployment deployment : deployments)
/*     */       {
/* 426 */         DeploymentContext context = getDeploymentContext(deployment.getName());
/* 427 */         if (context != null)
/*     */         {
/*     */           try
/*     */           {
/* 431 */             removeDeployment(deployment, false);
/* 432 */             this.deployers.process(null, Collections.singletonList(context));
/*     */           }
/*     */           catch (DeploymentException e)
/*     */           {
/* 436 */             if (log.isTraceEnabled())
/* 437 */               log.trace("Ignored exception while undeploying deployment " + deployment.getName() + ":" + e);
/*     */           }
/*     */         } else {
/* 440 */           if (!log.isTraceEnabled())
/*     */             continue;
/* 442 */           log.trace("No such deployment present: " + deployment.getName());
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 448 */       unlockRead();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(String[] names) throws DeploymentException
/*     */   {
/* 454 */     if (names == null) {
/* 455 */       throw new IllegalArgumentException("Null names.");
/*     */     }
/* 457 */     List deployments = new ArrayList();
/* 458 */     for (String name : names)
/*     */     {
/* 460 */       DeploymentContext context = getDeploymentContext(name);
/* 461 */       if (context != null)
/* 462 */         deployments.add(context.getDeployment());
/* 463 */       else if (log.isTraceEnabled())
/* 464 */         log.trace("No such deployment present: " + name);
/*     */     }
/* 466 */     if (!deployments.isEmpty())
/* 467 */       undeploy((Deployment[])deployments.toArray(new Deployment[deployments.size()]));
/*     */   }
/*     */ 
/*     */   public void process()
/*     */   {
/* 472 */     lockRead();
/*     */     try
/*     */     {
/* 475 */       if (this.shutdown.get()) {
/* 476 */         throw new IllegalStateException("The main deployer is shutdown");
/*     */       }
/* 478 */       List undeployContexts = null;
/* 479 */       List deployContexts = null;
/*     */ 
/* 481 */       if (this.deployers == null) {
/* 482 */         throw new IllegalStateException("No deployers");
/*     */       }
/* 484 */       if (!this.undeploy.isEmpty())
/*     */       {
/* 487 */         undeployContexts = new ArrayList(this.undeploy.size());
/* 488 */         for (int i = this.undeploy.size() - 1; i >= 0; i--)
/* 489 */           undeployContexts.add(this.undeploy.get(i));
/* 490 */         this.undeploy.clear();
/*     */       }
/* 492 */       if (!this.deploy.isEmpty())
/*     */       {
/* 494 */         deployContexts = new ArrayList(this.deploy);
/* 495 */         this.deploy.clear();
/*     */       }
/*     */ 
/* 498 */       if ((undeployContexts == null) && (deployContexts == null))
/*     */       {
/* 500 */         log.debug("Asked to process() when there is nothing to do.");
/*     */         return;
/*     */       }
/*     */       try {
/* 506 */         this.deployers.process(deployContexts, undeployContexts);
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 510 */         throw e;
/*     */       }
/*     */       catch (Error e)
/*     */       {
/* 514 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 518 */         throw new RuntimeException("Unexpected error in process()", t);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 523 */       unlockRead();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 530 */     lockWrite();
/*     */     try
/*     */     {
/* 533 */       while (!this.topLevelDeployments.isEmpty())
/*     */       {
/* 536 */         for (DeploymentContext context : this.topLevelDeployments.values())
/*     */         {
/* 538 */           this.topLevelDeployments.remove(context.getName());
/* 539 */           removeContext(context, true);
/*     */         }
/*     */ 
/* 543 */         process();
/*     */       }
/*     */ 
/* 546 */       this.shutdown.set(true);
/*     */     }
/*     */     finally
/*     */     {
/* 550 */       unlockWrite();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void checkComplete() throws DeploymentException
/*     */   {
/* 556 */     if (this.deployers == null) {
/* 557 */       throw new IllegalStateException("Null deployers");
/*     */     }
/* 559 */     this.deployers.checkComplete(this.errorDeployments.values(), this.missingDeployers.values());
/*     */   }
/*     */ 
/*     */   protected static String[] getDeploymentNames(Deployment[] deployments)
/*     */   {
/* 570 */     if (deployments == null) {
/* 571 */       throw new IllegalArgumentException("Null deployments");
/*     */     }
/* 573 */     String[] names = new String[deployments.length];
/* 574 */     for (int i = 0; i < deployments.length; i++)
/*     */     {
/* 576 */       if (deployments[i] == null)
/* 577 */         throw new IllegalArgumentException("Null deployment: " + i);
/* 578 */       names[i] = deployments[i].getName();
/*     */     }
/* 580 */     return names;
/*     */   }
/*     */ 
/*     */   protected DeploymentContext[] getDeploymentContexts(String[] names)
/*     */     throws DeploymentException
/*     */   {
/* 592 */     if (names == null) {
/* 593 */       throw new IllegalArgumentException("Null names");
/*     */     }
/* 595 */     DeploymentContext[] contexts = new DeploymentContext[names.length];
/* 596 */     for (int i = 0; i < names.length; i++) {
/* 597 */       contexts[i] = getDeploymentContext(names[i], true);
/*     */     }
/* 599 */     return contexts;
/*     */   }
/*     */ 
/*     */   public void checkComplete(Deployment[] deployments) throws DeploymentException
/*     */   {
/* 604 */     if (deployments == null) {
/* 605 */       throw new IllegalArgumentException("Null deployments");
/*     */     }
/* 607 */     checkComplete(getDeploymentNames(deployments));
/*     */   }
/*     */ 
/*     */   public void checkComplete(String[] names) throws DeploymentException
/*     */   {
/* 612 */     if (names == null) {
/* 613 */       throw new IllegalArgumentException("Null names");
/*     */     }
/* 615 */     if (this.deployers == null) {
/* 616 */       throw new IllegalStateException("Null deployers");
/*     */     }
/* 618 */     this.deployers.checkComplete(getDeploymentContexts(names));
/*     */   }
/*     */ 
/*     */   public void checkStructureComplete(Deployment[] deployments) throws DeploymentException
/*     */   {
/* 623 */     if (deployments == null) {
/* 624 */       throw new IllegalArgumentException("Null deployments");
/*     */     }
/* 626 */     checkStructureComplete(getDeploymentNames(deployments));
/*     */   }
/*     */ 
/*     */   public void checkStructureComplete(String[] names) throws DeploymentException
/*     */   {
/* 631 */     if (names == null) {
/* 632 */       throw new IllegalArgumentException("Null names");
/*     */     }
/* 634 */     if (this.deployers == null) {
/* 635 */       throw new IllegalStateException("Null deployers");
/*     */     }
/* 637 */     this.deployers.checkStructureComplete(getDeploymentContexts(names));
/*     */   }
/*     */ 
/*     */   public DeploymentState getDeploymentState(String name)
/*     */   {
/* 642 */     DeploymentContext context = getDeploymentContext(name);
/* 643 */     if (context == null)
/* 644 */       return DeploymentState.UNDEPLOYED;
/* 645 */     return context.getState();
/*     */   }
/*     */ 
/*     */   public ManagedDeployment getManagedDeployment(String name) throws DeploymentException
/*     */   {
/* 650 */     DeploymentContext context = getDeploymentContext(name, true);
/* 651 */     Map rootMOs = getManagedObjects(context);
/* 652 */     ManagedDeployment root = this.mgtDeploymentCreator.build(context.getDeploymentUnit(), rootMOs, null);
/* 653 */     for (DeploymentContext childContext : context.getChildren())
/*     */     {
/* 655 */       processManagedDeployment(childContext, root);
/*     */     }
/* 657 */     return root;
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedObject> getManagedObjects(String name) throws DeploymentException
/*     */   {
/* 662 */     DeploymentContext context = getDeploymentContext(name, true);
/* 663 */     return getManagedObjects(context);
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException
/*     */   {
/* 668 */     if (context == null) {
/* 669 */       throw new IllegalArgumentException("Null context");
/*     */     }
/* 671 */     if (this.deployers == null) {
/* 672 */       throw new IllegalStateException("No deployers");
/*     */     }
/* 674 */     return this.deployers.getManagedObjects(context);
/*     */   }
/*     */ 
/*     */   public Graph<Map<String, ManagedObject>> getDeepManagedObjects(String name) throws DeploymentException
/*     */   {
/* 679 */     DeploymentContext context = getDeploymentContext(name);
/* 680 */     Graph managedObjectsGraph = new Graph();
/* 681 */     Vertex parent = new Vertex(context.getName());
/* 682 */     managedObjectsGraph.setRootVertex(parent);
/* 683 */     Map managedObjects = getManagedObjects(context);
/* 684 */     parent.setData(managedObjects);
/* 685 */     processManagedObjects(context, managedObjectsGraph, parent);
/*     */ 
/* 687 */     return managedObjectsGraph;
/*     */   }
/*     */ 
/*     */   protected void processManagedObjects(DeploymentContext context, Graph<Map<String, ManagedObject>> graph, Vertex<Map<String, ManagedObject>> parent)
/*     */     throws DeploymentException
/*     */   {
/* 701 */     List children = context.getChildren();
/* 702 */     for (DeploymentContext child : children)
/*     */     {
/* 704 */       Vertex vertex = new Vertex(child.getName());
/* 705 */       Map managedObjects = getManagedObjects(context);
/* 706 */       vertex.setData(managedObjects);
/* 707 */       graph.addEdge(parent, vertex, 0);
/* 708 */       processManagedObjects(child, graph, vertex);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processManagedDeployment(DeploymentContext context, ManagedDeployment parent)
/*     */     throws DeploymentException
/*     */   {
/* 722 */     DeploymentUnit unit = context.getDeploymentUnit();
/* 723 */     Map MOs = getManagedObjects(context);
/* 724 */     ManagedDeployment md = this.mgtDeploymentCreator.build(unit, MOs, parent);
/* 725 */     for (DeploymentContext childContext : context.getChildren())
/*     */     {
/* 727 */       processManagedDeployment(childContext, md);
/*     */     }
/*     */   }
/*     */ 
/*     */   private DeploymentContext determineStructure(Deployment deployment)
/*     */     throws DeploymentException
/*     */   {
/* 740 */     StructuralDeployers structuralDeployers = getStructuralDeployers();
/* 741 */     if (structuralDeployers != null)
/*     */     {
/* 743 */       DeploymentContext result = structuralDeployers.determineStructure(deployment);
/* 744 */       if (result != null)
/* 745 */         return result;
/*     */     }
/* 747 */     throw new DeploymentException("No structural deployers.");
/*     */   }
/*     */ 
/*     */   private void addContext(DeploymentContext context, boolean addToDeploy)
/*     */   {
/* 758 */     this.allDeployments.put(context.getName(), context);
/* 759 */     if (context.getState() == DeploymentState.ERROR)
/*     */     {
/* 761 */       log.debug("Not scheduling addition of context already in error: " + context.getName() + " reason=" + context.getProblem());
/* 762 */       return;
/*     */     }
/* 764 */     context.setState(DeploymentState.DEPLOYING);
/* 765 */     DeploymentContext parent = context.getParent();
/* 766 */     log.debug("Scheduling deployment: " + context.getName() + " parent=" + parent);
/*     */ 
/* 769 */     if ((context.isTopLevel()) && (addToDeploy)) {
/* 770 */       this.deploy.add(context);
/*     */     }
/*     */ 
/* 773 */     List children = context.getChildren();
/* 774 */     if (children != null)
/*     */     {
/* 776 */       for (DeploymentContext child : children)
/* 777 */         addContext(child, addToDeploy);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void removeContext(DeploymentContext context, boolean addToUndeploy)
/*     */   {
/* 789 */     String name = context.getName();
/* 790 */     this.allDeployments.remove(name);
/* 791 */     this.errorDeployments.remove(name);
/* 792 */     this.missingDeployers.remove(name);
/* 793 */     if (!DeploymentState.ERROR.equals(context.getState()))
/* 794 */       context.setState(DeploymentState.UNDEPLOYING);
/* 795 */     DeploymentContext parent = context.getParent();
/* 796 */     log.debug("Scheduling undeployment: " + name + " parent=" + parent);
/*     */ 
/* 799 */     if ((context.isTopLevel()) && (addToUndeploy)) {
/* 800 */       this.undeploy.add(context);
/*     */     }
/*     */ 
/* 803 */     List children = context.getChildren();
/* 804 */     if (children != null)
/*     */     {
/* 806 */       for (DeploymentContext child : children)
/* 807 */         removeContext(child, addToUndeploy);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void lockRead()
/*     */   {
/* 816 */     this.lock.readLock().lock();
/*     */   }
/*     */ 
/*     */   protected void unlockRead()
/*     */   {
/* 824 */     this.lock.readLock().unlock();
/*     */   }
/*     */ 
/*     */   protected void lockWrite()
/*     */   {
/* 832 */     this.lock.writeLock().lock();
/*     */   }
/*     */ 
/*     */   protected void unlockWrite()
/*     */   {
/* 840 */     this.lock.writeLock().unlock();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.main.MainDeployerImpl
 * JD-Core Version:    0.6.0
 */