/*      */ package org.jboss.deployers.plugins.deployers;
/*      */ 
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import org.jboss.dependency.plugins.AbstractController;
/*      */ import org.jboss.dependency.spi.ControllerContext;
/*      */ import org.jboss.dependency.spi.ControllerContextActions;
/*      */ import org.jboss.dependency.spi.ControllerState;
/*      */ import org.jboss.dependency.spi.DependencyInfo;
/*      */ import org.jboss.dependency.spi.DependencyItem;
/*      */ import org.jboss.deployers.client.spi.Deployment;
/*      */ import org.jboss.deployers.client.spi.IncompleteDeploymentException;
/*      */ import org.jboss.deployers.client.spi.IncompleteDeployments;
/*      */ import org.jboss.deployers.client.spi.MissingDependency;
/*      */ import org.jboss.deployers.plugins.sort.DeployerSorter;
/*      */ import org.jboss.deployers.plugins.sort.DeployerSorterFactory;
/*      */ import org.jboss.deployers.spi.DeploymentException;
/*      */ import org.jboss.deployers.spi.DeploymentState;
/*      */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*      */ import org.jboss.deployers.spi.deployer.Deployer;
/*      */ import org.jboss.deployers.spi.deployer.Deployers;
/*      */ import org.jboss.deployers.spi.deployer.DeploymentStage;
/*      */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*      */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*      */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*      */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*      */ import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
/*      */ import org.jboss.kernel.Kernel;
/*      */ import org.jboss.kernel.spi.dependency.KernelController;
/*      */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.managed.api.ManagedObject;
/*      */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*      */ 
/*      */ public class DeployersImpl
/*      */   implements Deployers, ControllerContextActions
/*      */ {
/*   72 */   private static final Logger log = Logger.getLogger(DeployersImpl.class);
/*      */   private AbstractController controller;
/*      */   private MutableMetaDataRepository repository;
/*   81 */   private Map<String, DeploymentStage> stages = new ConcurrentHashMap();
/*      */ 
/*   84 */   private Set<DeployerWrapper> deployers = new HashSet();
/*      */ 
/*   87 */   private Map<String, List<Deployer>> deployersByStage = new HashMap();
/*      */   private ScopeBuilder scopeBuilder;
/*      */ 
/*      */   public DeployersImpl(AbstractController controller)
/*      */   {
/*  100 */     this(controller, null);
/*      */   }
/*      */ 
/*      */   public DeployersImpl(AbstractController controller, Set<Deployer> deployers)
/*      */   {
/*  112 */     if (controller == null)
/*  113 */       throw new IllegalArgumentException("Null controller");
/*  114 */     this.controller = controller;
/*      */ 
/*  117 */     addDeploymentStage(DeploymentStages.NOT_INSTALLED);
/*  118 */     addDeploymentStage(DeploymentStages.PARSE);
/*  119 */     addDeploymentStage(DeploymentStages.DESCRIBE);
/*  120 */     addDeploymentStage(DeploymentStages.CLASSLOADER);
/*  121 */     addDeploymentStage(DeploymentStages.POST_CLASSLOADER);
/*  122 */     addDeploymentStage(DeploymentStages.REAL);
/*  123 */     addDeploymentStage(DeploymentStages.INSTALLED);
/*      */ 
/*  126 */     if (deployers != null)
/*  127 */       setDeployers(deployers);
/*      */   }
/*      */ 
/*      */   public Set<DeployerWrapper> getDeployerWrappers()
/*      */   {
/*  137 */     return this.deployers;
/*      */   }
/*      */ 
/*      */   public void setDeployers(Set<Deployer> deployers)
/*      */   {
/*  148 */     if (deployers == null) {
/*  149 */       throw new IllegalArgumentException("Null deployers");
/*      */     }
/*      */ 
/*  152 */     HashSet oldDeployers = new HashSet(this.deployers);
/*  153 */     oldDeployers.removeAll(deployers);
/*  154 */     for (Deployer deployer : oldDeployers) {
/*  155 */       removeDeployer(deployer);
/*      */     }
/*      */ 
/*  158 */     HashSet newDeployers = new HashSet(deployers);
/*  159 */     newDeployers.removeAll(this.deployers);
/*  160 */     for (Deployer deployer : newDeployers)
/*  161 */       addDeployer(deployer);
/*      */   }
/*      */ 
/*      */   public synchronized void addDeployer(Deployer deployer)
/*      */   {
/*  171 */     if (deployer == null) {
/*  172 */       throw new IllegalArgumentException("Null deployer");
/*      */     }
/*  174 */     DeploymentStage stage = deployer.getStage();
/*  175 */     if (stage == null) {
/*  176 */       throw new IllegalArgumentException("Deployer has no stage: " + deployer);
/*      */     }
/*  178 */     addDeploymentStage(stage);
/*      */ 
/*  180 */     DeployerWrapper wrapper = new DeployerWrapper(deployer);
/*      */ 
/*  183 */     if (this.deployers.contains(wrapper)) {
/*  184 */       return;
/*      */     }
/*  186 */     String stageName = stage.getName();
/*  187 */     List deployers = (List)this.deployersByStage.get(stageName);
/*  188 */     if (deployers == null)
/*  189 */       deployers = Collections.emptyList();
/*  190 */     deployers = insert(deployers, wrapper);
/*  191 */     this.deployersByStage.put(stageName, deployers);
/*      */ 
/*  193 */     this.deployers.add(wrapper);
/*      */ 
/*  195 */     StringBuilder builder = new StringBuilder();
/*  196 */     builder.append("Added deployer ").append(deployer).append(" for stage ").append(stageName).append('\n');
/*  197 */     for (Deployer temp : getDeployersList(stageName))
/*      */     {
/*  199 */       builder.append(temp);
/*  200 */       builder.append("{inputs=").append(temp.getInputs());
/*  201 */       builder.append(" outputs=").append(temp.getOutputs());
/*  202 */       builder.append("}\n");
/*      */     }
/*  204 */     log.debug(builder);
/*      */   }
/*      */ 
/*      */   public synchronized void removeDeployer(Deployer deployer)
/*      */   {
/*  214 */     if (deployer == null)
/*  215 */       throw new IllegalArgumentException("Null deployer");
/*  216 */     this.deployers.remove(new DeployerWrapper(deployer));
/*      */ 
/*  218 */     DeploymentStage stage = deployer.getStage();
/*  219 */     if (stage == null)
/*      */     {
/*  221 */       log.warn("Deployer has no stage: " + deployer);
/*  222 */       return;
/*      */     }
/*      */ 
/*  225 */     String stageName = stage.getName();
/*  226 */     List deployers = (List)this.deployersByStage.get(stageName);
/*  227 */     if (deployers == null) {
/*  228 */       return;
/*      */     }
/*  230 */     deployers.remove(deployer);
/*  231 */     if (deployers.isEmpty()) {
/*  232 */       this.deployersByStage.remove(stageName);
/*      */     }
/*  234 */     log.debug("Removed deployer " + deployer + " from stage " + stageName);
/*      */   }
/*      */ 
/*      */   protected synchronized void addDeploymentStage(DeploymentStage stage)
/*      */   {
/*  244 */     if (stage == null) {
/*  245 */       throw new IllegalArgumentException("Null stage");
/*      */     }
/*      */ 
/*  248 */     String stageName = stage.getName();
/*  249 */     if (this.stages.containsKey(stageName)) {
/*  250 */       return;
/*      */     }
/*  252 */     ControllerState preceeds = null;
/*  253 */     String before = stage.getBefore();
/*  254 */     String after = stage.getAfter();
/*  255 */     if ((before != null) || (after != null))
/*      */     {
/*  258 */       List states = this.controller.getStates();
/*  259 */       for (int i = 0; i < states.size(); i++)
/*      */       {
/*  261 */         ControllerState state = (ControllerState)states.get(i);
/*  262 */         String stateName = state.getStateString();
/*  263 */         if ((before != null) && (before.equals(stateName)))
/*      */         {
/*  265 */           preceeds = state;
/*  266 */           break;
/*      */         }
/*  268 */         if ((after == null) || (!after.equals(stateName)))
/*      */           continue;
/*  270 */         if (i >= states.size() - 1)
/*      */           continue;
/*  272 */         preceeds = (ControllerState)states.get(i + 1);
/*  273 */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  279 */     this.controller.addState(new ControllerState(stageName), preceeds);
/*  280 */     this.stages.put(stageName, stage);
/*  281 */     log.debug("Added stage " + stageName + " before " + preceeds);
/*      */   }
/*      */ 
/*      */   public ScopeBuilder getScopeBuilder()
/*      */   {
/*  291 */     return this.scopeBuilder;
/*      */   }
/*      */ 
/*      */   public void setScopeBuilder(ScopeBuilder scopeBuilder)
/*      */   {
/*  301 */     this.scopeBuilder = scopeBuilder;
/*      */   }
/*      */ 
/*      */   public MutableMetaDataRepository getRepository()
/*      */   {
/*  311 */     return this.repository;
/*      */   }
/*      */ 
/*      */   public void setRepository(MutableMetaDataRepository repository)
/*      */   {
/*  321 */     this.repository = repository;
/*      */   }
/*      */ 
/*      */   public void start()
/*      */   {
/*  327 */     if ((this.repository == null) && ((this.controller instanceof KernelController)))
/*      */     {
/*  329 */       KernelController kernelController = (KernelController)this.controller;
/*  330 */       this.repository = kernelController.getKernel().getMetaDataRepository().getMetaDataRepository();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException
/*      */   {
/*  336 */     if (context == null) {
/*  337 */       throw new IllegalArgumentException("Null context");
/*      */     }
/*  339 */     Map managedObjects = new HashMap();
/*  340 */     for (DeployerWrapper deployer : this.deployers) {
/*  341 */       deployer.build(context.getDeploymentUnit(), managedObjects);
/*      */     }
/*  343 */     return managedObjects;
/*      */   }
/*      */ 
/*      */   public ManagedObjectCreator getDeployerManagedObjectBuilder(Deployer deployer)
/*      */   {
/*  355 */     if (deployer == null) {
/*  356 */       throw new IllegalArgumentException("Null deployer");
/*      */     }
/*  358 */     ManagedObjectCreator result = null;
/*  359 */     for (DeployerWrapper wrapper : this.deployers)
/*      */     {
/*  361 */       if (wrapper.equals(deployer))
/*  362 */         result = wrapper.getManagedObjectCreator();
/*      */     }
/*  364 */     return result;
/*      */   }
/*      */ 
/*      */   public void setDeployerManagedObjectBuilder(Deployer deployer, ManagedObjectCreator managedObjectCreator)
/*      */   {
/*  377 */     if (deployer == null) {
/*  378 */       throw new IllegalArgumentException("Null deployer");
/*      */     }
/*  380 */     for (DeployerWrapper wrapper : this.deployers)
/*      */     {
/*  382 */       if (wrapper.equals(deployer))
/*  383 */         wrapper.setManagedObjectCreator(managedObjectCreator);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void process(List<DeploymentContext> deploy, List<DeploymentContext> undeploy)
/*      */   {
/*  390 */     if ((undeploy != null) && (!undeploy.isEmpty()))
/*      */     {
/*  393 */       List toUndeploy = new ArrayList();
/*  394 */       for (int i = undeploy.size() - 1; i >= 0; i--)
/*      */       {
/*  396 */         DeploymentContext context = (DeploymentContext)undeploy.get(i);
/*  397 */         if (!DeploymentState.ERROR.equals(context.getState()))
/*  398 */           context.setState(DeploymentState.UNDEPLOYING);
/*  399 */         log.debug("Undeploying " + context.getName());
/*  400 */         DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
/*  401 */         if (deploymentControllerContext == null)
/*      */         {
/*  403 */           log.debug("DeploymentContext has no DeploymentControllerContext during undeploy request, ignoring: " + context);
/*      */         }
/*      */         else
/*      */         {
/*  407 */           toUndeploy.add(deploymentControllerContext);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  412 */       List states = this.controller.getStates();
/*      */       ControllerState state;
/*  413 */       for (int i = states.size() - 1; i >= 0; i--)
/*      */       {
/*  415 */         state = (ControllerState)states.get(i);
/*  416 */         for (DeploymentControllerContext deploymentControllerContext : toUndeploy)
/*      */         {
/*  418 */           DeploymentContext context = deploymentControllerContext.getDeploymentContext();
/*  419 */           if (!ControllerState.ERROR.equals(context.getState()))
/*      */           {
/*      */             try
/*      */             {
/*  423 */               this.controller.change(deploymentControllerContext, state);
/*      */             }
/*      */             catch (Throwable t)
/*      */             {
/*  427 */               log.warn("Error during undeploy", t);
/*  428 */               context.setState(DeploymentState.ERROR);
/*  429 */               context.setProblem(t);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  436 */       for (DeploymentControllerContext deploymentControllerContext : toUndeploy)
/*      */       {
/*  438 */         DeploymentContext context = deploymentControllerContext.getDeploymentContext();
/*  439 */         context.getTransientAttachments().removeAttachment(ControllerContext.class);
/*      */         try
/*      */         {
/*  442 */           this.controller.uninstall(deploymentControllerContext.getName());
/*  443 */           setState(context, DeploymentState.UNDEPLOYED, null);
/*      */ 
/*  446 */           removeClassLoader(context);
/*  447 */           cleanup(context);
/*  448 */           log.debug("Fully Undeployed " + context.getName());
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/*  452 */           log.warn("Error during uninstall", t);
/*  453 */           context.setState(DeploymentState.ERROR);
/*  454 */           context.setProblem(t);
/*      */         }
/*      */       }
/*      */     }
/*      */     Iterator i$;
/*  460 */     if ((deploy != null) && (!deploy.isEmpty()))
/*      */     {
/*  463 */       for (DeploymentContext context : deploy)
/*      */       {
/*  465 */         DeploymentControllerContext deploymentControllerContext = new DeploymentControllerContext(context, this);
/*      */         try
/*      */         {
/*  468 */           this.controller.install(deploymentControllerContext);
/*  469 */           context.setState(DeploymentState.DEPLOYING);
/*  470 */           log.debug("Deploying " + context.getName());
/*  471 */           context.getTransientAttachments().addAttachment(ControllerContext.class, deploymentControllerContext);
/*  472 */           if (this.scopeBuilder != null)
/*  473 */             context.getTransientAttachments().addAttachment(ScopeBuilder.class, this.scopeBuilder);
/*  474 */           if (this.repository != null) {
/*  475 */             context.getTransientAttachments().addAttachment(MutableMetaDataRepository.class, this.repository);
/*      */           }
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/*  480 */           context.setState(DeploymentState.ERROR);
/*  481 */           context.setProblem(t);
/*      */ 
/*  483 */           setState(context, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  488 */       List states = this.controller.getStates();
/*  489 */       for (i$ = states.iterator(); i$.hasNext(); ) { state = (ControllerState)i$.next();
/*      */ 
/*  491 */         for (DeploymentContext context : deploy)
/*      */         {
/*  493 */           if (!DeploymentState.ERROR.equals(context.getState()))
/*      */           {
/*  495 */             DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
/*      */             try
/*      */             {
/*  498 */               this.controller.change(deploymentControllerContext, state);
/*      */             }
/*      */             catch (Throwable t)
/*      */             {
/*  502 */               context.setState(DeploymentState.ERROR);
/*  503 */               context.setProblem(t);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     ControllerState state;
/*      */   }
/*      */ 
/*      */   private static Throwable getRootCause(Throwable original)
/*      */   {
/*  519 */     if (original == null)
/*  520 */       return null;
/*  521 */     Throwable result = original;
/*  522 */     Throwable cause = result.getCause();
/*  523 */     while (cause != null)
/*      */     {
/*  525 */       result = cause;
/*  526 */       cause = cause.getCause();
/*      */     }
/*  528 */     return result;
/*      */   }
/*      */ 
/*      */   public void checkComplete(Collection<DeploymentContext> errors, Collection<Deployment> missingDeployer) throws DeploymentException
/*      */   {
/*  533 */     Map deploymentsInError = null;
/*  534 */     Collection deploymentsMissingDeployer = null;
/*  535 */     Map contextsInError = null;
/*  536 */     Map contextsMissingDependencies = null;
/*      */ 
/*  538 */     if ((errors != null) && (!errors.isEmpty()))
/*      */     {
/*  540 */       deploymentsInError = new HashMap();
/*  541 */       for (DeploymentContext context : errors) {
/*  542 */         deploymentsInError.put(context.getName(), getRootCause(context.getProblem()));
/*      */       }
/*      */     }
/*  545 */     if ((missingDeployer != null) && (!missingDeployer.isEmpty()))
/*      */     {
/*  547 */       deploymentsMissingDeployer = new HashSet();
/*  548 */       for (Deployment context : missingDeployer) {
/*  549 */         deploymentsMissingDeployer.add(context.getName());
/*      */       }
/*      */     }
/*  552 */     List states = this.controller.getStates();
/*      */ 
/*  554 */     Set notInstalled = this.controller.getNotInstalled();
/*  555 */     if (!notInstalled.isEmpty())
/*      */     {
/*  557 */       for (Iterator i = notInstalled.iterator(); i.hasNext(); )
/*      */       {
/*  559 */         ControllerContext context = (ControllerContext)i.next();
/*  560 */         if (context.getState().equals(context.getRequiredState()))
/*  561 */           i.remove();
/*      */       }
/*  563 */       if (!notInstalled.isEmpty())
/*      */       {
/*  565 */         contextsInError = new HashMap();
/*  566 */         contextsMissingDependencies = new HashMap();
/*  567 */         for (ControllerContext context : notInstalled)
/*      */         {
/*  569 */           checkControllerContext(context, contextsInError, contextsMissingDependencies, states);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  574 */     IncompleteDeployments incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies);
/*  575 */     if (incomplete.isIncomplete())
/*  576 */       throw new IncompleteDeploymentException(incomplete);
/*      */   }
/*      */ 
/*      */   protected final void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, List<ControllerState> states)
/*      */   {
/*  593 */     if (context.getState().equals(ControllerState.ERROR)) {
/*  594 */       contextsInError.put(context.getName().toString(), getRootCause(context.getError()));
/*      */     }
/*      */     else {
/*  597 */       String name = context.getName().toString();
/*  598 */       Set dependencies = new HashSet();
/*  599 */       DependencyInfo dependsInfo = context.getDependencyInfo();
/*  600 */       for (DependencyItem item : dependsInfo.getIDependOn(null))
/*      */       {
/*  602 */         if (!item.isResolved())
/*      */         {
/*  605 */           ControllerState actualState = null;
/*      */ 
/*  607 */           Object iDependOn = item.getIDependOn();
/*      */           String actualStateString;
/*      */           String dependency;
/*      */           String actualStateString;
/*  608 */           if (iDependOn == null)
/*      */           {
/*  610 */             String dependency = "<UNKNOWN>";
/*  611 */             actualStateString = "** UNRESOLVED " + item.toHumanReadableString() + " **";
/*      */           }
/*      */           else
/*      */           {
/*  615 */             dependency = iDependOn.toString();
/*  616 */             ControllerContext other = this.controller.getContext(item.getIDependOn(), null);
/*      */             String actualStateString;
/*  617 */             if (other == null) {
/*  618 */               actualStateString = "** NOT FOUND **";
/*      */             }
/*      */             else {
/*  621 */               actualState = other.getState();
/*  622 */               actualStateString = actualState.getStateString();
/*      */             }
/*      */           }
/*  625 */           ControllerState requiredState = item.getWhenRequired();
/*  626 */           String requiredStateString = requiredState.getStateString();
/*  627 */           int required = states.indexOf(requiredState);
/*  628 */           int actual = actualState == null ? -1 : states.indexOf(actualState);
/*  629 */           if (required > actual)
/*      */           {
/*  631 */             MissingDependency missing = new MissingDependency(name, dependency, requiredStateString, actualStateString);
/*  632 */             dependencies.add(missing);
/*      */           }
/*      */         }
/*      */       }
/*  636 */       contextsMissingDependencies.put(name, dependencies);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkComplete(DeploymentContext[] contexts) throws DeploymentException
/*      */   {
/*  642 */     checkComplete(true, contexts);
/*      */   }
/*      */ 
/*      */   public void checkStructureComplete(DeploymentContext[] contexts) throws DeploymentException
/*      */   {
/*  647 */     checkComplete(false, contexts);
/*      */   }
/*      */ 
/*      */   protected void checkComplete(boolean checkContexts, DeploymentContext[] contexts)
/*      */     throws DeploymentException
/*      */   {
/*  659 */     if (contexts == null) {
/*  660 */       throw new IllegalArgumentException("Null contexts");
/*      */     }
/*  662 */     Map deploymentsInError = new HashMap();
/*  663 */     Collection deploymentsMissingDeployer = new HashSet();
/*  664 */     Map contextsInError = new HashMap();
/*  665 */     Map contextsMissingDependencies = new HashMap();
/*      */ 
/*  667 */     for (DeploymentContext context : contexts)
/*      */     {
/*  669 */       Throwable problem = context.getProblem();
/*  670 */       if (problem != null) {
/*  671 */         deploymentsInError.put(context.getName(), problem);
/*      */       }
/*  673 */       if (!isDeployed(context)) {
/*  674 */         deploymentsMissingDeployer.add(context.getName());
/*      */       }
/*  676 */       if (!checkContexts)
/*      */         continue;
/*  678 */       Set notInstalled = this.controller.getNotInstalled();
/*  679 */       List states = this.controller.getStates();
/*  680 */       checkComplete(context, contextsInError, contextsMissingDependencies, notInstalled, states);
/*      */     }
/*      */ 
/*  685 */     if (deploymentsInError.isEmpty())
/*  686 */       deploymentsInError = null;
/*  687 */     if (deploymentsMissingDeployer.isEmpty())
/*  688 */       deploymentsMissingDeployer = null;
/*  689 */     if (contextsInError.isEmpty())
/*  690 */       contextsInError = null;
/*  691 */     if (contextsMissingDependencies.isEmpty()) {
/*  692 */       contextsMissingDependencies = null;
/*      */     }
/*  694 */     IncompleteDeployments incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies);
/*  695 */     if (incomplete.isIncomplete())
/*  696 */       throw new IncompleteDeploymentException(incomplete);
/*      */   }
/*      */ 
/*      */   protected boolean isDeployed(DeploymentContext context)
/*      */   {
/*  707 */     return (context.isDeployed()) || (DeploymentState.DEPLOYED.equals(context.getState()));
/*      */   }
/*      */ 
/*      */   protected final void checkComplete(DeploymentContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, List<ControllerState> states)
/*      */   {
/*  726 */     DeploymentControllerContext dcc = (DeploymentControllerContext)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
/*  727 */     checkControllerContext(dcc, contextsInError, contextsMissingDependencies, notInstalled, states);
/*      */ 
/*  729 */     Set names = context.getControllerContextNames();
/*      */     Iterator i$;
/*  730 */     if ((names != null) && (!names.isEmpty()))
/*      */     {
/*  732 */       for (i$ = names.iterator(); i$.hasNext(); ) { Object name = i$.next();
/*      */ 
/*  734 */         ControllerContext cc = this.controller.getContext(name, null);
/*  735 */         checkControllerContext(cc, contextsInError, contextsMissingDependencies, notInstalled, states);
/*      */       }
/*      */     }
/*      */ 
/*  739 */     List children = context.getChildren();
/*  740 */     if ((children != null) && (!children.isEmpty()))
/*      */     {
/*  742 */       for (DeploymentContext child : children)
/*  743 */         checkComplete(child, contextsInError, contextsMissingDependencies, notInstalled, states);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, List<ControllerState> states)
/*      */   {
/*  763 */     if (context != null)
/*      */     {
/*  765 */       if ((!context.getState().equals(context.getRequiredState())) && (notInstalled.contains(context)))
/*      */       {
/*  767 */         checkControllerContext(context, contextsInError, contextsMissingDependencies, states);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable
/*      */   {
/*  774 */     DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
/*  775 */     String stageName = toState.getStateString();
/*      */ 
/*  777 */     DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
/*      */     try
/*      */     {
/*  780 */       List theDeployers = getDeployersList(stageName);
/*      */ 
/*  782 */       if (log.isTraceEnabled()) {
/*  783 */         log.trace("Deployers for " + stageName + " " + theDeployers);
/*      */       }
/*  785 */       if (!theDeployers.isEmpty())
/*      */       {
/*  787 */         int i = 0;
/*      */         try
/*      */         {
/*  790 */           while (i < theDeployers.size())
/*      */           {
/*  792 */             Deployer deployer = (Deployer)theDeployers.get(i);
/*  793 */             if (deployer.isParentFirst())
/*  794 */               doInstallParentFirst(deployer, deploymentContext);
/*      */             else
/*  796 */               doInstallParentLast(deployer, deploymentContext);
/*  797 */             i++;
/*      */           }
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/*  802 */           deploymentContext.setState(DeploymentState.ERROR);
/*  803 */           deploymentContext.setProblem(t);
/*      */ 
/*  806 */           for (int j = i - 1; j >= 0; j--)
/*      */           {
/*  808 */             Deployer deployer = (Deployer)theDeployers.get(j);
/*  809 */             if (deployer.isParentFirst())
/*  810 */               doUninstallParentLast(deployer, deploymentContext, true, true);
/*      */             else {
/*  812 */               doUninstallParentFirst(deployer, deploymentContext, true, true);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  817 */           setState(deploymentContext, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
/*  818 */           throw t;
/*      */         }
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  824 */       if ((ControllerState.INSTALLED.equals(toState)) && (DeploymentState.DEPLOYING.equals(deploymentContext.getState())))
/*      */       {
/*  826 */         log.debug("Fully Deployed " + context.getName());
/*  827 */         setState(deploymentContext, DeploymentState.DEPLOYED, null);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doInstallParentFirst(Deployer deployer, DeploymentContext context)
/*      */     throws Throwable
/*      */   {
/*  841 */     List currentComponents = context.getComponents();
/*      */ 
/*  844 */     List components = null;
/*  845 */     if ((currentComponents != null) && (!currentComponents.isEmpty())) {
/*  846 */       components = new ArrayList(currentComponents);
/*      */     }
/*  848 */     DeploymentUnit unit = context.getDeploymentUnit();
/*  849 */     if (isRelevant(deployer, unit, context.isTopLevel(), context.isComponent()))
/*      */     {
/*      */       try
/*      */       {
/*  853 */         deployer.deploy(unit);
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/*  857 */         context.setState(DeploymentState.ERROR);
/*  858 */         context.setProblem(e);
/*  859 */         throw e;
/*      */       }
/*      */     }
/*  862 */     else if (log.isTraceEnabled()) {
/*  863 */       log.trace("Deployer " + deployer + " not relevant for " + context.getName());
/*      */     }
/*  865 */     if (components != null)
/*      */     {
/*      */       try
/*      */       {
/*  869 */         for (int i = 0; i < components.size(); i++)
/*      */         {
/*  871 */           DeploymentContext component = (DeploymentContext)components.get(i);
/*      */           try
/*      */           {
/*  874 */             doInstallParentFirst(deployer, component);
/*      */           }
/*      */           catch (DeploymentException e)
/*      */           {
/*  879 */             for (int j = i - 1; j >= 0; j--)
/*      */             {
/*  881 */               component = (DeploymentContext)components.get(j);
/*  882 */               doUninstallParentLast(deployer, component, false, true);
/*      */             }
/*  884 */             throw e;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/*  891 */         doUninstallParentLast(deployer, context, false, false);
/*  892 */         throw e;
/*      */       }
/*      */     }
/*      */ 
/*  896 */     List children = context.getChildren();
/*  897 */     if (children != null)
/*      */     {
/*      */       try
/*      */       {
/*  901 */         for (int i = 0; i < children.size(); i++)
/*      */         {
/*  903 */           DeploymentContext child = (DeploymentContext)children.get(i);
/*      */           try
/*      */           {
/*  906 */             doInstallParentFirst(deployer, child);
/*      */           }
/*      */           catch (DeploymentException e)
/*      */           {
/*  911 */             for (int j = i - 1; j >= 0; j--)
/*      */             {
/*  913 */               child = (DeploymentContext)children.get(j);
/*  914 */               doUninstallParentLast(deployer, child, true, true);
/*      */             }
/*  916 */             throw e;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/*  923 */         doUninstallParentLast(deployer, context, false, true);
/*  924 */         throw e;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doInstallParentLast(Deployer deployer, DeploymentContext context)
/*      */     throws Throwable
/*      */   {
/*  938 */     List children = context.getChildren();
/*  939 */     for (int i = 0; i < children.size(); i++)
/*      */     {
/*  941 */       DeploymentContext child = (DeploymentContext)children.get(i);
/*      */       try
/*      */       {
/*  944 */         doInstallParentLast(deployer, child);
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/*  949 */         for (int j = i - 1; j >= 0; j--)
/*      */         {
/*  951 */           child = (DeploymentContext)children.get(j);
/*  952 */           doUninstallParentFirst(deployer, child, true, true);
/*      */         }
/*  954 */         throw e;
/*      */       }
/*      */     }
/*      */ 
/*  958 */     List components = context.getComponents();
/*  959 */     if (components != null)
/*      */     {
/*      */       try
/*      */       {
/*  963 */         for (int i = 0; i < components.size(); i++)
/*      */         {
/*  965 */           DeploymentContext component = (DeploymentContext)components.get(i);
/*      */           try
/*      */           {
/*  968 */             doInstallParentLast(deployer, component);
/*      */           }
/*      */           catch (DeploymentException e)
/*      */           {
/*  973 */             for (int j = i - 1; j >= 0; j--)
/*      */             {
/*  975 */               component = (DeploymentContext)components.get(j);
/*  976 */               doUninstallParentFirst(deployer, component, true, true);
/*      */             }
/*  978 */             throw e;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/*  985 */         doUninstallParentFirst(deployer, context, false, false);
/*  986 */         throw e;
/*      */       }
/*      */     }
/*      */ 
/*  990 */     DeploymentUnit unit = context.getDeploymentUnit();
/*  991 */     if (isRelevant(deployer, unit, context.isTopLevel(), context.isComponent()))
/*      */     {
/*      */       try
/*      */       {
/*  995 */         deployer.deploy(unit);
/*      */       }
/*      */       catch (DeploymentException e)
/*      */       {
/* 1000 */         doUninstallParentFirst(deployer, context, false, true);
/* 1001 */         context.setState(DeploymentState.ERROR);
/* 1002 */         context.setProblem(e);
/* 1003 */         throw e;
/*      */       }
/*      */     }
/* 1006 */     else if (log.isTraceEnabled())
/* 1007 */       log.trace("Deployer " + deployer + " not relevant for " + context.getName());
/*      */   }
/*      */ 
/*      */   public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState)
/*      */   {
/* 1012 */     DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
/* 1013 */     String stageName = fromState.getStateString();
/*      */ 
/* 1015 */     DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
/* 1016 */     List theDeployers = getDeployersList(stageName);
/*      */ 
/* 1018 */     if (log.isTraceEnabled()) {
/* 1019 */       log.trace("Deployers for " + stageName + " " + theDeployers);
/*      */     }
/* 1021 */     if (!theDeployers.isEmpty())
/*      */     {
/* 1023 */       for (int i = theDeployers.size() - 1; i >= 0; i--)
/*      */       {
/* 1025 */         Deployer deployer = (Deployer)theDeployers.get(i);
/* 1026 */         if (deployer.isParentFirst())
/* 1027 */           doUninstallParentLast(deployer, deploymentContext, true, true);
/*      */         else
/* 1029 */           doUninstallParentFirst(deployer, deploymentContext, true, true);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doUninstallParentLast(Deployer deployer, DeploymentContext context, boolean doChildren, boolean doComponents)
/*      */   {
/* 1044 */     if (doChildren)
/*      */     {
/* 1046 */       List children = context.getChildren();
/* 1047 */       if ((children != null) && (!children.isEmpty()))
/*      */       {
/* 1049 */         for (int i = children.size() - 1; i >= 0; i--)
/*      */         {
/* 1051 */           DeploymentContext child = (DeploymentContext)children.get(i);
/* 1052 */           doUninstallParentLast(deployer, child, true, true);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1057 */     if (doComponents)
/*      */     {
/* 1059 */       List components = context.getComponents();
/* 1060 */       if ((components != null) && (!components.isEmpty()))
/*      */       {
/* 1062 */         for (int i = components.size() - 1; i >= 0; i--)
/*      */         {
/* 1064 */           DeploymentContext component = (DeploymentContext)components.get(i);
/* 1065 */           doUninstallParentLast(deployer, component, false, true);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1070 */     DeploymentUnit unit = context.getDeploymentUnit();
/* 1071 */     if (isRelevant(deployer, unit, context.isTopLevel(), context.isComponent()))
/* 1072 */       deployer.undeploy(unit);
/* 1073 */     else if (log.isTraceEnabled())
/* 1074 */       log.trace("Deployer " + deployer + " not relevant for " + context.getName());
/*      */   }
/*      */ 
/*      */   protected void doUninstallParentFirst(Deployer deployer, DeploymentContext context, boolean doContext, boolean doComponents)
/*      */   {
/* 1087 */     if (doContext)
/*      */     {
/* 1089 */       DeploymentUnit unit = context.getDeploymentUnit();
/* 1090 */       if (isRelevant(deployer, unit, context.isTopLevel(), context.isComponent()))
/* 1091 */         deployer.undeploy(unit);
/* 1092 */       else if (log.isTraceEnabled()) {
/* 1093 */         log.trace("Deployer " + deployer + " not relevant for " + context.getName());
/*      */       }
/*      */     }
/* 1096 */     if (doComponents)
/*      */     {
/* 1098 */       List components = context.getComponents();
/* 1099 */       if ((components != null) && (!components.isEmpty()))
/*      */       {
/* 1101 */         for (int i = components.size() - 1; i >= 0; i--)
/*      */         {
/* 1103 */           DeploymentContext component = (DeploymentContext)components.get(i);
/* 1104 */           doUninstallParentFirst(deployer, component, true, true);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1109 */     List children = context.getChildren();
/* 1110 */     if ((children != null) && (!children.isEmpty()))
/*      */     {
/* 1112 */       for (int i = children.size() - 1; i >= 0; i--)
/*      */       {
/* 1114 */         DeploymentContext child = (DeploymentContext)children.get(i);
/* 1115 */         doUninstallParentFirst(deployer, child, true, true);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected synchronized List<Deployer> getDeployersList(String stageName)
/*      */   {
/* 1128 */     List deployers = (List)this.deployersByStage.get(stageName);
/* 1129 */     if ((deployers == null) || (deployers.isEmpty())) {
/* 1130 */       return Collections.emptyList();
/*      */     }
/* 1132 */     return deployers;
/*      */   }
/*      */ 
/*      */   protected boolean isRelevant(Deployer deployer, DeploymentUnit unit, boolean isTopLevel, boolean isComponent)
/*      */   {
/* 1147 */     if ((deployer.isTopLevelOnly()) && (!isTopLevel)) {
/* 1148 */       return false;
/*      */     }
/*      */ 
/* 1151 */     if ((deployer.isComponentsOnly()) && (!isComponent)) {
/* 1152 */       return false;
/*      */     }
/*      */ 
/* 1155 */     if ((!deployer.isWantComponents()) && (isComponent)) {
/* 1156 */       return false;
/*      */     }
/* 1158 */     if (!deployer.isAllInputs())
/*      */     {
/* 1161 */       Class input = deployer.getInput();
/* 1162 */       if ((input != null) && (unit.getAttachment(input) == null))
/* 1163 */         return false;
/*      */     }
/* 1165 */     return true;
/*      */   }
/*      */ 
/*      */   protected List<Deployer> insert(List<Deployer> original, Deployer newDeployer)
/*      */   {
/* 1177 */     DeployerSorter sorter = DeployerSorterFactory.newSorter();
/* 1178 */     return sorter.sortDeployers(original, newDeployer);
/*      */   }
/*      */ 
/*      */   private static void setState(DeploymentContext context, DeploymentState state, DeploymentState ifState)
/*      */   {
/* 1190 */     if ((ifState == null) || (ifState.equals(context.getState())))
/* 1191 */       context.setState(state);
/* 1192 */     List children = context.getChildren();
/* 1193 */     if ((children != null) && (!children.isEmpty()))
/*      */     {
/* 1195 */       for (DeploymentContext child : children)
/* 1196 */         setState(child, state, ifState);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static void removeClassLoader(DeploymentContext context)
/*      */   {
/* 1207 */     context.removeClassLoader();
/* 1208 */     List children = context.getChildren();
/* 1209 */     if ((children != null) && (!children.isEmpty()))
/*      */     {
/* 1211 */       for (DeploymentContext child : children)
/* 1212 */         removeClassLoader(child);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static void cleanup(DeploymentContext context)
/*      */   {
/* 1223 */     context.cleanup();
/* 1224 */     List children = context.getChildren();
/* 1225 */     if ((children != null) && (!children.isEmpty()))
/*      */     {
/* 1227 */       for (DeploymentContext child : children)
/* 1228 */         cleanup(child);
/*      */     }
/* 1230 */     List components = context.getComponents();
/* 1231 */     if ((components != null) && (!components.isEmpty()))
/*      */     {
/* 1233 */       for (DeploymentContext component : components)
/* 1234 */         cleanup(component);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.deployers.DeployersImpl
 * JD-Core Version:    0.6.0
 */