/*     */ package org.jboss.deployers.plugins.classloading;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.classloader.spi.ParentPolicy;
/*     */ import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.Capability;
/*     */ import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.deployers.structure.spi.classloading.PackageCapability;
/*     */ import org.jboss.deployers.structure.spi.classloading.Requirement;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class Module
/*     */ {
/*     */   private Domain domain;
/*     */   private DeploymentUnit deploymentUnit;
/*     */   private ClassLoaderMetaData metadata;
/*     */   private List<RequirementDependencyItem> requirementDependencies;
/*     */   private URL dynamicClassRoot;
/*     */ 
/*     */   public Module(Domain domain, DeploymentUnit deploymentUnit, ClassLoaderMetaData metadata)
/*     */   {
/*  76 */     if (domain == null)
/*  77 */       throw new IllegalArgumentException("Null domain");
/*  78 */     if (deploymentUnit == null)
/*  79 */       throw new IllegalArgumentException("Null unit");
/*  80 */     if (metadata == null)
/*  81 */       throw new IllegalArgumentException("Null metadata");
/*  82 */     this.domain = domain;
/*  83 */     this.deploymentUnit = deploymentUnit;
/*  84 */     this.metadata = metadata;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  94 */     return this.deploymentUnit.getName();
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit()
/*     */   {
/* 104 */     return this.deploymentUnit;
/*     */   }
/*     */ 
/*     */   public Domain getDomain()
/*     */   {
/* 114 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public ClassLoaderMetaData getMetadata()
/*     */   {
/* 124 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public String getDomainName()
/*     */   {
/* 134 */     return getDomain().getName();
/*     */   }
/*     */ 
/*     */   public String getParentDomain()
/*     */   {
/* 144 */     String parentDomain = getMetadata().getParentDomain();
/* 145 */     if (parentDomain == null)
/*     */     {
/* 147 */       if (!"<DEFAULT>".equals(getDomainName()))
/* 148 */         return "<DEFAULT>";
/*     */     }
/* 150 */     return parentDomain;
/*     */   }
/*     */ 
/*     */   public ExportAll getExportAll()
/*     */   {
/* 160 */     return getMetadata().getExportAll();
/*     */   }
/*     */ 
/*     */   public boolean isImportAll()
/*     */   {
/* 170 */     return getMetadata().isImportAll();
/*     */   }
/*     */ 
/*     */   public ParentPolicy getParentPolicy()
/*     */   {
/* 180 */     if (getMetadata().isJ2seClassLoadingCompliance()) {
/* 181 */       return ParentPolicy.BEFORE;
/*     */     }
/* 183 */     return ParentPolicy.AFTER;
/*     */   }
/*     */ 
/*     */   public List<? extends DelegateLoader> getDelegates()
/*     */   {
/* 194 */     if ((this.requirementDependencies == null) || (this.requirementDependencies.isEmpty())) {
/* 195 */       return null;
/*     */     }
/* 197 */     List result = new ArrayList();
/* 198 */     for (RequirementDependencyItem item : this.requirementDependencies)
/*     */     {
/* 200 */       String name = (String)item.getIDependOn();
/* 201 */       Module module = this.domain.getModule(name);
/* 202 */       if (module == null)
/* 203 */         throw new IllegalStateException("Module not found with name: " + name);
/* 204 */       result.add(module.getDelegateLoader());
/*     */     }
/* 206 */     return result;
/*     */   }
/*     */ 
/*     */   public DelegateLoader getDelegateLoader()
/*     */   {
/* 217 */     ClassLoaderPolicy policy = (ClassLoaderPolicy)this.deploymentUnit.getAttachment(ClassLoaderPolicy.class);
/* 218 */     if (policy == null)
/* 219 */       throw new IllegalStateException("No policy for " + this.deploymentUnit.getName());
/* 220 */     return new FilteredDelegateLoader(policy);
/*     */   }
/*     */ 
/*     */   public String[] getPackageNames()
/*     */   {
/* 226 */     List capabilities = this.metadata.getCapabilities();
/* 227 */     if (capabilities == null) {
/* 228 */       return new String[0];
/*     */     }
/* 230 */     List packageNames = new ArrayList();
/* 231 */     for (Capability capability : capabilities)
/*     */     {
/* 233 */       if ((capability instanceof PackageCapability))
/* 234 */         packageNames.add(((PackageCapability)capability).getName());
/*     */     }
/* 236 */     return (String[])packageNames.toArray(new String[packageNames.size()]);
/*     */   }
/*     */ 
/*     */   public void createDependencies()
/*     */   {
/* 244 */     List requirements = this.metadata.getRequirements();
/* 245 */     if (requirements != null)
/*     */     {
/* 247 */       this.requirementDependencies = new ArrayList();
/* 248 */       for (Requirement requirement : requirements)
/*     */       {
/* 250 */         RequirementDependencyItem item = new RequirementDependencyItem(this, requirement);
/* 251 */         this.requirementDependencies.add(item);
/* 252 */         this.deploymentUnit.addIDependOn(item);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object resolve(Controller controller, Requirement requirement)
/*     */   {
/* 266 */     return this.domain.resolve(controller, this, requirement);
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void release()
/*     */   {
/* 281 */     this.domain.removeModule(this);
/*     */   }
/*     */ 
/*     */   public URL getDynamicClassRoot()
/*     */   {
/* 286 */     if (this.dynamicClassRoot == null)
/*     */     {
/*     */       try
/*     */       {
/* 290 */         this.dynamicClassRoot = new URL("vfsmemory://" + new GUID());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 294 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 297 */     return this.dynamicClassRoot;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.Module
 * JD-Core Version:    0.6.0
 */