/*     */ package org.jboss.deployers.plugins.classloading;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.deployers.structure.spi.classloading.Version;
/*     */ 
/*     */ public class ClassLoading
/*     */ {
/*  42 */   private Map<String, Domain> domains = new ConcurrentHashMap();
/*     */ 
/*     */   public void addDeploymentUnit(DeploymentUnit deploymentUnit)
/*     */   {
/*  52 */     if (deploymentUnit == null) {
/*  53 */       throw new IllegalArgumentException("Null deployment unit");
/*     */     }
/*  55 */     ClassLoaderMetaData metadata = (ClassLoaderMetaData)deploymentUnit.getAttachment(ClassLoaderMetaData.class);
/*  56 */     if (metadata == null)
/*     */     {
/*  59 */       metadata = new ClassLoaderMetaData();
/*  60 */       metadata.setName(deploymentUnit.getName());
/*  61 */       metadata.setExportAll(ExportAll.NON_EMPTY);
/*  62 */       metadata.setImportAll(true);
/*  63 */       metadata.setVersion(Version.DEFAULT_VERSION);
/*  64 */       deploymentUnit.addAttachment(ClassLoaderMetaData.class, metadata);
/*     */     }
/*     */ 
/*  67 */     String domainName = metadata.getDomain();
/*  68 */     if (domainName == null)
/*     */     {
/*  70 */       domainName = "<DEFAULT>";
/*  71 */       metadata.setDomain(domainName);
/*     */     }
/*     */     Domain domain;
/*  75 */     synchronized (this.domains)
/*     */     {
/*  77 */       domain = (Domain)this.domains.get(domainName);
/*  78 */       if (domain == null)
/*     */       {
/*  80 */         domain = new Domain(domainName);
/*  81 */         this.domains.put(domainName, domain);
/*     */       }
/*     */     }
/*     */ 
/*  85 */     domain.addDeploymentUnit(deploymentUnit, metadata);
/*     */   }
/*     */ 
/*     */   public void removeDeploymentUnit(DeploymentUnit deploymentUnit)
/*     */   {
/*  96 */     if (deploymentUnit == null) {
/*  97 */       throw new IllegalArgumentException("Null deployment context");
/*     */     }
/*  99 */     Module module = (Module)deploymentUnit.getAttachment(Module.class);
/* 100 */     if (module == null)
/* 101 */       throw new IllegalStateException("Deployment Unit has no module: " + deploymentUnit);
/* 102 */     module.release();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.ClassLoading
 * JD-Core Version:    0.6.0
 */