/*    */ package org.jboss.deployers.plugins.classloading;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractOptionalRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
/*    */ 
/*    */ public class AbstractClassLoaderDesribeDeployer extends AbstractOptionalRealDeployer<ClassLoaderMetaData>
/*    */ {
/*    */   private ClassLoading classLoading;
/*    */ 
/*    */   public AbstractClassLoaderDesribeDeployer()
/*    */   {
/* 46 */     super(ClassLoaderMetaData.class);
/* 47 */     setStage(DeploymentStages.DESCRIBE);
/*    */   }
/*    */ 
/*    */   public ClassLoading getClassLoading()
/*    */   {
/* 57 */     return this.classLoading;
/*    */   }
/*    */ 
/*    */   public void setClassLoading(ClassLoading classLoading)
/*    */   {
/* 67 */     this.classLoading = classLoading;
/*    */   }
/*    */ 
/*    */   public void create()
/*    */     throws Exception
/*    */   {
/* 77 */     if (this.classLoading == null)
/* 78 */       throw new DeploymentException("Classloading has not been configured");
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit, ClassLoaderMetaData deployment) throws DeploymentException
/*    */   {
/* 83 */     this.classLoading.addDeploymentUnit(unit);
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, ClassLoaderMetaData deployment)
/*    */   {
/* 88 */     this.classLoading.removeDeploymentUnit(unit);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.AbstractClassLoaderDesribeDeployer
 * JD-Core Version:    0.6.0
 */