/*     */ package org.jboss.dependency.spi.helpers;
/*     */ 
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class UnmodifiableScopeInfo
/*     */   implements ScopeInfo
/*     */ {
/*     */   private ScopeInfo delegate;
/*     */ 
/*     */   public UnmodifiableScopeInfo(ScopeInfo delegate)
/*     */   {
/*  50 */     if (delegate == null)
/*  51 */       throw new IllegalArgumentException("Null delegate");
/*  52 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public void addMetaData(MutableMetaDataRepository repository, ControllerContext context)
/*     */   {
/*  57 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ 
/*     */   public void removeMetaData(MutableMetaDataRepository repository, ControllerContext context)
/*     */   {
/*  62 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, Scope scope)
/*     */   {
/*  67 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/*  72 */     return this.delegate.getMetaData();
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/*  77 */     return this.delegate.getScope();
/*     */   }
/*     */ 
/*     */   public void setScope(ScopeKey key)
/*     */   {
/*  82 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope()
/*     */   {
/*  87 */     return this.delegate.getScope();
/*     */   }
/*     */ 
/*     */   public void setMutableScope(ScopeKey key)
/*     */   {
/*  92 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ 
/*     */   public ScopeKey getInstallScope()
/*     */   {
/*  97 */     return this.delegate.getInstallScope();
/*     */   }
/*     */ 
/*     */   public void setInstallScope(ScopeKey key)
/*     */   {
/* 102 */     throw new UnsupportedOperationException("Cannot modify immutable");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.helpers.UnmodifiableScopeInfo
 * JD-Core Version:    0.6.0
 */