/*     */ package org.jboss.dependency.spi;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class ControllerState extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*  43 */   public static final ControllerState ERROR = new ControllerState("**ERROR**");
/*     */ 
/*  46 */   public static final ControllerState NOT_INSTALLED = new ControllerState("Not Installed");
/*     */ 
/*  49 */   public static final ControllerState PRE_INSTALL = new ControllerState("PreInstall");
/*     */ 
/*  52 */   public static final ControllerState DESCRIBED = new ControllerState("Described");
/*     */ 
/*  55 */   public static final ControllerState INSTANTIATED = new ControllerState("Instantiated");
/*     */ 
/*  58 */   public static final ControllerState CONFIGURED = new ControllerState("Configured");
/*     */ 
/*  61 */   public static final ControllerState CREATE = new ControllerState("Create");
/*     */ 
/*  64 */   public static final ControllerState START = new ControllerState("Start");
/*     */ 
/*  67 */   public static final ControllerState INSTALLED = new ControllerState("Installed");
/*     */   protected final String stateString;
/*  72 */   private static Map<String, ControllerState> values = new HashMap();
/*     */ 
/*     */   public ControllerState(String stateString)
/*     */   {
/*  94 */     if (stateString == null)
/*  95 */       throw new IllegalArgumentException("Null state string");
/*  96 */     this.stateString = stateString;
/*     */   }
/*     */ 
/*     */   public String getStateString()
/*     */   {
/* 106 */     return this.stateString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 111 */     if ((object == null) || (!(object instanceof ControllerState)))
/* 112 */       return false;
/* 113 */     ControllerState other = (ControllerState)object;
/* 114 */     return this.stateString.equals(other.stateString);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 119 */     buffer.append(this.stateString);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 124 */     return this.stateString.hashCode();
/*     */   }
/*     */ 
/*     */   protected Object readResolve() throws ObjectStreamException
/*     */   {
/* 129 */     return values.get(this.stateString);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  76 */     values.put(ERROR.getStateString(), ERROR);
/*  77 */     values.put(NOT_INSTALLED.getStateString(), NOT_INSTALLED);
/*  78 */     values.put(PRE_INSTALL.getStateString(), PRE_INSTALL);
/*  79 */     values.put(DESCRIBED.getStateString(), DESCRIBED);
/*  80 */     values.put(INSTANTIATED.getStateString(), INSTANTIATED);
/*  81 */     values.put(CONFIGURED.getStateString(), CONFIGURED);
/*  82 */     values.put(CREATE.getStateString(), CREATE);
/*  83 */     values.put(START.getStateString(), START);
/*  84 */     values.put(INSTALLED.getStateString(), INSTALLED);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.ControllerState
 * JD-Core Version:    0.6.0
 */