/*    */ package org.jboss.dependency.plugins;
/*    */ 
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.util.JBossStringBuilder;
/*    */ 
/*    */ public class SingleCallbackItem<T> extends OwnerCallbackItem<T, InvokeDispatchContext>
/*    */ {
/*    */   protected String signature;
/*    */ 
/*    */   public SingleCallbackItem(T name, InvokeDispatchContext owner, String method)
/*    */   {
/* 41 */     this(name, owner, method, null);
/*    */   }
/*    */ 
/*    */   public SingleCallbackItem(T name, InvokeDispatchContext owner, String method, String signature)
/*    */   {
/* 46 */     this(name, null, null, owner, method, signature);
/*    */   }
/*    */ 
/*    */   public SingleCallbackItem(T name, ControllerState whenRequired, ControllerState dependentState, InvokeDispatchContext owner, String method)
/*    */   {
/* 51 */     this(name, whenRequired, dependentState, owner, method, null);
/*    */   }
/*    */ 
/*    */   public SingleCallbackItem(T name, ControllerState whenRequired, ControllerState dependentState, InvokeDispatchContext owner, String method, String signature)
/*    */   {
/* 56 */     super(name, whenRequired, dependentState, method, owner);
/* 57 */     this.signature = signature;
/*    */   }
/*    */ 
/*    */   protected void changeCallback(ControllerContext context, boolean isInstallPhase) throws Throwable
/*    */   {
/* 62 */     Object target = context.getTarget();
/* 63 */     if (target != null)
/*    */     {
/* 65 */       if (this.signature == null)
/* 66 */         this.signature = target.getClass().getName();
/* 67 */       ((InvokeDispatchContext)this.owner).invoke(getAttributeName(), new Object[] { target }, new String[] { this.signature });
/*    */     }
/*    */     else {
/* 70 */       this.log.warn("Null target, cannot invoke non-static method: " + this);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void toString(JBossStringBuilder buffer) {
/* 75 */     super.toString(buffer);
/* 76 */     buffer.append(" signature=").append(this.signature);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.SingleCallbackItem
 * JD-Core Version:    0.6.0
 */