/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.LifecycleCallbackItem;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractDependencyInfo extends JBossObject
/*     */   implements DependencyInfo
/*     */ {
/*  48 */   private Set<DependencyItem> iDependOn = new CopyOnWriteArraySet();
/*     */ 
/*  51 */   private Set<DependencyItem> dependsOnMe = new CopyOnWriteArraySet();
/*     */ 
/*  54 */   private Set<DependencyItem> unresolved = new CopyOnWriteArraySet();
/*     */ 
/*  57 */   private Set<CallbackItem<?>> installCallbacks = new CopyOnWriteArraySet();
/*     */ 
/*  60 */   private Set<CallbackItem<?>> uninstallCallbacks = new CopyOnWriteArraySet();
/*     */ 
/*  63 */   private List<LifecycleCallbackItem> lifecycleCallbacks = new CopyOnWriteArrayList();
/*     */ 
/*  66 */   private boolean autowireCandidate = true;
/*     */ 
/*     */   public Set<DependencyItem> getIDependOn(Class<?> type)
/*     */   {
/*  77 */     if ((type == null) || (this.iDependOn.isEmpty())) {
/*  78 */       return this.iDependOn;
/*     */     }
/*     */ 
/*  81 */     HashSet set = new HashSet();
/*  82 */     for (DependencyItem item : this.iDependOn)
/*     */     {
/*  84 */       if (type.isInstance(item))
/*  85 */         set.add(item);
/*     */     }
/*  87 */     return set;
/*     */   }
/*     */ 
/*     */   public void addIDependOn(DependencyItem dependency)
/*     */   {
/*  93 */     this.iDependOn.add(dependency);
/*  94 */     this.unresolved.add(dependency);
/*  95 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void removeIDependOn(DependencyItem dependency)
/*     */   {
/* 100 */     this.iDependOn.remove(dependency);
/* 101 */     this.unresolved.remove(dependency);
/* 102 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Set<DependencyItem> getDependsOnMe(Class<?> type)
/*     */   {
/* 107 */     if ((type == null) || (this.dependsOnMe.isEmpty())) {
/* 108 */       return this.dependsOnMe;
/*     */     }
/*     */ 
/* 111 */     HashSet set = new HashSet();
/* 112 */     for (DependencyItem item : this.dependsOnMe)
/*     */     {
/* 114 */       if (type.isInstance(item))
/* 115 */         set.add(item);
/*     */     }
/* 117 */     return set;
/*     */   }
/*     */ 
/*     */   public void addDependsOnMe(DependencyItem dependency)
/*     */   {
/* 123 */     this.dependsOnMe.add(dependency);
/* 124 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void removeDependsOnMe(DependencyItem dependency)
/*     */   {
/* 129 */     this.dependsOnMe.remove(dependency);
/* 130 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public boolean resolveDependencies(Controller controller, ControllerState state)
/*     */   {
/* 135 */     boolean resolved = true;
/* 136 */     if (!this.unresolved.isEmpty())
/*     */     {
/* 138 */       for (DependencyItem item : this.unresolved)
/*     */       {
/* 140 */         if ((state.equals(item.getWhenRequired())) && (!item.resolve(controller)))
/*     */         {
/* 142 */           resolved = false;
/* 143 */           break;
/*     */         }
/*     */       }
/*     */     }
/* 147 */     return resolved;
/*     */   }
/*     */ 
/*     */   public Set<DependencyItem> getUnresolvedDependencies()
/*     */   {
/* 152 */     return this.unresolved;
/*     */   }
/*     */ 
/*     */   public <T> void addInstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 157 */     this.installCallbacks.add(callbackItem);
/* 158 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public <T> void removeInstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 163 */     this.installCallbacks.remove(callbackItem);
/* 164 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Set<CallbackItem<?>> getInstallItems()
/*     */   {
/* 169 */     return this.installCallbacks;
/*     */   }
/*     */ 
/*     */   public <T> void addUninstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 174 */     this.uninstallCallbacks.add(callbackItem);
/* 175 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public <T> void removeUninstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 180 */     this.uninstallCallbacks.remove(callbackItem);
/* 181 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Set<CallbackItem<?>> getUninstallItems()
/*     */   {
/* 186 */     return this.uninstallCallbacks;
/*     */   }
/*     */ 
/*     */   public void addLifecycleCallback(LifecycleCallbackItem lifecycleCallbackItem)
/*     */   {
/* 191 */     this.lifecycleCallbacks.add(lifecycleCallbackItem);
/*     */   }
/*     */ 
/*     */   public List<LifecycleCallbackItem> getLifecycleCallbacks()
/*     */   {
/* 196 */     return this.lifecycleCallbacks;
/*     */   }
/*     */ 
/*     */   public boolean isAutowireCandidate()
/*     */   {
/* 201 */     return this.autowireCandidate;
/*     */   }
/*     */ 
/*     */   public void setAutowireCandidate(boolean candidate)
/*     */   {
/* 206 */     this.autowireCandidate = candidate;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 211 */     buffer.append("idependOn=").append(this.iDependOn);
/* 212 */     if (!this.unresolved.isEmpty())
/* 213 */       buffer.append(" unresolved=").append(this.unresolved);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractDependencyInfo
 * JD-Core Version:    0.6.0
 */