/*    */ package org.jboss.dependency.plugins;
/*    */ 
/*    */ import java.util.Map;
/*    */ import org.jboss.dependency.plugins.action.ControllerContextAction;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerContextActions;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ 
/*    */ public class AbstractControllerContextActions
/*    */   implements ControllerContextActions
/*    */ {
/*    */   private Map<ControllerState, ControllerContextAction> actions;
/*    */ 
/*    */   public AbstractControllerContextActions(Map<ControllerState, ControllerContextAction> actions)
/*    */   {
/* 44 */     this.actions = actions;
/*    */   }
/*    */ 
/*    */   public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable
/*    */   {
/* 49 */     ControllerContextAction action = getAction(context, toState);
/* 50 */     if (action != null)
/* 51 */       action.install(context);
/*    */   }
/*    */ 
/*    */   public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState)
/*    */   {
/* 56 */     ControllerContextAction action = getAction(context, fromState);
/* 57 */     if (action != null)
/* 58 */       action.uninstall(context);
/*    */   }
/*    */ 
/*    */   protected ControllerContextAction getAction(ControllerContext context, ControllerState state)
/*    */   {
/* 70 */     return (ControllerContextAction)this.actions.get(state);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractControllerContextActions
 * JD-Core Version:    0.6.0
 */