/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerContextActions;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractControllerContext extends JBossObject
/*     */   implements ControllerContext
/*     */ {
/*     */   private Object name;
/*     */   private Set<Object> aliases;
/*     */   private Object target;
/*     */   private Controller controller;
/*  61 */   private ControllerState state = ControllerState.ERROR;
/*     */ 
/*  64 */   private ControllerState requiredState = ControllerState.NOT_INSTALLED;
/*     */ 
/*  67 */   private ControllerMode mode = ControllerMode.AUTOMATIC;
/*     */   private ControllerContextActions actions;
/*     */   private DependencyInfo dependencies;
/*     */   private ScopeInfo scopeInfo;
/*     */   private Throwable error;
/*     */ 
/*     */   public AbstractControllerContext(Object name, ControllerContextActions actions)
/*     */   {
/*  89 */     this(name, null, actions, null, null);
/*     */   }
/*     */ 
/*     */   public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies)
/*     */   {
/* 101 */     this(name, null, actions, dependencies, null);
/*     */   }
/*     */ 
/*     */   public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies, Object target)
/*     */   {
/* 114 */     this(name, null, actions, dependencies, target);
/*     */   }
/*     */ 
/*     */   public AbstractControllerContext(Object name, Set<Object> aliases, ControllerContextActions actions, DependencyInfo dependencies, Object target)
/*     */   {
/* 128 */     if (name == null)
/* 129 */       throw new IllegalArgumentException("Null name");
/* 130 */     if (actions == null) {
/* 131 */       throw new IllegalArgumentException("Null actions");
/*     */     }
/* 133 */     this.name = name;
/* 134 */     this.actions = actions;
/* 135 */     if (dependencies == null)
/* 136 */       this.dependencies = new AbstractDependencyInfo();
/*     */     else
/* 138 */       this.dependencies = dependencies;
/* 139 */     this.target = target;
/* 140 */     setAliases(aliases);
/* 141 */     initScopeInfo();
/*     */   }
/*     */ 
/*     */   public AbstractControllerContext(Object name, Object target)
/*     */   {
/* 152 */     if (name == null) {
/* 153 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 155 */     this.name = name;
/* 156 */     this.target = target;
/* 157 */     initScopeInfo();
/*     */   }
/*     */ 
/*     */   public Object getName()
/*     */   {
/* 162 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(Object name)
/*     */   {
/* 172 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public Set<Object> getAliases()
/*     */   {
/* 177 */     return this.aliases;
/*     */   }
/*     */ 
/*     */   public void setAliases(Set<Object> aliases)
/*     */   {
/*     */     Object alias;
/*     */     Iterator i$;
/* 195 */     if (aliases == null)
/*     */     {
/* 198 */       Object alias = needsAnAlias(this.name);
/*     */ 
/* 200 */       if (alias == null) {
/* 201 */         this.aliases = null;
/*     */       }
/*     */       else {
/* 204 */         this.aliases = Collections.singleton(alias);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 209 */       this.aliases = new HashSet();
/*     */ 
/* 211 */       alias = needsAnAlias(this.name);
/* 212 */       if (alias != null) {
/* 213 */         this.aliases.add(alias);
/*     */       }
/* 215 */       for (i$ = aliases.iterator(); i$.hasNext(); ) { Object passedAlias = i$.next();
/*     */ 
/* 217 */         this.aliases.add(passedAlias);
/* 218 */         alias = needsAnAlias(passedAlias);
/* 219 */         if (alias != null)
/* 220 */           this.aliases.add(alias);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public ControllerState getState()
/*     */   {
/* 227 */     return this.state;
/*     */   }
/*     */ 
/*     */   public ControllerState getRequiredState()
/*     */   {
/* 232 */     return this.requiredState;
/*     */   }
/*     */ 
/*     */   public void setRequiredState(ControllerState state)
/*     */   {
/* 237 */     this.requiredState = state;
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 242 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 247 */     this.mode = mode;
/* 248 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Controller getController()
/*     */   {
/* 258 */     return this.controller;
/*     */   }
/*     */ 
/*     */   public void setController(Controller controller)
/*     */   {
/* 263 */     this.controller = controller;
/* 264 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 269 */     return this.dependencies;
/*     */   }
/*     */ 
/*     */   public ScopeInfo getScopeInfo()
/*     */   {
/* 274 */     return this.scopeInfo;
/*     */   }
/*     */ 
/*     */   public void setScopeInfo(ScopeInfo scopeInfo)
/*     */   {
/* 284 */     if (scopeInfo == null)
/* 285 */       throw new IllegalArgumentException("Null scope info");
/* 286 */     this.scopeInfo = scopeInfo;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/* 291 */     return this.target;
/*     */   }
/*     */ 
/*     */   public void setTarget(Object target)
/*     */   {
/* 301 */     this.target = target;
/* 302 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Throwable getError()
/*     */   {
/* 307 */     return this.error;
/*     */   }
/*     */ 
/*     */   public void setError(Throwable error)
/*     */   {
/* 312 */     this.error = error;
/* 313 */     this.state = ControllerState.ERROR;
/* 314 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setState(ControllerState state)
/*     */   {
/* 319 */     this.state = state;
/* 320 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void install(ControllerState fromState, ControllerState toState) throws Throwable
/*     */   {
/* 325 */     this.error = null;
/* 326 */     flushJBossObjectCache();
/* 327 */     this.actions.install(this, fromState, toState);
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerState fromState, ControllerState toState)
/*     */   {
/* 332 */     flushJBossObjectCache();
/* 333 */     this.actions.uninstall(this, fromState, toState);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 338 */     buffer.append("name=").append(this.name);
/* 339 */     if (this.aliases != null)
/* 340 */       buffer.append(" aliases=").append(this.aliases);
/* 341 */     buffer.append(" target=").append(this.target);
/* 342 */     if ((this.error != null) || (!this.state.equals(ControllerState.ERROR)))
/* 343 */       buffer.append(" state=").append(this.state.getStateString());
/* 344 */     if (!ControllerMode.AUTOMATIC.equals(this.mode))
/*     */     {
/* 346 */       buffer.append(" mode=").append(this.mode.getModeString());
/* 347 */       buffer.append(" requiredState=").append(this.requiredState.getStateString());
/*     */     }
/* 349 */     if (this.dependencies != null)
/* 350 */       buffer.append(" depends=").append(this.dependencies);
/* 351 */     if (this.error != null)
/*     */     {
/* 353 */       StringWriter stringWriter = new StringWriter();
/* 354 */       PrintWriter writer = new PrintWriter(stringWriter);
/* 355 */       this.error.printStackTrace(writer);
/* 356 */       writer.flush();
/* 357 */       buffer.append(" error=").append(stringWriter.getBuffer());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 363 */     buffer.append("name=").append(this.name);
/* 364 */     if (this.aliases != null)
/* 365 */       buffer.append(" aliases=").append(this.aliases);
/* 366 */     if ((this.error != null) || (!this.state.equals(ControllerState.ERROR)))
/* 367 */       buffer.append(" state=").append(this.state.getStateString());
/* 368 */     if (!ControllerMode.AUTOMATIC.equals(this.mode))
/*     */     {
/* 370 */       buffer.append(" mode=").append(this.mode.getModeString());
/* 371 */       buffer.append(" requiredState=").append(this.requiredState.getStateString());
/*     */     }
/* 373 */     if (this.error != null)
/* 374 */       buffer.append(" error=").append(this.error.getClass().getName()).append(": ").append(this.error.getMessage());
/*     */   }
/*     */ 
/*     */   protected void initScopeInfo()
/*     */   {
/* 382 */     String className = null;
/* 383 */     Object target = getTarget();
/* 384 */     if (target != null)
/* 385 */       className = target.getClass().getName();
/* 386 */     setScopeInfo(new AbstractScopeInfo(getName(), className));
/*     */   }
/*     */ 
/*     */   protected Object needsAnAlias(Object original)
/*     */   {
/* 399 */     return JMXObjectNameFix.needsAnAlias(original);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractControllerContext
 * JD-Core Version:    0.6.0
 */