/*     */ package org.jboss.dependency.plugins;
/*     */ 
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class AbstractCallbackItem<T> extends JBossObject
/*     */   implements CallbackItem<T>
/*     */ {
/*     */   protected T name;
/*  40 */   protected ControllerState whenRequired = ControllerState.CONFIGURED;
/*  41 */   protected ControllerState dependentState = ControllerState.INSTALLED;
/*     */   protected String attributeName;
/*     */ 
/*     */   protected AbstractCallbackItem(T name)
/*     */   {
/*  46 */     this.name = name;
/*     */   }
/*     */ 
/*     */   protected AbstractCallbackItem(T name, ControllerState whenRequired, ControllerState dependentState, String attributeName)
/*     */   {
/*  51 */     this.name = name;
/*  52 */     if (whenRequired != null)
/*  53 */       this.whenRequired = whenRequired;
/*  54 */     if (dependentState != null)
/*  55 */       this.dependentState = dependentState;
/*  56 */     if (attributeName == null)
/*  57 */       throw new IllegalArgumentException("Null attribute name!");
/*  58 */     this.attributeName = attributeName;
/*     */   }
/*     */ 
/*     */   public void ownerCallback(Controller controller, boolean isInstallPhase) throws Throwable
/*     */   {
/*  63 */     this.log.info("Owner callback not implemented.");
/*     */   }
/*     */ 
/*     */   protected void changeCallback(ControllerContext context, boolean isInstallPhase)
/*     */     throws Throwable
/*     */   {
/*     */   }
/*     */ 
/*     */   public void changeCallback(Controller controller, ControllerContext context, boolean isInstallPhase)
/*     */     throws Throwable
/*     */   {
/*  79 */     changeCallback(context, isInstallPhase);
/*     */   }
/*     */ 
/*     */   public T getIDependOn()
/*     */   {
/*  84 */     return this.name;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  89 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/*  94 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public String getAttributeName()
/*     */   {
/*  99 */     return this.attributeName;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 104 */     buffer.append("name=").append(this.name);
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 109 */     buffer.append("name=").append(this.name);
/* 110 */     buffer.append(" whenRequired=").append(this.whenRequired);
/* 111 */     buffer.append(" dependentState=").append(this.dependentState);
/* 112 */     buffer.append(" attributeName=").append(this.attributeName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.AbstractCallbackItem
 * JD-Core Version:    0.6.0
 */