/*    */ package org.jboss.corba;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.util.Properties;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.omg.CORBA.ORB;
/*    */ import org.omg.PortableServer.POA;
/*    */ import org.omg.PortableServer.POAManager;
/*    */ 
/*    */ public class ORBFactory
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(ORBFactory.class);
/*    */   private static ORB orb;
/*    */ 
/*    */   public static ORB getORB()
/*    */   {
/* 55 */     synchronized (ORBFactory.class)
/*    */     {
/* 57 */       if (orb == null)
/*    */       {
/*    */         Properties properties;
/*    */         try {
/* 62 */           properties = (Properties)AccessController.doPrivileged(new PrivilegedAction()
/*    */           {
/*    */             public Object run()
/*    */             {
/* 66 */               return System.getProperties();
/*    */             }
/*    */           });
/*    */         }
/*    */         catch (SecurityException ignored) {
/* 72 */           log.trace("Unable to retrieve system properties", ignored);
/* 73 */           properties = null;
/*    */         }
/*    */ 
/* 77 */         orb = ORB.init(new String[0], properties);
/*    */         try
/*    */         {
/* 82 */           POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
/* 83 */           rootPOA.the_POAManager().activate();
/*    */         }
/*    */         catch (Throwable t)
/*    */         {
/* 87 */           log.warn("Unable to activate POA", t);
/*    */         }
/*    */       }
/* 90 */       return orb;
/*    */     }
/*    */   }
/*    */ 
/*    */   public static void setORB(ORB orb)
/*    */   {
/* 96 */     if (orb != null)
/* 97 */       throw new IllegalStateException("ORB has already been set");
/* 98 */     orb = orb;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.corba.ORBFactory
 * JD-Core Version:    0.6.0
 */