/*     */ package org.jboss.config.plugins.property;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.beans.info.spi.BeanInfoFactory;
/*     */ import org.jboss.classadapter.spi.ClassAdapterFactory;
/*     */ import org.jboss.classadapter.spi.DependencyBuilder;
/*     */ import org.jboss.config.plugins.AbstractConfiguration;
/*     */ import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ 
/*     */ public class PropertyConfiguration extends AbstractConfiguration
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(PropertyConfiguration.class);
/*     */   protected Properties properties;
/*     */ 
/*     */   public PropertyConfiguration()
/*     */   {
/*  54 */     this(null);
/*     */   }
/*     */ 
/*     */   public PropertyConfiguration(Properties properties)
/*     */   {
/*  64 */     if (properties == null)
/*  65 */       properties = System.getProperties();
/*  66 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/*  76 */     return this.properties;
/*     */   }
/*     */ 
/*     */   protected BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable
/*     */   {
/*  81 */     return (BeanInfoFactory)loadFromProperties(PropertyConfigurationConstants.BEAN_INFO_FACTORY_NAME, "org.jboss.beans.info.plugins.AbstractBeanInfoFactory", BeanInfoFactory.class);
/*     */   }
/*     */ 
/*     */   protected ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable
/*     */   {
/*  86 */     ClassAdapterFactory result = (ClassAdapterFactory)loadFromProperties(PropertyConfigurationConstants.CLASS_ADAPTER_FACTORY_NAME, "org.jboss.classadapter.plugins.BasicClassAdapterFactory", ClassAdapterFactory.class);
/*  87 */     result.setConfiguration(this);
/*  88 */     return result;
/*     */   }
/*     */ 
/*     */   protected TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable
/*     */   {
/*  93 */     return (TypeInfoFactory)loadFromProperties(PropertyConfigurationConstants.TYPE_INFO_FACTORY_NAME, "org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory", TypeInfoFactory.class);
/*     */   }
/*     */ 
/*     */   protected JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable
/*     */   {
/*  98 */     return (JoinpointFactoryBuilder)loadFromProperties(PropertyConfigurationConstants.JOIN_POINT_FACTORY_BUILDER_NAME, "org.jboss.aop.microcontainer.integration.AOPJoinpointFactoryBuilder:org.jboss.joinpoint.plugins.BasicJoinpointFactoryBuilder", JoinpointFactoryBuilder.class);
/*     */   }
/*     */ 
/*     */   protected DependencyBuilder createDefaultDependencyBuilder() throws Throwable
/*     */   {
/* 103 */     return (DependencyBuilder)loadFromProperties(PropertyConfigurationConstants.DEPENDENCY_BUILDER_NAME, "org.jboss.aop.microcontainer.integration.AOPDependencyBuilder:org.jboss.classadapter.plugins.dependency.AbstractDependencyBuilder", DependencyBuilder.class);
/*     */   }
/*     */ 
/*     */   protected Object loadFromProperties(String propertyName, String defaultValue, Class<? extends Object> targetClass)
/*     */     throws Throwable
/*     */   {
/* 117 */     String value = this.properties.getProperty(propertyName, defaultValue);
/* 118 */     StringTokenizer tokenizer = new StringTokenizer(value, ":");
/* 119 */     Class clazz = null;
/* 120 */     ClassNotFoundException error = null;
/* 121 */     while (tokenizer.hasMoreTokens())
/*     */     {
/* 123 */       String className = tokenizer.nextToken();
/*     */       try
/*     */       {
/* 126 */         clazz = getClass().getClassLoader().loadClass(className);
/*     */       }
/*     */       catch (ClassNotFoundException ignored)
/*     */       {
/* 131 */         log.trace(className + " not found: " + ignored.getMessage());
/* 132 */         error = ignored;
/*     */       }
/*     */     }
/* 135 */     if ((clazz == null) && (error != null))
/* 136 */       throw error;
/* 137 */     if (clazz == null) {
/* 138 */       throw new RuntimeException("Invalid configuration for property " + propertyName + " expected a class name that implements " + targetClass.getName());
/*     */     }
/* 140 */     if (!targetClass.isAssignableFrom(clazz)) {
/* 141 */       throw new RuntimeException("Class " + clazz.getName() + " specified in property " + propertyName + " does not implement " + targetClass.getName());
/*     */     }
/* 143 */     return clazz.newInstance();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.config.plugins.property.PropertyConfiguration
 * JD-Core Version:    0.6.0
 */