/*     */ package org.jboss.client;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class AppClientMain
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(AppClientMain.class);
/*     */   public static final String JBOSS_CLIENT_PARAM = "-jbossclient";
/*     */   public static final String J2EE_CLIENT_PARAM = "-j2ee.clientName";
/*     */   public static final String LAUNCHERS_PARAM = "-launchers";
/*  58 */   public static String[] DEFAULT_LAUNCHERS = { ReflectionLauncher.class.getName() };
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  66 */     log.debug("System Properties");
/*  67 */     Properties sysprops = System.getProperties();
/*  68 */     for (Iterator i$ = sysprops.keySet().iterator(); i$.hasNext(); ) { Object key = i$.next();
/*  69 */       log.debug("  " + key + "=" + sysprops.getProperty((String)key));
/*     */     }
/*     */ 
/*  72 */     String clientClass = null;
/*  73 */     String clientName = null;
/*  74 */     ArrayList newArgs = new ArrayList();
/*  75 */     String[] launchers = DEFAULT_LAUNCHERS;
/*  76 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  78 */       String arg = args[i];
/*  79 */       log.debug("arg=" + arg);
/*     */ 
/*  81 */       if (arg.equals("-jbossclient"))
/*     */       {
/*  83 */         clientClass = args[(i + 1)];
/*  84 */         i++;
/*     */       }
/*  86 */       else if (arg.equals("-j2ee.clientName"))
/*     */       {
/*  91 */         clientName = args[(i + 1)];
/*  92 */         System.setProperty("j2ee.clientName", clientName);
/*  93 */         log.info("j2ee.clientName=" + clientName);
/*  94 */         i++;
/*     */       }
/*  96 */       else if (arg.equals("-launchers"))
/*     */       {
/*  98 */         launchers = args[(i + 1)].split(",");
/*  99 */         log.info("-launchers=" + args[(i + 1)]);
/* 100 */         i++;
/*     */       }
/*     */       else
/*     */       {
/* 104 */         newArgs.add(args[i]);
/*     */       }
/*     */     }
/*     */ 
/* 108 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 109 */     if (loader == null) {
/* 110 */       loader = AppClientMain.class.getClassLoader();
/*     */     }
/* 112 */     if (clientClass == null)
/*     */     {
/* 114 */       clientClass = getMainClassName(loader);
/* 115 */       throw new IllegalArgumentException("Neither a Main-Class was found in the manifest, nor was a -jbossclient specified");
/*     */     }
/*     */ 
/* 119 */     if (clientName == null)
/*     */     {
/* 121 */       clientName = getClientName(loader);
/*     */     }
/*     */ 
/* 124 */     String[] mainArgs = new String[newArgs.size()];
/* 125 */     newArgs.toArray(mainArgs);
/*     */ 
/* 128 */     for (String launcherName : launchers)
/*     */     {
/*     */       try
/*     */       {
/* 132 */         Class launcherClass = loader.loadClass(launcherName);
/* 133 */         AppClientLauncher launcher = (AppClientLauncher)launcherClass.newInstance();
/* 134 */         launcher.launch(clientClass, clientName, mainArgs);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 139 */         log.warn("Failed to launch using: " + launcherName, t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String getClientName(ClassLoader loader)
/*     */     throws Exception
/*     */   {
/* 152 */     String clientName = null;
/* 153 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 154 */     DocumentBuilder builder = factory.newDocumentBuilder();
/*     */ 
/* 156 */     URL appXmlURL = loader.getResource("META-INF/application-client.xml");
/* 157 */     if (appXmlURL != null)
/*     */     {
/* 159 */       InputStream is = appXmlURL.openStream();
/* 160 */       Document appXml = builder.parse(is);
/* 161 */       is.close();
/* 162 */       Element root = appXml.getDocumentElement();
/* 163 */       clientName = root.getAttribute("id");
/* 164 */       if (clientName != null) {
/* 165 */         return clientName;
/*     */       }
/*     */     }
/*     */ 
/* 169 */     URL jbossXmlURL = loader.getResource("META-INF/jboss-client.xml");
/* 170 */     if (appXmlURL != null)
/*     */     {
/* 172 */       InputStream is = jbossXmlURL.openStream();
/* 173 */       Document jbossXml = builder.parse(is);
/* 174 */       is.close();
/* 175 */       Element root = jbossXml.getDocumentElement();
/* 176 */       NodeList children = root.getChildNodes();
/* 177 */       for (int n = 0; n < children.getLength(); n++)
/*     */       {
/* 179 */         Node node = children.item(n);
/* 180 */         if (!node.getLocalName().equals("jndi-name"))
/*     */           continue;
/* 182 */         clientName = node.getNodeValue();
/* 183 */         return clientName;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 188 */     return null;
/*     */   }
/*     */ 
/*     */   private static String getMainClassName(ClassLoader loader)
/*     */     throws Exception
/*     */   {
/* 201 */     URL mfURL = loader.getResource("META-INF/MANIFEST.MF");
/* 202 */     if (mfURL == null)
/*     */     {
/* 204 */       return null;
/* 207 */     }
/*     */ InputStream is = mfURL.openStream();
/*     */     Manifest mf;
/*     */     try {
/* 211 */       mf = new Manifest(is);
/*     */     }
/*     */     finally
/*     */     {
/* 215 */       is.close();
/*     */     }
/* 217 */     Attributes attrs = mf.getMainAttributes();
/* 218 */     String mainClassName = attrs.getValue(Attributes.Name.MAIN_CLASS);
/* 219 */     return mainClassName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.client.AppClientMain
 * JD-Core Version:    0.6.0
 */