/*     */ package org.jboss.classloading.spi;
/*     */ 
/*     */ import java.net.URL;
/*     */ 
/*     */ public class DelegatingClassLoader extends ClassLoader
/*     */ {
/*     */   private RealClassLoader parent;
/*  38 */   protected boolean standard = false;
/*     */ 
/*     */   private static ClassLoader checkParent(RealClassLoader parent)
/*     */   {
/*  48 */     if (parent == null)
/*  49 */       throw new IllegalArgumentException("Null parent");
/*  50 */     if (!(parent instanceof ClassLoader)) {
/*  51 */       throw new IllegalArgumentException("Parent is not a classloader");
/*     */     }
/*  53 */     return (ClassLoader)ClassLoader.class.cast(parent);
/*     */   }
/*     */ 
/*     */   public DelegatingClassLoader(RealClassLoader parent)
/*     */   {
/*  63 */     super(checkParent(parent));
/*  64 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   protected Class<?> loadClass(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/*  70 */     Class clazz = findLoadedClass(name);
/*     */ 
/*  73 */     if (clazz == null) {
/*  74 */       clazz = this.parent.getCachedClass(name);
/*     */     }
/*     */ 
/*  77 */     if (clazz == null)
/*     */     {
/*  80 */       if (this.standard) {
/*  81 */         clazz = super.loadClass(name, resolve);
/*     */       }
/*     */       else {
/*  84 */         clazz = getParent().loadClass(name);
/*     */       }
/*     */     }
/*     */ 
/*  88 */     if (resolve)
/*  89 */       resolveClass(clazz);
/*  90 */     return clazz;
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*  96 */     URL resource = this.parent.getCachedResource(name);
/*     */ 
/*  99 */     if (resource == null)
/*     */     {
/* 102 */       if (this.standard) {
/* 103 */         resource = super.getResource(name);
/*     */       }
/*     */       else
/* 106 */         resource = getParent().getResource(name);
/*     */     }
/* 108 */     return resource;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloading.spi.DelegatingClassLoader
 * JD-Core Version:    0.6.0
 */