/*     */ package org.jboss.classloader.test.support;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Arrays;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloader.plugins.ClassLoaderUtils;
/*     */ import org.jboss.classloader.plugins.filter.PatternClassFilter;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.classloader.spi.filter.ClassFilter;
/*     */ 
/*     */ public class MockClassLoaderPolicy extends ClassLoaderPolicy
/*     */ {
/*     */   private String name;
/*  56 */   private String prefix = "";
/*     */   private List<? extends DelegateLoader> delegates;
/*     */   private String[] paths;
/*     */   private String[] included;
/*     */   private String[] excluded;
/*     */   private String[] packageNames;
/*     */   private boolean importAll;
/*     */   private ClassFilter nonJDKFilter;
/*     */ 
/*     */   public MockClassLoaderPolicy()
/*     */   {
/*  85 */     this(null);
/*     */   }
/*     */ 
/*     */   public MockClassLoaderPolicy(String name)
/*     */   {
/*  95 */     this(name, new String[] { "org\\.jboss\\..+" }, new String[] { "org/jboss/.+" });
/*     */   }
/*     */ 
/*     */   public MockClassLoaderPolicy(String name, String[] classPatterns, String[] resourcePatterns)
/*     */   {
/* 107 */     this(name, new PatternClassFilter(classPatterns, resourcePatterns));
/*     */   }
/*     */ 
/*     */   public MockClassLoaderPolicy(String name, ClassFilter nonJDKFilter)
/*     */   {
/* 119 */     if (name == null)
/* 120 */       name = "mock";
/* 121 */     this.name = name;
/* 122 */     if (nonJDKFilter == null)
/* 123 */       throw new IllegalArgumentException("Null filter");
/* 124 */     this.nonJDKFilter = nonJDKFilter;
/*     */   }
/*     */ 
/*     */   public List<? extends DelegateLoader> getDelegates()
/*     */   {
/* 130 */     return this.delegates;
/*     */   }
/*     */ 
/*     */   public void setDelegates(List<? extends DelegateLoader> delegates)
/*     */   {
/* 140 */     this.delegates = delegates;
/*     */   }
/*     */ 
/*     */   public String getPrefix()
/*     */   {
/* 150 */     return this.prefix;
/*     */   }
/*     */ 
/*     */   public void setPrefix(String prefix)
/*     */   {
/* 160 */     this.prefix = prefix;
/*     */   }
/*     */ 
/*     */   public String[] getPaths()
/*     */   {
/* 170 */     return this.paths;
/*     */   }
/*     */ 
/*     */   public void setPath(String path)
/*     */   {
/* 180 */     setPaths(new String[] { path });
/*     */   }
/*     */ 
/*     */   public void setPaths(String[] paths)
/*     */   {
/* 190 */     this.paths = paths;
/*     */   }
/*     */ 
/*     */   public void setPaths(Class[] classes)
/*     */   {
/* 200 */     if (classes == null)
/*     */     {
/* 202 */       this.paths = null;
/* 203 */       return;
/*     */     }
/* 205 */     this.paths = new String[classes.length];
/* 206 */     for (int i = 0; i < classes.length; i++)
/* 207 */       this.paths[i] = ClassLoaderUtils.packageNameToPath(classes[i].getName());
/*     */   }
/*     */ 
/*     */   public String[] getPackageNames()
/*     */   {
/* 213 */     return this.packageNames;
/*     */   }
/*     */ 
/*     */   public void setPackageNames(String[] packageNames)
/*     */   {
/* 223 */     this.packageNames = packageNames;
/*     */   }
/*     */ 
/*     */   public void setPackageNames(Class[] classes)
/*     */   {
/* 233 */     if (classes == null)
/*     */     {
/* 235 */       this.packageNames = null;
/* 236 */       return;
/*     */     }
/* 238 */     this.packageNames = new String[classes.length];
/* 239 */     for (int i = 0; i < classes.length; i++)
/* 240 */       this.packageNames[i] = ClassLoaderUtils.getClassPackageName(classes[i].getName());
/*     */   }
/*     */ 
/*     */   public void setIncluded(Class[] classes)
/*     */   {
/* 250 */     if (classes == null)
/*     */     {
/* 252 */       this.included = null;
/* 253 */       return;
/*     */     }
/* 255 */     this.included = new String[classes.length];
/* 256 */     for (int i = 0; i < classes.length; i++)
/* 257 */       this.included[i] = ClassLoaderUtils.classNameToPath(classes[i].getName());
/*     */   }
/*     */ 
/*     */   public void setExcluded(Class[] classes)
/*     */   {
/* 267 */     if (classes == null)
/*     */     {
/* 269 */       this.excluded = null;
/* 270 */       return;
/*     */     }
/* 272 */     this.excluded = new String[classes.length];
/* 273 */     for (int i = 0; i < classes.length; i++)
/* 274 */       this.excluded[i] = ClassLoaderUtils.classNameToPath(classes[i].getName());
/*     */   }
/*     */ 
/*     */   public void setPathsAndPackageNames(Class[] classes)
/*     */   {
/* 284 */     setPaths(classes);
/* 285 */     setPackageNames(classes);
/*     */   }
/*     */ 
/*     */   public void setPathsAndPackageNames(String[] packages)
/*     */   {
/* 295 */     if (packages == null)
/*     */     {
/* 297 */       this.paths = null;
/* 298 */       this.packageNames = null;
/* 299 */       return;
/*     */     }
/* 301 */     this.paths = new String[packages.length];
/* 302 */     for (int i = 0; i < packages.length; i++) {
/* 303 */       this.paths[i] = packages[i].replace('.', '/');
/*     */     }
/* 305 */     setPackageNames(packages);
/*     */   }
/*     */ 
/*     */   public boolean isImportAll()
/*     */   {
/* 311 */     return this.importAll;
/*     */   }
/*     */ 
/*     */   public void setImportAll(boolean importAll)
/*     */   {
/* 321 */     this.importAll = importAll;
/*     */   }
/*     */ 
/*     */   public URL getResource(String path)
/*     */   {
/* 327 */     if (this.paths == null) {
/* 328 */       return null;
/*     */     }
/* 330 */     if (this.excluded != null)
/*     */     {
/* 332 */       for (String excludedPath : this.excluded)
/*     */       {
/* 334 */         if (excludedPath.equals(path)) {
/* 335 */           return null;
/*     */         }
/*     */       }
/*     */     }
/* 339 */     if (this.included != null)
/*     */     {
/* 341 */       boolean include = false;
/* 342 */       for (String includedPath : this.included)
/*     */       {
/* 344 */         if (!includedPath.equals(path))
/*     */           continue;
/* 346 */         include = true;
/* 347 */         break;
/*     */       }
/*     */ 
/* 350 */       if (!include) {
/* 351 */         return null;
/*     */       }
/*     */     }
/* 354 */     for (int i = 0; i < this.paths.length; i++)
/*     */     {
/* 356 */       if (path.startsWith(this.paths[i]))
/* 357 */         return getClass().getClassLoader().getResource(this.prefix + path);
/*     */     }
/* 359 */     return null;
/*     */   }
/*     */ 
/*     */   public void getResources(String path, Set<URL> urls)
/*     */     throws IOException
/*     */   {
/* 365 */     if (this.paths == null) {
/* 366 */       return;
/*     */     }
/* 368 */     if (this.excluded != null)
/*     */     {
/* 370 */       for (String excludedPath : this.excluded)
/*     */       {
/* 372 */         if (excludedPath.equals(path)) {
/* 373 */           return;
/*     */         }
/*     */       }
/*     */     }
/* 377 */     if (this.included != null)
/*     */     {
/* 379 */       boolean include = false;
/* 380 */       for (String includedPath : this.included)
/*     */       {
/* 382 */         if (!includedPath.equals(path))
/*     */           continue;
/* 384 */         include = true;
/* 385 */         break;
/*     */       }
/*     */ 
/* 388 */       if (!include) {
/* 389 */         return;
/*     */       }
/*     */     }
/* 392 */     ClassLoader parent = getClass().getClassLoader();
/* 393 */     for (int i = 0; i < this.paths.length; i++)
/*     */     {
/* 395 */       if (!path.startsWith(this.paths[i]))
/*     */         continue;
/* 397 */       Enumeration enumeration = parent.getResources(this.prefix + path);
/* 398 */       while (enumeration.hasMoreElements())
/* 399 */         urls.add(enumeration.nextElement());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ProtectionDomain getProtectionDomain(String className, String path)
/*     */   {
/*     */     Class clazz;
/*     */     try
/*     */     {
/* 410 */       clazz = getClass().getClassLoader().loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 414 */       throw new Error("Could not load class: " + className, e);
/*     */     }
/* 416 */     return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */     {
/*     */       public ProtectionDomain run()
/*     */       {
/* 420 */         return this.val$clazz.getProtectionDomain();
/*     */       }
/*     */     }
/*     */     , getAccessControlContext());
/*     */   }
/*     */ 
/*     */   protected ClassLoader isJDKRequest(String name)
/*     */   {
/* 433 */     if (this.nonJDKFilter.matchesClassName(name))
/* 434 */       return null;
/* 435 */     return super.isJDKRequest(name);
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/*     */     try
/*     */     {
/* 443 */       Hashtable properties = new Hashtable();
/* 444 */       properties.put("name", "'" + this.name + "'");
/* 445 */       properties.put("domain", "'" + getDomainName() + "'");
/* 446 */       return ObjectName.getInstance("jboss.classloader", properties);
/*     */     }
/*     */     catch (MalformedObjectNameException e) {
/*     */     }
/* 450 */     throw new Error("Error creating object name", e);
/*     */   }
/*     */ 
/*     */   public void toLongString(StringBuilder builder)
/*     */   {
/* 457 */     builder.append(" name=").append(this.name);
/* 458 */     if (this.prefix.length() > 0)
/* 459 */       builder.append(" prefix=").append(this.prefix);
/* 460 */     if (this.paths != null)
/* 461 */       builder.append(" paths=").append(Arrays.asList(this.paths));
/* 462 */     if (this.included != null)
/* 463 */       builder.append(" included=").append(Arrays.asList(this.included));
/* 464 */     if (this.excluded != null)
/* 465 */       builder.append(" excluded=").append(Arrays.asList(this.excluded));
/* 466 */     super.toLongString(builder);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 473 */     return this.name;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.test.support.MockClassLoaderPolicy
 * JD-Core Version:    0.6.0
 */