/*     */ package org.jboss.classloader.test.support;
/*     */ 
/*     */ import junit.framework.Test;
/*     */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*     */ import org.jboss.test.AbstractTestCaseWithSetup;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public abstract class IsolatedClassLoaderTest extends AbstractTestCaseWithSetup
/*     */ {
/*     */   private static IsolatedClassLoaderTestHelper helper;
/*     */ 
/*     */   public static AbstractTestDelegate getDelegate(Class<?> clazz)
/*     */   {
/*  49 */     return new AbstractTestDelegate(clazz);
/*     */   }
/*     */ 
/*     */   public static Test suite(Class<?> clazz)
/*     */   {
/*  63 */     return suite(clazz, false);
/*     */   }
/*     */ 
/*     */   public static Test suite(Class<?> clazz, boolean importAll)
/*     */   {
/*  78 */     return suite(clazz, importAll, new Class[0]);
/*     */   }
/*     */ 
/*     */   public static Test suite(Class<?> clazz, Class<?>[] packages)
/*     */   {
/*  94 */     return suite(clazz, false, packages);
/*     */   }
/*     */ 
/*     */   public static Test suite(Class<?> clazz, boolean importAll, Class<?>[] packages)
/*     */   {
/* 110 */     helper = new IsolatedClassLoaderTestHelper();
/* 111 */     Class newClass = helper.initializeClassLoader(clazz, importAll, packages);
/*     */ 
/* 113 */     return AbstractTestCaseWithSetup.suite(newClass);
/*     */   }
/*     */ 
/*     */   protected void setUp()
/*     */     throws Exception
/*     */   {
/* 119 */     super.setUp();
/* 120 */     configureLogging();
/*     */   }
/*     */ 
/*     */   public IsolatedClassLoaderTest(String name)
/*     */   {
/* 130 */     super(name);
/*     */   }
/*     */ 
/*     */   public static ClassLoaderSystem getClassLoaderSystem()
/*     */   {
/* 141 */     return helper.getSystem();
/*     */   }
/*     */ 
/*     */   protected static ClassLoader createClassLoader(String name, String[] packages)
/*     */     throws Exception
/*     */   {
/* 157 */     return createClassLoader(name, true, packages);
/*     */   }
/*     */ 
/*     */   protected static ClassLoader createClassLoader(String name, boolean importAll, String[] packages)
/*     */     throws Exception
/*     */   {
/* 173 */     return helper.createClassLoader(name, importAll, packages);
/*     */   }
/*     */ 
/*     */   protected static void unregisterClassLoader(ClassLoader classLoader)
/*     */     throws Exception
/*     */   {
/* 184 */     helper.unregisterClassLoader(classLoader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.test.support.IsolatedClassLoaderTest
 * JD-Core Version:    0.6.0
 */