/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import org.jboss.classloader.spi.Loader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BaseDelegateLoader
/*     */   implements Loader
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(BaseDelegateLoader.class);
/*     */   private BaseClassLoaderPolicy delegate;
/*     */ 
/*     */   public BaseDelegateLoader(BaseClassLoaderPolicy delegate)
/*     */   {
/*  53 */     if (delegate == null)
/*  54 */       throw new IllegalArgumentException("Null delegate");
/*  55 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   BaseClassLoaderPolicy getPolicy()
/*     */   {
/*  60 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public Class<?> loadClass(String className)
/*     */   {
/*     */     BaseClassLoader classLoader;
/*     */     try {
/*  68 */       classLoader = this.delegate.getClassLoader();
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/*  72 */       log.warn("Not loading from policy that has no classLoader: " + toLongString());
/*  73 */       return null;
/*     */     }
/*  75 */     return classLoader.loadClassLocally(className);
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*     */     BaseClassLoader classLoader;
/*     */     try {
/*  83 */       classLoader = this.delegate.getClassLoader();
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/*  87 */       log.warn("Not loading from policy that has no classLoader: " + toLongString());
/*  88 */       return null;
/*     */     }
/*  90 */     return classLoader.getResourceLocally(name);
/*     */   }
/*     */ 
/*     */   public void getResources(String name, Set<URL> urls) throws IOException
/*     */   {
/*     */     BaseClassLoader classLoader;
/*     */     try {
/*  98 */       classLoader = this.delegate.getClassLoader();
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/* 102 */       log.warn("Not loading from policy that has no classLoader: " + toLongString());
/* 103 */       return;
/*     */     }
/* 105 */     classLoader.getResourcesLocally(name, urls);
/*     */   }
/*     */ 
/*     */   public String toLongString()
/*     */   {
/* 115 */     StringBuilder builder = new StringBuilder();
/* 116 */     builder.append(getClass().getSimpleName());
/* 117 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/* 118 */     builder.append("{delegate=").append(this.delegate.toLongString());
/* 119 */     toLongString(builder);
/* 120 */     builder.append('}');
/* 121 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     StringBuilder builder = new StringBuilder();
/* 137 */     builder.append(getClass().getSimpleName());
/* 138 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/* 139 */     builder.append("{delegate=").append(this.delegate);
/* 140 */     builder.append('}');
/* 141 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.BaseDelegateLoader
 * JD-Core Version:    0.6.0
 */