/*     */ package org.jboss.classloader.spi.base;
/*     */ 
/*     */ import java.security.AccessControlContext;
/*     */ import java.security.AccessController;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.List;
/*     */ import org.jboss.classloader.spi.ClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.DelegateLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class BaseClassLoaderPolicy
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(BaseClassLoaderPolicy.class);
/*     */   private volatile BaseClassLoader classLoader;
/*     */   private volatile BaseClassLoaderDomain domain;
/*     */   private AccessControlContext access;
/*     */ 
/*     */   public BaseClassLoaderPolicy()
/*     */   {
/*  63 */     SecurityManager sm = System.getSecurityManager();
/*  64 */     if (sm != null) {
/*  65 */       sm.checkCreateClassLoader();
/*     */     }
/*  67 */     this.access = AccessController.getContext();
/*     */   }
/*     */ 
/*     */   protected AccessControlContext getAccessControlContext()
/*     */   {
/*  77 */     return this.access;
/*     */   }
/*     */ 
/*     */   protected abstract DelegateLoader getExported();
/*     */ 
/*     */   public abstract String[] getPackageNames();
/*     */ 
/*     */   protected abstract List<? extends DelegateLoader> getDelegates();
/*     */ 
/*     */   protected abstract boolean isImportAll();
/*     */ 
/*     */   protected abstract ProtectionDomain getProtectionDomain(String paramString1, String paramString2);
/*     */ 
/*     */   protected byte[] transform(String className, byte[] byteCode, ProtectionDomain protectionDomain)
/*     */     throws Exception
/*     */   {
/* 138 */     BaseClassLoaderDomain domain = getClassLoaderDomain();
/* 139 */     if (domain != null)
/* 140 */       return domain.transform(getClassLoader(), className, byteCode, protectionDomain);
/* 141 */     return byteCode;
/*     */   }
/*     */ 
/*     */   protected abstract boolean isCachable();
/*     */ 
/*     */   protected abstract boolean isBlackListable();
/*     */ 
/*     */   protected abstract ClassLoader isJDKRequest(String paramString);
/*     */ 
/*     */   public String toLongString()
/*     */   {
/* 173 */     StringBuilder builder = new StringBuilder();
/* 174 */     builder.append(getClass().getSimpleName());
/* 175 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/* 176 */     builder.append("{domain=");
/* 177 */     if (this.domain == null)
/* 178 */       builder.append("null");
/*     */     else
/* 180 */       builder.append(this.domain.toLongString());
/* 181 */     toLongString(builder);
/* 182 */     builder.append('}');
/* 183 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 198 */     StringBuilder builder = new StringBuilder();
/* 199 */     builder.append(getClass().getSimpleName());
/* 200 */     builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
/* 201 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   public String getDomainName()
/*     */   {
/* 211 */     if (this.domain == null)
/* 212 */       return null;
/* 213 */     return ((ClassLoaderDomain)this.domain).getName();
/*     */   }
/*     */ 
/*     */   BaseClassLoaderDomain getClassLoaderDomain()
/*     */   {
/* 223 */     return this.domain;
/*     */   }
/*     */ 
/*     */   void setClassLoaderDomain(BaseClassLoaderDomain domain)
/*     */   {
/* 234 */     if (this.domain != null)
/* 235 */       throw new IllegalStateException("Policy already has a domain " + this);
/* 236 */     this.domain = domain;
/*     */   }
/*     */ 
/*     */   void unsetClassLoaderDomain(BaseClassLoaderDomain domain)
/*     */   {
/* 248 */     if (this.domain != domain)
/* 249 */       throw new IllegalStateException("Policy is not a part of the domain " + this + " domain=" + domain);
/* 250 */     shutdownPolicy();
/* 251 */     this.domain = null;
/*     */   }
/*     */ 
/*     */   synchronized BaseClassLoader getClassLoader()
/*     */   {
/* 260 */     if (this.classLoader == null)
/* 261 */       throw new IllegalStateException("No classloader associated with policy therefore it is no longer registered " + toLongString());
/* 262 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   synchronized void setClassLoader(BaseClassLoader classLoader)
/*     */   {
/* 275 */     if (this.classLoader != null)
/* 276 */       throw new IllegalStateException("Policy already has a classloader previous=" + classLoader);
/* 277 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   protected synchronized void shutdownPolicy()
/*     */   {
/* 287 */     log.debug(toLongString() + " shutdown!");
/* 288 */     BaseClassLoader classLoader = this.classLoader;
/* 289 */     this.classLoader = null;
/* 290 */     classLoader.shutdownClassLoader();
/*     */   }
/*     */ 
/*     */   protected void clearBlackList(String name)
/*     */   {
/* 300 */     if (this.domain != null)
/*     */     {
/* 302 */       this.domain.clearBlackList(name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.base.BaseClassLoaderPolicy
 * JD-Core Version:    0.6.0
 */