/*     */ package org.jboss.classloader.spi;
/*     */ 
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.classloader.plugins.system.ClassLoaderSystemBuilder;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.loading.Translator;
/*     */ 
/*     */ public abstract class ClassLoaderSystem extends BaseClassLoaderSystem
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(ClassLoaderSystem.class);
/*     */   public static final String DEFAULT_DOMAIN_NAME = "<DEFAULT>";
/*  51 */   private static final ClassLoaderSystemBuilder builder = new ClassLoaderSystemBuilder();
/*     */   private ClassLoaderDomain defaultDomain;
/*  57 */   private Map<String, ClassLoaderDomain> registeredDomains = new HashMap();
/*     */   private Translator translator;
/*  63 */   private boolean shutdown = false;
/*     */ 
/*     */   public static final ClassLoaderSystem getInstance()
/*     */   {
/*  73 */     SecurityManager sm = System.getSecurityManager();
/*  74 */     if (sm != null)
/*  75 */       sm.checkCreateClassLoader();
/*  76 */     return ClassLoaderSystemBuilder.get();
/*     */   }
/*     */ 
/*     */   public synchronized ClassLoaderDomain getDefaultDomain()
/*     */   {
/*  86 */     if (this.shutdown) {
/*  87 */       throw new IllegalStateException("The classloader system is shutdown: " + toLongString());
/*     */     }
/*     */ 
/*  90 */     if (this.defaultDomain != null) {
/*  91 */       return this.defaultDomain;
/*     */     }
/*     */ 
/*  94 */     this.defaultDomain = ((ClassLoaderDomain)this.registeredDomains.get("<DEFAULT>"));
/*  95 */     if (this.defaultDomain != null) {
/*  96 */       return this.defaultDomain;
/*     */     }
/*     */ 
/*  99 */     this.defaultDomain = createDefaultDomain();
/*     */ 
/* 102 */     internalRegisterDomain("<DEFAULT>", this.defaultDomain);
/*     */ 
/* 104 */     return this.defaultDomain;
/*     */   }
/*     */ 
/*     */   protected ClassLoaderDomain createDefaultDomain()
/*     */   {
/* 116 */     return createDomain("<DEFAULT>");
/*     */   }
/*     */ 
/*     */   protected abstract ClassLoaderDomain createDomain(String paramString);
/*     */ 
/*     */   public ClassLoaderDomain createAndRegisterDomain(String name)
/*     */   {
/* 138 */     return createAndRegisterDomain(name, ParentPolicy.BEFORE, null);
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy)
/*     */   {
/* 152 */     return createAndRegisterDomain(name, parentPolicy, null);
/*     */   }
/*     */ 
/*     */   public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy, Loader parent)
/*     */   {
/* 167 */     ClassLoaderDomain result = createDomain(name);
/* 168 */     result.setParentPolicy(parentPolicy);
/* 169 */     result.setParent(parent);
/* 170 */     registerDomain(result);
/* 171 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized ClassLoaderDomain getDomain(String name)
/*     */   {
/* 183 */     if (name == null) {
/* 184 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 186 */     if (this.shutdown) {
/* 187 */       throw new IllegalStateException("The classloader system is shutdown: " + toLongString());
/*     */     }
/* 189 */     ClassLoaderDomain result = (ClassLoaderDomain)this.registeredDomains.get(name);
/*     */ 
/* 192 */     if ((result == null) && ("<DEFAULT>".equals(name))) {
/* 193 */       result = getDefaultDomain();
/*     */     }
/* 195 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean isRegistered(String name)
/*     */   {
/* 207 */     return getDomain(name) != null;
/*     */   }
/*     */ 
/*     */   public boolean isDomainRegistered(ClassLoaderDomain domain)
/*     */   {
/* 219 */     if (domain == null)
/* 220 */       throw new IllegalArgumentException("Null domain");
/* 221 */     return getDomain(domain.getName()) == domain;
/*     */   }
/*     */ 
/*     */   public synchronized void registerDomain(ClassLoaderDomain domain)
/*     */   {
/* 233 */     if (domain == null) {
/* 234 */       throw new IllegalArgumentException("Null domain");
/*     */     }
/* 236 */     String name = domain.getName();
/* 237 */     if (isRegistered(name)) {
/* 238 */       throw new IllegalStateException("A domain is already registered with name " + name);
/*     */     }
/* 240 */     internalRegisterDomain(name, domain);
/*     */   }
/*     */ 
/*     */   private void internalRegisterDomain(String name, ClassLoaderDomain domain)
/*     */   {
/* 251 */     if (this.shutdown) {
/* 252 */       throw new IllegalStateException("The classloader system is shutdown: " + toLongString());
/*     */     }
/* 254 */     this.registeredDomains.put(name, domain);
/* 255 */     super.registerDomain(domain);
/*     */ 
/* 257 */     log.debug(this + " registered domain=" + domain.toLongString());
/*     */   }
/*     */ 
/*     */   public synchronized void unregisterDomain(ClassLoaderDomain domain)
/*     */   {
/* 269 */     if (!isDomainRegistered(domain)) {
/* 270 */       throw new IllegalStateException("Domain is not registered " + domain);
/*     */     }
/* 272 */     if ("<DEFAULT>".equals(domain.getName())) {
/* 273 */       throw new IllegalArgumentException("Cannot unregister the default domain");
/*     */     }
/* 275 */     internalUnregisterDomain(domain);
/*     */   }
/*     */ 
/*     */   private synchronized void internalUnregisterDomain(ClassLoaderDomain domain)
/*     */   {
/* 287 */     this.registeredDomains.remove(domain.getName());
/* 288 */     super.unregisterDomain(domain);
/*     */ 
/* 290 */     log.debug(this + " unregistered domain=" + domain.toLongString());
/*     */   }
/*     */ 
/*     */   public ClassLoader registerClassLoaderPolicy(ClassLoaderPolicy policy)
/*     */   {
/* 306 */     return registerClassLoaderPolicy(getDefaultDomain(), policy);
/*     */   }
/*     */ 
/*     */   public ClassLoader registerClassLoaderPolicy(ClassLoaderDomain domain, ClassLoaderPolicy policy)
/*     */   {
/* 320 */     if (!isDomainRegistered(domain)) {
/* 321 */       throw new IllegalStateException("Domain is not registered: " + domain);
/*     */     }
/* 323 */     synchronized (this)
/*     */     {
/* 325 */       if (this.shutdown)
/* 326 */         throw new IllegalStateException("The classloader system is shutdown: " + toLongString());
/*     */     }
/* 328 */     return super.registerClassLoaderPolicy(domain, policy);
/*     */   }
/*     */ 
/*     */   public void unregisterClassLoaderPolicy(ClassLoaderPolicy policy)
/*     */   {
/* 340 */     super.unregisterClassLoaderPolicy(policy);
/*     */   }
/*     */ 
/*     */   public void unregisterClassLoader(ClassLoader classLoader)
/*     */   {
/* 352 */     super.unregisterClassLoader(classLoader);
/*     */   }
/*     */ 
/*     */   public synchronized void shutdown()
/*     */   {
/* 362 */     if (this.shutdown) {
/* 363 */       return;
/*     */     }
/* 365 */     log.debug(toLongString() + " SHUTDOWN!");
/* 366 */     this.shutdown = true;
/*     */     while (true)
/*     */     {
/* 370 */       List domains = new ArrayList(this.registeredDomains.values());
/* 371 */       Iterator iterator = domains.iterator();
/* 372 */       if (!iterator.hasNext()) {
/*     */         break;
/*     */       }
/* 375 */       while (iterator.hasNext())
/*     */       {
/* 377 */         ClassLoaderDomain domain = (ClassLoaderDomain)iterator.next();
/* 378 */         internalUnregisterDomain(domain);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Translator getTranslator()
/*     */   {
/* 390 */     return this.translator;
/*     */   }
/*     */ 
/*     */   public void setTranslator(Translator translator)
/*     */   {
/* 400 */     log.debug(this + " set translator to " + translator);
/* 401 */     this.translator = translator;
/*     */   }
/*     */ 
/*     */   protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain)
/*     */     throws Exception
/*     */   {
/* 407 */     if (this.translator != null)
/* 408 */       return this.translator.transform(classLoader, className, null, protectionDomain, byteCode);
/* 409 */     return super.transform(classLoader, className, byteCode, protectionDomain);
/*     */   }
/*     */ 
/*     */   protected void afterUnregisterClassLoader(ClassLoader classLoader)
/*     */   {
/*     */     try
/*     */     {
/* 417 */       if (this.translator != null)
/* 418 */         this.translator.unregisterClassLoader(classLoader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 422 */       log.warn("Error unregistering classloader from translator " + classLoader, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/* 429 */     if (this.shutdown)
/* 430 */       builder.append("SHUTDOWN! ");
/* 431 */     super.toLongString(builder);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.spi.ClassLoaderSystem
 * JD-Core Version:    0.6.0
 */