/*    */ package org.jboss.classloader.plugins.system;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import org.jboss.classloader.spi.ClassLoaderSystem;
/*    */ 
/*    */ public class ClassLoaderSystemBuilder
/*    */ {
/* 42 */   private static final ClassLoaderSystem singleton = (ClassLoaderSystem)AccessController.doPrivileged(new PrivilegedAction()
/*    */   {
/*    */     public ClassLoaderSystem run()
/*    */     {
/* 46 */       String className = System.getProperty(ClassLoaderSystem.class.getName(), DefaultClassLoaderSystem.class.getName());
/*    */       try
/*    */       {
/* 49 */         Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 50 */         Object result = clazz.newInstance();
/* 51 */         return (ClassLoaderSystem)ClassLoaderSystem.class.cast(result);
/*    */       }
/*    */       catch (RuntimeException e)
/*    */       {
/* 55 */         throw e;
/*    */       }
/*    */       catch (Exception e) {
/*    */       }
/* 59 */       throw new Error("Unexpected error loading ClassLoaderSystem " + className, e);
/*    */     }
/*    */   });
/*    */ 
/*    */   public static ClassLoaderSystem get()
/*    */   {
/* 72 */     return singleton;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.system.ClassLoaderSystemBuilder
 * JD-Core Version:    0.6.0
 */