/*     */ package org.jboss.classloader.plugins.jdk;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoader;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
/*     */ import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.jdk.JDKChecker;
/*     */ 
/*     */ public class AbstractJDKChecker
/*     */   implements JDKChecker
/*     */ {
/*     */   private static final Hack hack;
/*  46 */   private static Set<Class<?>> excluded = new CopyOnWriteArraySet();
/*     */ 
/*     */   public boolean isExcluded(Class<?> clazz)
/*     */   {
/*  68 */     if (excluded.isEmpty()) {
/*  69 */       return false;
/*     */     }
/*  71 */     for (Class exclude : excluded)
/*     */     {
/*  73 */       if (exclude.isAssignableFrom(clazz)) {
/*  74 */         return true;
/*     */       }
/*     */     }
/*     */ 
/*  78 */     return false;
/*     */   }
/*     */ 
/*     */   public static Set<Class<?>> getExcluded()
/*     */   {
/*  88 */     SecurityManager sm = System.getSecurityManager();
/*  89 */     if (sm != null)
/*  90 */       sm.checkCreateClassLoader();
/*  91 */     return excluded;
/*     */   }
/*     */ 
/*     */   public boolean isJDKRequest(String name)
/*     */   {
/*  96 */     Class requesting = getRequestingClass(hack.getClassContext());
/*  97 */     return isJDKRequestingClass(name, requesting);
/*     */   }
/*     */ 
/*     */   protected Class<?> getRequestingClass(Class[] stack)
/*     */   {
/* 108 */     for (Class clazz : stack)
/*     */     {
/* 110 */       if ((!Hack.class.isAssignableFrom(clazz)) && (!JDKChecker.class.isAssignableFrom(clazz)) && (!BaseClassLoaderDomain.class.isAssignableFrom(clazz)) && (!BaseClassLoaderPolicy.class.isAssignableFrom(clazz)) && (!ClassLoader.class.isAssignableFrom(clazz)) && (!Class.class.isAssignableFrom(clazz)))
/*     */       {
/* 117 */         return clazz;
/*     */       }
/*     */     }
/* 120 */     throw new RuntimeException("Should not be here!");
/*     */   }
/*     */ 
/*     */   protected boolean isJDKRequestingClass(String name, Class<?> requesting)
/*     */   {
/* 135 */     if (isExcluded(requesting))
/* 136 */       return false;
/* 137 */     ClassLoader cl = requesting.getClassLoader();
/* 138 */     if (cl == null)
/* 139 */       return true;
/* 140 */     return !(cl instanceof BaseClassLoader);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  50 */     hack = (Hack)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public AbstractJDKChecker.Hack run()
/*     */       {
/*  54 */         return new AbstractJDKChecker.Hack(null);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static class Hack extends SecurityManager
/*     */   {
/*     */     public Class[] getClassContext()
/*     */     {
/* 151 */       return super.getClassContext();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.jdk.AbstractJDKChecker
 * JD-Core Version:    0.6.0
 */