/*     */ package org.jboss.classloader.plugins.filter;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import org.jboss.classloader.spi.filter.ClassFilter;
/*     */ 
/*     */ public class PatternClassFilter
/*     */   implements ClassFilter
/*     */ {
/*     */   private Pattern[] classPatterns;
/*     */   private Pattern[] resourcePatterns;
/*  45 */   private boolean includeJava = false;
/*     */ 
/*     */   public PatternClassFilter(String[] classPatterns, String[] resourcePatterns)
/*     */   {
/*  56 */     if (classPatterns == null) {
/*  57 */       throw new IllegalArgumentException("Null patterns");
/*     */     }
/*  59 */     this.classPatterns = new Pattern[classPatterns.length];
/*  60 */     for (int i = 0; i < classPatterns.length; i++)
/*     */     {
/*  62 */       if (classPatterns[i] == null)
/*  63 */         throw new IllegalArgumentException("Null pattern in " + Arrays.asList(classPatterns));
/*  64 */       this.classPatterns[i] = Pattern.compile(classPatterns[i]);
/*     */     }
/*     */ 
/*  67 */     if (resourcePatterns == null)
/*     */     {
/*  69 */       this.resourcePatterns = this.classPatterns;
/*  70 */       return;
/*     */     }
/*     */ 
/*  73 */     this.resourcePatterns = new Pattern[resourcePatterns.length];
/*  74 */     for (int i = 0; i < resourcePatterns.length; i++)
/*     */     {
/*  76 */       if (resourcePatterns[i] == null)
/*  77 */         throw new IllegalArgumentException("Null pattern in " + Arrays.asList(resourcePatterns));
/*  78 */       this.resourcePatterns[i] = Pattern.compile(resourcePatterns[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isIncludeJava()
/*     */   {
/*  89 */     return this.includeJava;
/*     */   }
/*     */ 
/*     */   public void setIncludeJava(boolean includeJava)
/*     */   {
/*  99 */     this.includeJava = includeJava;
/*     */   }
/*     */ 
/*     */   public boolean matchesClassName(String className)
/*     */   {
/* 104 */     if (className == null) {
/* 105 */       return false;
/*     */     }
/* 107 */     for (int i = 0; i < this.classPatterns.length; i++)
/*     */     {
/* 109 */       Matcher matcher = this.classPatterns[i].matcher(className);
/* 110 */       if (matcher.matches())
/* 111 */         return true;
/*     */     }
/* 113 */     if (!this.includeJava)
/* 114 */       return false;
/* 115 */     return JavaOnlyClassFilter.INSTANCE.matchesClassName(className);
/*     */   }
/*     */ 
/*     */   public boolean matchesResourcePath(String resourcePath)
/*     */   {
/* 120 */     if (resourcePath == null) {
/* 121 */       return false;
/*     */     }
/* 123 */     for (int i = 0; i < this.resourcePatterns.length; i++)
/*     */     {
/* 125 */       Matcher matcher = this.resourcePatterns[i].matcher(resourcePath);
/* 126 */       if (matcher.matches())
/* 127 */         return true;
/*     */     }
/* 129 */     if (!this.includeJava)
/* 130 */       return false;
/* 131 */     return JavaOnlyClassFilter.INSTANCE.matchesResourcePath(resourcePath);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 137 */     StringBuilder builder = new StringBuilder();
/* 138 */     builder.append(Arrays.asList(this.classPatterns));
/* 139 */     if (isIncludeJava())
/* 140 */       builder.append(" <INCLUDE_JAVA>");
/* 141 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classloader.plugins.filter.PatternClassFilter
 * JD-Core Version:    0.6.0
 */