/*    */ package org.jboss.classadapter.plugins;
/*    */ 
/*    */ import java.util.List;
/*    */ import org.jboss.classadapter.spi.ClassAdapter;
/*    */ import org.jboss.classadapter.spi.ClassAdapterFactory;
/*    */ import org.jboss.classadapter.spi.DependencyBuilder;
/*    */ import org.jboss.classadapter.spi.DependencyBuilderListItem;
/*    */ import org.jboss.config.spi.Configuration;
/*    */ import org.jboss.joinpoint.spi.JoinpointFactory;
/*    */ import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
/*    */ import org.jboss.metadata.spi.MetaData;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ import org.jboss.util.JBossObject;
/*    */ 
/*    */ public class BasicClassAdapter extends JBossObject
/*    */   implements ClassAdapter
/*    */ {
/*    */   protected ClassAdapterFactory classAdapterFactory;
/*    */   protected ClassInfo classInfo;
/*    */ 
/*    */   public BasicClassAdapter(ClassAdapterFactory factory, ClassInfo classInfo)
/*    */   {
/* 57 */     this.classAdapterFactory = factory;
/* 58 */     this.classInfo = classInfo;
/*    */   }
/*    */ 
/*    */   public ClassInfo getClassInfo()
/*    */   {
/* 63 */     return this.classInfo;
/*    */   }
/*    */ 
/*    */   public JoinpointFactory getJoinpointFactory()
/*    */   {
/* 68 */     JoinpointFactoryBuilder builder = this.classAdapterFactory.getConfiguration().getJoinpointFactoryBuilder();
/* 69 */     return builder.createJoinpointFactory(this.classInfo);
/*    */   }
/*    */ 
/*    */   public ClassLoader getClassLoader()
/*    */   {
/* 74 */     return this.classInfo.getType().getClassLoader();
/*    */   }
/*    */ 
/*    */   public List<DependencyBuilderListItem> getDependencies(MetaData metaData)
/*    */   {
/* 79 */     DependencyBuilder builder = this.classAdapterFactory.getConfiguration().getDependencyBuilder();
/* 80 */     return builder.getDependencies(this, metaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.classadapter.plugins.BasicClassAdapter
 * JD-Core Version:    0.6.0
 */