/*     */ package org.jboss.bootstrap.microcontainer;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Collections;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
/*     */ import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
/*     */ import org.jboss.bootstrap.AbstractServerImpl;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.event.KernelEvent;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.util.StopWatch;
/*     */ 
/*     */ public class ServerImpl extends AbstractServerImpl
/*     */ {
/*  48 */   public static String BOOTSTRAP_XML_NAME = "bootstrap-beans.xml";
/*     */   private BasicBootstrap bootstrap;
/*     */   private Kernel kernel;
/*     */   private BasicXMLDeployer kernelDeployer;
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/*  66 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   protected void doStart(StopWatch watch)
/*     */     throws Throwable
/*     */   {
/*  73 */     BasicBootstrap bootstrap = new BasicBootstrap();
/*  74 */     bootstrap.run();
/*  75 */     this.kernel = bootstrap.getKernel();
/*     */ 
/*  78 */     KernelController controller = this.kernel.getController();
/*  79 */     AbstractBeanMetaData metaData = new AbstractBeanMetaData("JBossServer", getClass().getName());
/*  80 */     InstallCallbackMetaData install = new InstallCallbackMetaData();
/*  81 */     install.setMethodName("addBootstrap");
/*  82 */     metaData.setInstallCallbacks(Collections.singletonList(install));
/*  83 */     UninstallCallbackMetaData uninstall = new UninstallCallbackMetaData();
/*  84 */     uninstall.setMethodName("removeBootstrap");
/*  85 */     metaData.setUninstallCallbacks(Collections.singletonList(uninstall));
/*  86 */     controller.install(metaData, this);
/*     */ 
/*  89 */     URL url = getConfig().getBootstrapURL();
/*  90 */     if (url == null)
/*     */     {
/*  92 */       URL configURL = getConfig().getServerConfigURL();
/*  93 */       url = new URL(configURL, BOOTSTRAP_XML_NAME);
/*  94 */       this.log.info("Starting Microcontainer, bootstrapURL=" + url);
/*     */     }
/*     */ 
/*  98 */     this.kernelDeployer = new BasicXMLDeployer(this.kernel);
/*     */ 
/* 101 */     this.kernelDeployer.deploy(url);
/*     */ 
/* 104 */     this.kernelDeployer.validate();
/*     */ 
/* 107 */     KernelEvent startEvent = bootstrap.createEvent("org.jboss.system.server.started", new Long(watch.getLapTime()));
/* 108 */     bootstrap.fireKernelEvent(startEvent);
/*     */ 
/* 110 */     this.bootstrap = bootstrap;
/*     */   }
/*     */ 
/*     */   protected void doShutdown()
/*     */   {
/*     */     try
/*     */     {
/* 119 */       if (this.bootstrap != null)
/*     */       {
/* 121 */         KernelEvent stopEvent = this.bootstrap.createEvent("org.jboss.system.server.stopped", null);
/* 122 */         this.bootstrap.fireKernelEvent(stopEvent);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 127 */       this.log.warn("Error sending stop notification", t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 133 */       if (this.kernelDeployer != null)
/*     */       {
/* 135 */         this.kernelDeployer.shutdown();
/* 136 */         this.kernelDeployer = null;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 141 */       this.log.warn("Error stopping xml deployer", t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 147 */       Kernel currentKernel = null;
/* 148 */       if (this.kernel != null)
/*     */       {
/* 150 */         currentKernel = this.kernel;
/* 151 */         this.kernel = null;
/*     */       }
/* 153 */       else if (this.bootstrap != null)
/*     */       {
/* 155 */         currentKernel = this.bootstrap.getKernel();
/*     */       }
/* 157 */       this.bootstrap = null;
/*     */ 
/* 159 */       if (currentKernel != null)
/*     */       {
/* 161 */         KernelController controller = currentKernel.getController();
/* 162 */         controller.shutdown();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 167 */       this.log.warn("Error stopping xml deployer", t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.bootstrap.microcontainer.ServerImpl
 * JD-Core Version:    0.6.0
 */