/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.Cardinality;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.plugins.dependency.AttributeInfo;
/*     */ import org.jboss.kernel.plugins.dependency.BasicCollectionCallbackItemFactory;
/*     */ import org.jboss.kernel.plugins.dependency.ClassAttributeCallbackItem;
/*     */ import org.jboss.kernel.plugins.dependency.ClassSingleCallbackItem;
/*     */ import org.jboss.kernel.plugins.dependency.CollectionCallbackItemFactory;
/*     */ import org.jboss.kernel.plugins.dependency.MethodAttributeInfo;
/*     */ import org.jboss.kernel.plugins.dependency.PropertyAttributeInfo;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class CallbackCreatorUtil
/*     */ {
/*     */   protected static Logger log;
/*     */   protected static CollectionCallbackItemFactory factory;
/*     */ 
/*     */   protected static Logger getLog()
/*     */   {
/*  58 */     if (log == null)
/*  59 */       log = Logger.getLogger(CallbackCreatorUtil.class);
/*  60 */     return log;
/*     */   }
/*     */ 
/*     */   private static CallbackItem<Class> createCollectionCallback(TypeInfo info, KernelControllerContext context, AttributeInfo attribute, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality)
/*     */   {
/*  83 */     if ((info instanceof ClassInfo))
/*     */     {
/*  85 */       ClassInfo ci = (ClassInfo)info;
/*  86 */       TypeInfo componentType = ci.getComponentType();
/*  87 */       if (componentType == null)
/*  88 */         throw new IllegalArgumentException("Null component type: " + info);
/*  89 */       Class clazz = componentType.getType();
/*  90 */       if (Object.class.equals(clazz))
/*  91 */         throw new IllegalArgumentException("Component type too general - equals Object: " + info);
/*  92 */       return getCollectionFactory().createCollectionCallbackItem(info.getType(), clazz, whenRequired, dependentState, cardinality, context, attribute);
/*     */     }
/*     */ 
/*  95 */     throw new IllegalArgumentException("Unable to determine collection element class type: " + info);
/*     */   }
/*     */ 
/*     */   public static CallbackItem<Class> createCallback(KernelControllerContext context, AttributeInfo ai, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality)
/*     */   {
/* 115 */     if (!ai.isValid()) {
/* 116 */       throw new IllegalArgumentException("Not a valid attribute info: " + ai);
/*     */     }
/* 118 */     TypeInfo info = ai.getType();
/* 119 */     if (info.isCollection())
/* 120 */       return createCollectionCallback(info, context, ai, whenRequired, dependentState, cardinality);
/* 121 */     if (ai.isProperty()) {
/* 122 */       return new ClassAttributeCallbackItem(info.getType(), whenRequired, dependentState, cardinality, context, ai.getName());
/*     */     }
/* 124 */     return new ClassSingleCallbackItem(info.getType(), whenRequired, dependentState, cardinality, context, ai.getName(), info.getName());
/*     */   }
/*     */ 
/*     */   public static CallbackItem<Class> createCallback(KernelControllerContext context, PropertyInfo pi, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality)
/*     */   {
/* 144 */     return createCallback(context, new PropertyAttributeInfo(pi), whenRequired, dependentState, cardinality);
/*     */   }
/*     */ 
/*     */   public static CallbackItem<Class> createCallback(KernelControllerContext context, MethodInfo mi, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality)
/*     */   {
/* 164 */     return createCallback(context, new MethodAttributeInfo(mi), whenRequired, dependentState, cardinality);
/*     */   }
/*     */ 
/*     */   public static CollectionCallbackItemFactory getCollectionFactory()
/*     */   {
/* 176 */     if (factory == null)
/*     */     {
/* 178 */       FactoryLookup lookup = new FactoryLookup(null);
/* 179 */       factory = (CollectionCallbackItemFactory)AccessController.doPrivileged(lookup);
/*     */     }
/* 181 */     return factory;
/*     */   }
/*     */ 
/*     */   private static class FactoryLookup
/*     */     implements PrivilegedAction<CollectionCallbackItemFactory>
/*     */   {
/*     */     public CollectionCallbackItemFactory run()
/*     */     {
/*     */       try
/*     */       {
/* 191 */         String factoryClassName = System.getProperty("org.jboss.dependency.collectionCallbackItemFactory", BasicCollectionCallbackItemFactory.class.getName());
/* 192 */         Object result = ReflectionUtils.newInstance(factoryClassName);
/* 193 */         return (CollectionCallbackItemFactory)CollectionCallbackItemFactory.class.cast(result);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 197 */         CallbackCreatorUtil.getLog().warn("Exception while creating CollectionCallbackItemFactory, using basic one instead.", t);
/* 198 */       }return new BasicCollectionCallbackItemFactory();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.CallbackCreatorUtil
 * JD-Core Version:    0.6.0
 */