/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*     */ import org.jboss.joinpoint.spi.Joinpoint;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class AbstractTypeMetaData extends AbstractValueMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected String type;
/*     */   protected transient ControllerContext context;
/*     */   protected transient KernelConfigurator configurator;
/*     */   protected String propertyName;
/*     */   protected String beanName;
/*     */ 
/*     */   public AbstractTypeMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractTypeMetaData(String value)
/*     */   {
/*  96 */     super(value);
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 106 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 111 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 116 */     this.context = visitor.getControllerContext();
/* 117 */     this.configurator = visitor.getControllerContext().getKernel().getConfigurator();
/* 118 */     preparePreinstantiatedLookup(visitor);
/* 119 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   protected void preparePreinstantiatedLookup(MetaDataVisitor visitor)
/*     */   {
/* 130 */     Stack visitorNodes = visitor.visitorNodeStack();
/*     */ 
/* 132 */     MetaDataVisitorNode parent = (MetaDataVisitorNode)visitorNodes.pop();
/*     */     try
/*     */     {
/* 135 */       if ((parent instanceof PropertyMetaData))
/*     */       {
/* 137 */         PropertyMetaData pmd = (PropertyMetaData)parent;
/* 138 */         if (pmd.isPreInstantiate())
/*     */         {
/* 140 */           this.propertyName = pmd.getName();
/* 141 */           Object gp = visitorNodes.peek();
/* 142 */           if ((gp instanceof BeanMetaData))
/*     */           {
/* 144 */             BeanMetaData bmd = (BeanMetaData)gp;
/* 145 */             this.beanName = bmd.getName();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 152 */       visitorNodes.push(parent);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected <T> T preinstantiatedLookup(ClassLoader cl, Class<T> expected)
/*     */   {
/* 166 */     if ((this.propertyName != null) && (this.beanName != null))
/*     */     {
/* 168 */       Object result = null;
/*     */       try
/*     */       {
/* 171 */         Controller controller = this.context.getController();
/* 172 */         ControllerContext context = controller.getContext(this.beanName, ControllerState.INSTANTIATED);
/* 173 */         if ((context != null) && ((context instanceof AttributeDispatchContext)))
/*     */         {
/* 175 */           Object target = context.getTarget();
/* 176 */           if (target != null)
/*     */           {
/* 178 */             BeanInfo beanInfo = this.configurator.getBeanInfo(target.getClass());
/* 179 */             PropertyInfo pi = Configurator.resolveProperty(this.log.isTraceEnabled(), beanInfo, cl, this.propertyName, null);
/* 180 */             if (pi.getGetter() != null)
/*     */             {
/* 182 */               result = ((AttributeDispatchContext)context).get(this.propertyName);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 189 */         this.log.warn("Exception in preinstantiated lookup for: " + this.beanName + "." + this.propertyName + ", " + t);
/*     */       }
/* 191 */       return checkResult(result, expected);
/*     */     }
/* 193 */     return null;
/*     */   }
/*     */ 
/*     */   protected <T> T checkResult(Object result, Class<T> expected)
/*     */   {
/* 207 */     if ((result != null) && (!expected.isAssignableFrom(result.getClass())))
/* 208 */       throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
/* 209 */     return expected.cast(result);
/*     */   }
/*     */ 
/*     */   protected <T> T createInstance(TypeInfo info, ClassLoader cl, Class<T> expected, boolean explicit)
/*     */     throws Throwable
/*     */   {
/* 226 */     if ((info == null) || (Object.class.getName().equals(info.getName()))) {
/* 227 */       return null;
/*     */     }
/* 229 */     if (!(info instanceof ClassInfo))
/*     */     {
/* 231 */       if (explicit) {
/* 232 */         throw new IllegalArgumentException(info.getName() + " is not a class");
/*     */       }
/* 234 */       return null;
/*     */     }
/*     */ 
/* 237 */     if (((ClassInfo)info).isInterface())
/*     */     {
/* 239 */       if (explicit) {
/* 240 */         throw new IllegalArgumentException(info.getName() + " is an interface");
/*     */       }
/* 242 */       return null;
/*     */     }
/*     */ 
/* 245 */     BeanInfo beanInfo = this.configurator.getBeanInfo(info);
/* 246 */     Joinpoint constructor = this.configurator.getConstructorJoinPoint(beanInfo);
/* 247 */     Object result = constructor.dispatch();
/*     */ 
/* 249 */     if (!expected.isAssignableFrom(result.getClass())) {
/* 250 */       throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
/*     */     }
/* 252 */     return expected.cast(result);
/*     */   }
/*     */ 
/*     */   protected <T> T getTypeInstance(TypeInfo info, ClassLoader cl, Class<T> expected)
/*     */     throws Throwable
/*     */   {
/* 267 */     Object result = null;
/*     */ 
/* 269 */     TypeInfo typeInfo = getClassInfo(cl);
/*     */ 
/* 271 */     if (typeInfo != null) {
/* 272 */       result = createInstance(typeInfo, cl, expected, true);
/*     */     }
/* 274 */     if (result == null)
/*     */     {
/* 276 */       result = preinstantiatedLookup(cl, expected);
/*     */ 
/* 278 */       if (result == null)
/*     */       {
/* 280 */         result = createInstance(info, cl, expected, false);
/*     */ 
/* 282 */         if (result == null) {
/* 283 */           result = expected.cast(getDefaultInstance());
/*     */         }
/*     */       }
/*     */     }
/* 287 */     return result;
/*     */   }
/*     */ 
/*     */   protected abstract Object getDefaultInstance();
/*     */ 
/*     */   public void setConfigurator(KernelConfigurator configurator)
/*     */   {
/* 304 */     this.configurator = configurator;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 309 */     super.toString(buffer);
/* 310 */     if (this.type != null)
/* 311 */       buffer.append(" type=").append(this.type);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getClassInfo(ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 323 */     return getClassInfo(this.type, cl);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getClassInfo(String classType, ClassLoader cl) throws Throwable
/*     */   {
/* 328 */     if (classType == null) {
/* 329 */       return null;
/*     */     }
/* 331 */     return this.configurator.getClassInfo(classType, cl);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getClass(MetaDataVisitor visitor, String classType) throws Throwable
/*     */   {
/* 336 */     KernelControllerContext context = visitor.getControllerContext();
/* 337 */     ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 338 */     return getClassInfo(classType, cl);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractTypeMetaData
 * JD-Core Version:    0.6.0
 */