/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractLifecycleMetaData extends AbstractFeatureMetaData
/*     */   implements LifecycleMetaData, MutableParameterizedMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected ControllerState state;
/*     */   protected String methodName;
/*     */   boolean ignored;
/*     */   protected List<ParameterMetaData> parameters;
/*     */   protected String type;
/*     */ 
/*     */   public AbstractLifecycleMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractLifecycleMetaData(String methodName)
/*     */   {
/*  77 */     this.methodName = methodName;
/*     */   }
/*     */ 
/*     */   public ControllerState getState()
/*     */   {
/*  82 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void setState(ControllerState state)
/*     */   {
/*  87 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public String getMethodName()
/*     */   {
/*  92 */     return this.methodName;
/*     */   }
/*     */ 
/*     */   public void setMethodName(String name)
/*     */   {
/* 102 */     this.methodName = name;
/* 103 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public boolean isIgnored()
/*     */   {
/* 108 */     return this.ignored;
/*     */   }
/*     */ 
/*     */   public void setIgnored(boolean ignored)
/*     */   {
/* 118 */     this.ignored = ignored;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getParameters()
/*     */   {
/* 123 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public void setParameters(List<ParameterMetaData> parameters)
/*     */   {
/* 133 */     this.parameters = parameters;
/* 134 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 144 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 149 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 154 */     visitor.setContextState(this.state);
/* 155 */     super.initialVisit(visitor);
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 160 */     super.addChildren(children);
/* 161 */     if (this.parameters != null)
/* 162 */       children.addAll(this.parameters);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 167 */     ParameterMetaData parameter = (ParameterMetaData)previous;
/* 168 */     KernelControllerContext context = visitor.getControllerContext();
/* 169 */     String method = this.methodName != null ? this.methodName : this.type;
/* 170 */     String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
/* 171 */     MethodInfo methodInfo = Configurator.findMethodInfo(getClassInfo(context), method, parameterTypes);
/* 172 */     return applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()]);
/*     */   }
/*     */ 
/*     */   protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable
/*     */   {
/* 177 */     return context.getBeanInfo().getClassInfo();
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 182 */     if (this.methodName != null)
/* 183 */       buffer.append("method=").append(this.methodName);
/* 184 */     buffer.append(" parameters=");
/* 185 */     JBossObject.list(buffer, this.parameters);
/* 186 */     buffer.append(" ");
/* 187 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 192 */     buffer.append(this.methodName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData
 * JD-Core Version:    0.6.0
 */