/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.metadata.spi.AutowireType;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AttributeCallbackItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.plugins.dependency.ClassContextDependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractInjectionValueMetaData extends AbstractDependencyValueMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*  48 */   protected AutowireType injectionType = AutowireType.BY_CLASS;
/*     */ 
/*  50 */   protected InjectionOption injectionOption = InjectionOption.STRICT;
/*     */   protected FromContext fromContext;
/*     */   protected AbstractPropertyMetaData propertyMetaData;
/*     */ 
/*     */   public AbstractInjectionValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractInjectionValueMetaData(Object value)
/*     */   {
/*  73 */     super(value);
/*     */   }
/*     */ 
/*     */   public AbstractInjectionValueMetaData(Object value, String property)
/*     */   {
/*  84 */     super(value, property);
/*     */   }
/*     */ 
/*     */   public AutowireType getInjectionType()
/*     */   {
/*  89 */     return this.injectionType;
/*     */   }
/*     */ 
/*     */   public void setInjectionType(AutowireType injectionType)
/*     */   {
/*  94 */     this.injectionType = injectionType;
/*     */   }
/*     */ 
/*     */   public InjectionOption getInjectionOption()
/*     */   {
/*  99 */     return this.injectionOption;
/*     */   }
/*     */ 
/*     */   public void setInjectionOption(InjectionOption injectionOption)
/*     */   {
/* 104 */     this.injectionOption = injectionOption;
/*     */   }
/*     */ 
/*     */   public FromContext getFromContext()
/*     */   {
/* 109 */     return this.fromContext;
/*     */   }
/*     */ 
/*     */   public void setFromContext(FromContext fromContext)
/*     */   {
/* 114 */     this.fromContext = fromContext;
/*     */   }
/*     */ 
/*     */   public AbstractPropertyMetaData getPropertyMetaData()
/*     */   {
/* 119 */     return this.propertyMetaData;
/*     */   }
/*     */ 
/*     */   public void setPropertyMetaData(AbstractPropertyMetaData propertyMetaData)
/*     */   {
/* 124 */     this.propertyMetaData = propertyMetaData;
/*     */   }
/*     */ 
/*     */   protected void addInstallItem(Object name)
/*     */   {
/* 129 */     if (this.propertyMetaData == null)
/* 130 */       throw new IllegalArgumentException("Illegal usage of option Callback - injection not used with property = " + this);
/* 131 */     this.context.getDependencyInfo().addInstallItem(new AttributeCallbackItem(name, this.whenRequiredState, this.dependentState, this.context, this.propertyMetaData.getName()));
/*     */   }
/*     */ 
/*     */   protected boolean isLookupValid(ControllerContext lookup)
/*     */   {
/* 136 */     boolean lookupExists = super.isLookupValid(lookup);
/* 137 */     boolean isCallback = InjectionOption.CALLBACK.equals(this.injectionOption);
/* 138 */     if ((!lookupExists) && (isCallback))
/*     */     {
/* 140 */       addInstallItem(getUnderlyingValue());
/*     */     }
/* 142 */     return (lookupExists) || (isCallback);
/*     */   }
/*     */ 
/*     */   public Object getValue(TypeInfo info, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 149 */     if (this.fromContext != null)
/*     */     {
/* 151 */       ControllerState state = this.dependentState;
/* 152 */       if (state == null)
/* 153 */         state = ControllerState.INSTANTIATED;
/* 154 */       Controller controller = this.context.getController();
/* 155 */       ControllerContext lookup = controller.getContext(getUnderlyingValue(), state);
/* 156 */       if (lookup == null)
/* 157 */         throw new Error("Should not be here - dependency failed - " + this);
/* 158 */       return this.fromContext.executeLookup(lookup);
/*     */     }
/*     */ 
/* 162 */     if (getUnderlyingValue() == null)
/*     */     {
/* 164 */       Controller controller = this.context.getController();
/* 165 */       ControllerContext lookup = controller.getInstalledContext(info.getType());
/* 166 */       if (lookup == null)
/*     */       {
/* 168 */         if (InjectionOption.STRICT.equals(this.injectionOption))
/*     */         {
/* 170 */           throw new IllegalArgumentException("Possible multiple matching beans, see log for info.");
/*     */         }
/*     */ 
/* 174 */         addInstallItem(info.getType());
/* 175 */         return null;
/*     */       }
/*     */ 
/* 179 */       return lookup.getTarget();
/*     */     }
/* 181 */     return super.getValue(info, cl);
/*     */   }
/*     */ 
/*     */   protected boolean addDependencyItem()
/*     */   {
/* 186 */     return (InjectionOption.STRICT.equals(this.injectionOption)) || (this.fromContext != null);
/*     */   }
/*     */ 
/*     */   public Object getUnderlyingValue()
/*     */   {
/* 191 */     Object original = super.getUnderlyingValue();
/* 192 */     return (this.fromContext != null) && (original == null) ? this.context.getName() : original;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 198 */     if (this.fromContext != null)
/*     */     {
/* 201 */       if (super.getUnderlyingValue() == null)
/*     */       {
/* 203 */         ControllerState when = this.whenRequiredState;
/* 204 */         if (when == null) {
/* 205 */           when = visitor.getContextState();
/*     */         }
/* 207 */         KernelControllerContext kcc = visitor.getControllerContext();
/* 208 */         Controller controller = kcc.getController();
/* 209 */         List states = controller.getStates();
/* 210 */         int whenIndex = states.indexOf(when);
/*     */ 
/* 212 */         if (this.dependentState == null)
/*     */         {
/* 214 */           this.dependentState = ((ControllerState)states.get(whenIndex - 1));
/*     */         }
/*     */         else
/*     */         {
/* 218 */           int dependentIndex = states.indexOf(this.dependentState);
/* 219 */           if (whenIndex <= dependentIndex)
/*     */           {
/* 221 */             this.dependentState = ((ControllerState)states.get(whenIndex - 1));
/* 222 */             if (this.log.isTraceEnabled())
/* 223 */               this.log.trace("Cannot set demand state to more/equal than when required state, changing it to : " + this.dependentState);
/*     */           }
/*     */         }
/*     */       }
/* 227 */       super.initialVisit(visitor);
/* 228 */       return;
/*     */     }
/*     */ 
/* 232 */     if (getUnderlyingValue() == null)
/*     */     {
/* 235 */       if (this.property != null)
/*     */       {
/* 237 */         this.property = null;
/* 238 */         this.log.warn("Ignoring property - contextual injection: " + this);
/*     */       }
/*     */ 
/* 241 */       if (AutowireType.BY_NAME.equals(this.injectionType))
/*     */       {
/* 243 */         if (this.propertyMetaData == null)
/* 244 */           throw new IllegalArgumentException("Illegal usage of type ByName - injection not used with property = " + this);
/* 245 */         setValue(this.propertyMetaData.getName());
/*     */       }
/*     */       else
/*     */       {
/* 249 */         visitor.initialVisit(this);
/*     */       }
/*     */     }
/*     */ 
/* 253 */     if (getUnderlyingValue() != null)
/*     */     {
/* 255 */       super.initialVisit(visitor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor visitor)
/*     */   {
/* 262 */     if (getUnderlyingValue() == null)
/*     */     {
/* 264 */       if (AutowireType.BY_CLASS.equals(this.injectionType))
/*     */       {
/* 266 */         this.context = visitor.getControllerContext();
/*     */ 
/* 269 */         if (InjectionOption.STRICT.equals(this.injectionOption))
/*     */         {
/* 278 */           MetaDataVisitorNode node = (MetaDataVisitorNode)visitor.visitorNodeStack().pop();
/*     */           try
/*     */           {
/* 281 */             if ((node instanceof TypeProvider))
/*     */             {
/* 283 */               TypeProvider typeProvider = (TypeProvider)node;
/* 284 */               Class injectionClass = typeProvider.getType(visitor, this).getType();
/*     */ 
/* 286 */               ControllerState whenRequired = this.whenRequiredState;
/* 287 */               if (whenRequired == null)
/*     */               {
/* 289 */                 whenRequired = visitor.getContextState();
/*     */               }
/* 291 */               DependencyItem item = new ClassContextDependencyItem(this.context.getName(), injectionClass, whenRequired, this.dependentState);
/*     */ 
/* 296 */               visitor.addDependency(item);
/*     */             }
/*     */             else
/*     */             {
/* 300 */               throw new Error("Node not of TypeProvider instance, cannot determine type info.");
/*     */             }
/*     */           }
/*     */           catch (Error error)
/*     */           {
/* 305 */             throw error;
/*     */           }
/*     */           catch (Throwable throwable)
/*     */           {
/* 309 */             throw new Error(throwable);
/*     */           }
/*     */           finally
/*     */           {
/* 313 */             visitor.visitorNodeStack().push(node);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 319 */         throw new IllegalArgumentException("Unknown injection type=" + this.injectionType);
/*     */       }
/*     */     }
/* 322 */     super.describeVisit(visitor);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 327 */     super.toString(buffer);
/* 328 */     if (this.injectionType != null)
/* 329 */       buffer.append(" injectionType=").append(this.injectionType);
/* 330 */     if (this.propertyMetaData != null)
/* 331 */       buffer.append(" propertyMetaData=").append(this.propertyMetaData.getName());
/* 332 */     if (this.fromContext != null)
/* 333 */       buffer.append(" fromContext=").append(this.fromContext);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData
 * JD-Core Version:    0.6.0
 */