/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractConstructorMetaData extends AbstractFeatureMetaData
/*     */   implements ConstructorMetaData, MutableParameterizedMetaData, ValueMetaDataAware, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected List<ParameterMetaData> parameters;
/*     */   protected ValueMetaData value;
/*     */   protected ValueMetaData factory;
/*     */   protected String factoryClassName;
/*     */   protected String factoryMethod;
/*     */ 
/*     */   public void setParameters(List<ParameterMetaData> parameters)
/*     */   {
/*  95 */     this.parameters = parameters;
/*  96 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setValue(ValueMetaData value)
/*     */   {
/* 106 */     this.value = value;
/* 107 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setFactory(ValueMetaData factory)
/*     */   {
/* 117 */     this.factory = factory;
/* 118 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setFactoryClass(String name)
/*     */   {
/* 128 */     this.factoryClassName = name;
/* 129 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setFactoryMethod(String name)
/*     */   {
/* 139 */     this.factoryMethod = name;
/* 140 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getParameters()
/*     */   {
/* 145 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValue()
/*     */   {
/* 150 */     return this.value;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getFactory()
/*     */   {
/* 155 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public String getFactoryClass()
/*     */   {
/* 160 */     return this.factoryClassName;
/*     */   }
/*     */ 
/*     */   public String getFactoryMethod()
/*     */   {
/* 165 */     return this.factoryMethod;
/*     */   }
/*     */ 
/*     */   protected void addChildren(Set<MetaDataVisitorNode> children)
/*     */   {
/* 170 */     super.addChildren(children);
/* 171 */     if (this.parameters != null)
/* 172 */       children.addAll(this.parameters);
/* 173 */     if (this.value != null)
/* 174 */       children.add(this.value);
/* 175 */     if (this.factory != null)
/* 176 */       children.add(this.factory);
/*     */   }
/*     */ 
/*     */   public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable
/*     */   {
/* 181 */     if ((this.factory != null) || (this.factoryClassName != null))
/*     */     {
/* 183 */       KernelControllerContext context = visitor.getControllerContext();
/* 184 */       ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 185 */       KernelConfigurator configurator = context.getKernel().getConfigurator();
/*     */       ClassInfo classInfo;
/*     */       ClassInfo classInfo;
/* 187 */       if (this.factory != null)
/*     */       {
/* 189 */         Object target = this.factory.getValue(null, cl);
/* 190 */         classInfo = configurator.getClassInfo(target.getClass());
/*     */       }
/*     */       else
/*     */       {
/* 194 */         classInfo = configurator.getClassInfo(this.factoryClassName, cl);
/*     */       }
/*     */ 
/* 197 */       ParameterMetaData parameter = (ParameterMetaData)previous;
/* 198 */       String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
/* 199 */       MethodInfo methodInfo = Configurator.findMethodInfo(classInfo, this.factoryMethod, parameterTypes, this.factoryClassName != null, true);
/* 200 */       return applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()]);
/*     */     }
/*     */ 
/* 204 */     KernelControllerContext context = visitor.getControllerContext();
/* 205 */     BeanInfo beanInfo = context.getBeanInfo();
/*     */ 
/* 207 */     if ((previous instanceof ParameterMetaData))
/*     */     {
/* 209 */       ParameterMetaData parameter = (ParameterMetaData)previous;
/* 210 */       String[] paramTypes = Configurator.getParameterTypes(false, this.parameters);
/* 211 */       ConstructorInfo ci = Configurator.findConstructorInfo(beanInfo.getClassInfo(), paramTypes);
/* 212 */       return applyCollectionOrMapCheck(ci.getParameterTypes()[parameter.getIndex()]);
/*     */     }
/*     */ 
/* 218 */     ClassInfo type = beanInfo.getClassInfo();
/* 219 */     this.log.warn("Constructing bean from injection value: results in multiple beans with same class type - " + type);
/* 220 */     return type;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 247 */     buffer.append("parameters=");
/* 248 */     JBossObject.list(buffer, this.parameters);
/* 249 */     if (this.value != null)
/* 250 */       buffer.append(" value=").append(this.value);
/* 251 */     if (this.factory != null)
/* 252 */       buffer.append(" factory=").append(this.factory);
/* 253 */     if (this.factoryClassName != null)
/* 254 */       buffer.append(" factoryClass=").append(this.factoryClassName);
/* 255 */     if (this.factoryMethod != null)
/* 256 */       buffer.append(" factoryMethod=").append(this.factoryMethod);
/* 257 */     super.toString(buffer);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractConstructorMetaData
 * JD-Core Version:    0.6.0
 */