/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractClassLoaderMetaData extends JBossObject
/*     */   implements ClassLoaderMetaData, BeanMetaDataFactory, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected ValueMetaData classloader;
/*     */ 
/*     */   public AbstractClassLoaderMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractClassLoaderMetaData(ValueMetaData classloader)
/*     */   {
/*  68 */     this.classloader = classloader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ValueMetaData classloader)
/*     */   {
/*  78 */     this.classloader = classloader;
/*  79 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ValueMetaData getClassLoader()
/*     */   {
/*  84 */     return this.classloader;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  89 */     if ((this.classloader instanceof BeanMetaDataFactory))
/*     */     {
/*  91 */       return ((BeanMetaDataFactory)this.classloader).getBeans();
/*     */     }
/*  93 */     if ((this.classloader instanceof BeanMetaData))
/*     */     {
/*  95 */       return Collections.singletonList((BeanMetaData)this.classloader);
/*     */     }
/*  97 */     return new ArrayList();
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 102 */     visitor.setContextState(ControllerState.PRE_INSTALL);
/* 103 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 109 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 114 */     if (this.classloader != null)
/* 115 */       return Collections.singletonList(this.classloader).iterator();
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 121 */     buffer.append("classloader=").append(this.classloader);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 126 */     buffer.append(this.classloader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData
 * JD-Core Version:    0.6.0
 */