/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.CallbackMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.Cardinality;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.plugins.dependency.CallbackDependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class AbstractCallbackMetaData extends AbstractLifecycleMetaData
/*     */   implements CallbackMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected Cardinality cardinality;
/*     */   protected String property;
/*  55 */   protected ControllerState whenRequired = ControllerState.CONFIGURED;
/*     */ 
/*  58 */   protected ControllerState dependentState = ControllerState.INSTALLED;
/*     */   protected String signature;
/*     */   protected transient PropertyInfo propertyInfo;
/*     */   protected transient MethodInfo methodInfo;
/*     */ 
/*     */   public AbstractCallbackMetaData()
/*     */   {
/*  71 */     setState(ControllerState.CONFIGURED);
/*     */   }
/*     */ 
/*     */   public String getProperty()
/*     */   {
/*  76 */     return this.property;
/*     */   }
/*     */ 
/*     */   public void setProperty(String property)
/*     */   {
/*  86 */     this.property = property;
/*  87 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Cardinality getCardinality()
/*     */   {
/*  92 */     return this.cardinality;
/*     */   }
/*     */ 
/*     */   public void setCardinality(Cardinality cardinality)
/*     */   {
/* 102 */     this.cardinality = cardinality;
/* 103 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequiredState()
/*     */   {
/* 108 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public void setWhenRequired(ControllerState whenRequired)
/*     */   {
/* 118 */     this.whenRequired = whenRequired;
/* 119 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getSignature()
/*     */   {
/* 124 */     return this.signature;
/*     */   }
/*     */ 
/*     */   public void setSignature(String signature)
/*     */   {
/* 134 */     this.signature = signature;
/* 135 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void setDependentState(ControllerState dependentState)
/*     */   {
/* 145 */     this.dependentState = dependentState;
/* 146 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/* 151 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public void setPropertyInfo(PropertyInfo propertyInfo)
/*     */   {
/* 156 */     this.propertyInfo = propertyInfo;
/* 157 */     this.property = propertyInfo.getName();
/*     */   }
/*     */ 
/*     */   public void setMethodInfo(MethodInfo methodInfo)
/*     */   {
/* 162 */     this.methodInfo = methodInfo;
/* 163 */     this.methodName = methodInfo.getName();
/*     */   }
/*     */ 
/*     */   protected abstract void addCallback(MetaDataVisitor paramMetaDataVisitor, CallbackItem paramCallbackItem);
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/*     */     try
/*     */     {
/* 178 */       KernelControllerContext context = vistor.getControllerContext();
/*     */       CallbackItem callback;
/* 180 */       if (this.property != null)
/*     */       {
/* 182 */         if (this.propertyInfo == null)
/*     */         {
/* 184 */           ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 185 */           this.propertyInfo = Configurator.resolveProperty(this.log.isTraceEnabled(), context.getBeanInfo(), cl, this.property, this.signature);
/*     */         }
/* 187 */         callback = CallbackCreatorUtil.createCallback(context, this.propertyInfo, this.whenRequired, this.dependentState, this.cardinality);
/*     */       }
/*     */       else
/*     */       {
/*     */         CallbackItem callback;
/* 189 */         if (this.methodName != null)
/*     */         {
/* 191 */           if (this.methodInfo == null)
/* 192 */             this.methodInfo = Configurator.findMethodInfo(getClassInfo(context), this.methodName, new String[] { this.signature });
/* 193 */           callback = CallbackCreatorUtil.createCallback(context, this.methodInfo, this.whenRequired, this.dependentState, this.cardinality);
/*     */         }
/*     */         else {
/* 196 */           throw new IllegalArgumentException("Illegal usage - not property or method:" + this);
/*     */         }
/*     */       }
/*     */       CallbackItem callback;
/* 199 */       addCallback(vistor, callback);
/*     */ 
/* 202 */       if (this.cardinality != null)
/*     */       {
/* 204 */         vistor.addDependency(new CallbackDependencyItem(context.getName(), (Class)callback.getIDependOn(), this.whenRequired, this.dependentState, this.cardinality));
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 209 */       throw new Error(t);
/*     */     }
/* 211 */     super.describeVisit(vistor);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 216 */     super.toString(buffer);
/* 217 */     if (this.property != null)
/* 218 */       buffer.append(" property=").append(this.property);
/* 219 */     if (this.cardinality != null)
/* 220 */       buffer.append(" cardinality=").append(this.cardinality);
/* 221 */     if (this.signature != null)
/* 222 */       buffer.append(" signature=").append(this.signature);
/* 223 */     if (!ControllerState.INSTALLED.equals(this.dependentState))
/* 224 */       buffer.append(" dependentState=" + this.dependentState);
/* 225 */     if (!ControllerState.CONFIGURED.equals(this.whenRequired))
/* 226 */       buffer.append(" whenRequiredState=" + this.dependentState);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 231 */     if (this.property != null)
/* 232 */       buffer.append("property=").append(this.property);
/* 233 */     if (this.methodName != null)
/* 234 */       buffer.append("method=").append(this.methodName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractCallbackMetaData
 * JD-Core Version:    0.6.0
 */