/*     */ package org.jboss.beans.metadata.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.AliasMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class AbstractAliasMetaData extends JBossObject
/*     */   implements AliasMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  46 */   private static TypeInfoFactory typeInfoFactory = new IntrospectionTypeInfoFactory();
/*     */   public String alias;
/*  50 */   protected boolean replace = true;
/*     */   protected String clazz;
/*     */ 
/*     */   public String getAlias()
/*     */   {
/*  63 */     return this.alias;
/*     */   }
/*     */ 
/*     */   public void setAlias(String alias)
/*     */   {
/*  68 */     this.alias = alias;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/*  73 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/*  78 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public String getClazz()
/*     */   {
/*  83 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public void setClazz(String clazz)
/*     */   {
/*  88 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public Object getAliasValue()
/*     */   {
/*     */     try
/*     */     {
/*  95 */       if (this.clazz != null)
/*     */       {
/*  97 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*  98 */         TypeInfo info = typeInfoFactory.getTypeInfo(this.clazz, cl);
/*  99 */         return info.convertValue(this.alias, this.replace);
/*     */       }
/* 101 */       String aliasString = this.alias;
/* 102 */       if (this.replace)
/*     */       {
/* 104 */         aliasString = StringPropertyReplacer.replaceProperties(aliasString);
/*     */       }
/* 106 */       return aliasString;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 110 */     throw new RuntimeException("Error creating alias for " + this.alias, t);
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 116 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/* 121 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 131 */     buffer.append("alias=").append(this.alias);
/* 132 */     buffer.append(" replace=").append(this.replace);
/* 133 */     if (this.clazz != null)
/* 134 */       buffer.append(" class=").append(this.clazz);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 139 */     buffer.append(this.alias);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 144 */     return this.alias.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 149 */     if ((object == null) || (!(object instanceof AbstractAliasMetaData))) {
/* 150 */       return false;
/*     */     }
/* 152 */     AbstractAliasMetaData amd = (AbstractAliasMetaData)object;
/*     */ 
/* 154 */     return (this.alias.equals(amd.alias)) && (this.replace == amd.replace) && (this.clazz != null) && (this.clazz.equals(amd.clazz));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.metadata.plugins.AbstractAliasMetaData
 * JD-Core Version:    0.6.0
 */