/*     */ package org.jboss.beans.info.plugins;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class BeanInfoUtil
/*     */ {
/*  47 */   private static Configuration configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*     */   {
/*     */     public Configuration run()
/*     */     {
/*  51 */       return new PropertyConfiguration(System.getProperties());
/*     */     }
/*     */   });
/*     */ 
/*     */   protected static Object getNestedTarget(BeanInfo beanInfo, Object target, String[] propertys)
/*     */     throws Throwable
/*     */   {
/*  69 */     if (propertys == null) {
/*  70 */       throw new IllegalArgumentException("Null propertys.");
/*     */     }
/*  72 */     for (int i = 0; i < propertys.length; i++)
/*     */     {
/*  74 */       if (beanInfo == null) {
/*  75 */         throw new IllegalArgumentException("Null bean info");
/*     */       }
/*  77 */       PropertyInfo propertyInfo = beanInfo.getProperty(propertys[i]);
/*  78 */       Object result = propertyInfo.get(target);
/*  79 */       if (i < propertys.length - 1)
/*     */       {
/*  81 */         if (result == null)
/*  82 */           throw new IllegalArgumentException("Null target in nested property (" + Arrays.asList(propertys) + "): " + target + "." + propertys[i]);
/*  83 */         beanInfo = configuration.getBeanInfo(result.getClass());
/*     */       }
/*  85 */       target = result;
/*     */     }
/*  87 */     return target;
/*     */   }
/*     */ 
/*     */   protected static PropertyInfo getNestedPropertyInfo(BeanInfo beanInfo, Object target, String[] propertys)
/*     */     throws Throwable
/*     */   {
/* 102 */     if ((propertys == null) || (propertys.length == 0)) {
/* 103 */       throw new IllegalArgumentException("Illegal propertys: " + Arrays.asList(propertys) + ", " + target);
/*     */     }
/* 105 */     PropertyInfo propertyInfo = null;
/* 106 */     for (int i = 0; i < propertys.length; i++)
/*     */     {
/* 108 */       if (beanInfo == null) {
/* 109 */         throw new IllegalArgumentException("Null bean info");
/*     */       }
/* 111 */       propertyInfo = beanInfo.getProperty(propertys[i]);
/*     */ 
/* 113 */       if (i >= propertys.length - 1)
/*     */         continue;
/* 115 */       Object result = propertyInfo.get(target);
/* 116 */       if (result == null)
/* 117 */         throw new IllegalArgumentException("Null target in nested property (" + Arrays.asList(propertys) + "): " + target + "." + propertys[i]);
/* 118 */       beanInfo = configuration.getBeanInfo(result.getClass());
/* 119 */       target = result;
/*     */     }
/*     */ 
/* 122 */     return propertyInfo;
/*     */   }
/*     */ 
/*     */   public static Object get(BeanInfo beanInfo, Object target, String name)
/*     */     throws Throwable
/*     */   {
/* 136 */     if (target == null)
/* 137 */       throw new IllegalArgumentException("Null target");
/* 138 */     if (name == null) {
/* 139 */       throw new IllegalArgumentException("Null property name");
/*     */     }
/* 141 */     String[] propertys = name.split("\\.");
/* 142 */     return getNestedTarget(beanInfo, target, propertys);
/*     */   }
/*     */ 
/*     */   public static void set(BeanInfo beanInfo, Object target, String name, Object value)
/*     */     throws Throwable
/*     */   {
/* 156 */     if (target == null)
/* 157 */       throw new IllegalArgumentException("Null target");
/* 158 */     if (name == null) {
/* 159 */       throw new IllegalArgumentException("Null property name");
/*     */     }
/* 161 */     String[] propertys = name.split("\\.");
/* 162 */     int size = propertys.length - 1;
/* 163 */     if (size > 0)
/*     */     {
/* 165 */       String[] allButLast = new String[size];
/* 166 */       System.arraycopy(propertys, 0, allButLast, 0, size);
/* 167 */       Object result = getNestedTarget(beanInfo, target, allButLast);
/* 168 */       if (result == null)
/* 169 */         throw new IllegalArgumentException("Cannot set value on null target: " + target + "." + name);
/* 170 */       target = result;
/* 171 */       beanInfo = configuration.getBeanInfo(target.getClass());
/*     */     }
/* 173 */     else if (beanInfo == null) {
/* 174 */       throw new IllegalArgumentException("Null bean info.");
/*     */     }
/* 176 */     PropertyInfo propertyInfo = beanInfo.getProperty(propertys[size]);
/* 177 */     propertyInfo.set(target, value);
/*     */   }
/*     */ 
/*     */   public static PropertyInfo getPropertyInfo(BeanInfo beanInfo, Object target, String name)
/*     */     throws Throwable
/*     */   {
/* 191 */     if (target == null)
/* 192 */       throw new IllegalArgumentException("Null target");
/* 193 */     if (name == null) {
/* 194 */       throw new IllegalArgumentException("Null property name");
/*     */     }
/* 196 */     String[] propertys = name.split("\\.");
/* 197 */     return getNestedPropertyInfo(beanInfo, target, propertys);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  54 */     PropertyEditors.init();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.info.plugins.BeanInfoUtil
 * JD-Core Version:    0.6.0
 */