/*     */ package org.jboss.beans.info.plugins;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.BeanInfoFactory;
/*     */ import org.jboss.beans.info.spi.EventInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.classadapter.spi.ClassAdapter;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.collection.WeakValueHashMap;
/*     */ 
/*     */ public class AbstractBeanInfoFactory
/*     */   implements BeanInfoFactory
/*     */ {
/*  56 */   protected Map<ClassLoader, Map<String, BeanInfo>> cache = new WeakHashMap();
/*     */ 
/*     */   protected static boolean isGetter(MethodInfo minfo)
/*     */   {
/*  60 */     String name = minfo.getName();
/*  61 */     TypeInfo returnType = minfo.getReturnType();
/*  62 */     TypeInfo[] parameters = minfo.getParameterTypes();
/*  63 */     if (((name.length() > 3) && (name.startsWith("get"))) || ((name.length() > 2) && (name.startsWith("is"))))
/*     */     {
/*  66 */       if ((name.startsWith("is")) && (!PrimitiveInfo.BOOLEAN.equals(returnType)))
/*  67 */         return false;
/*  68 */       if ((parameters.length == 0) && (!PrimitiveInfo.VOID.equals(returnType)))
/*  69 */         return true;
/*     */     }
/*  71 */     return false;
/*     */   }
/*     */ 
/*     */   protected static boolean isSetter(MethodInfo minfo)
/*     */   {
/*  76 */     String name = minfo.getName();
/*  77 */     TypeInfo returnType = minfo.getReturnType();
/*  78 */     TypeInfo[] parameters = minfo.getParameterTypes();
/*  79 */     if ((name.length() > 3) && (name.startsWith("set")))
/*     */     {
/*  81 */       if ((parameters.length == 1) && (PrimitiveInfo.VOID.equals(returnType)))
/*  82 */         return true;
/*     */     }
/*  84 */     return false;
/*     */   }
/*     */ 
/*     */   protected static String getUpperPropertyName(String name)
/*     */   {
/*  89 */     int start = 3;
/*  90 */     if (name.startsWith("is")) {
/*  91 */       start = 2;
/*     */     }
/*  93 */     return name.substring(start);
/*     */   }
/*     */ 
/*     */   protected static String getLowerPropertyName(String name)
/*     */   {
/* 100 */     if (name.length() > 1)
/*     */     {
/* 102 */       if (Character.isUpperCase(name.charAt(1))) {
/* 103 */         return name;
/*     */       }
/*     */     }
/* 106 */     JBossStringBuilder buffer = new JBossStringBuilder(name.length());
/* 107 */     buffer.append(Character.toLowerCase(name.charAt(0)));
/* 108 */     if (name.length() > 1)
/* 109 */       buffer.append(name.substring(1));
/* 110 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(ClassAdapter classAdapter)
/*     */   {
/* 122 */     synchronized (this.cache)
/*     */     {
/* 124 */       ClassLoader cl = classAdapter.getClassLoader();
/* 125 */       ClassInfo classInfo = classAdapter.getClassInfo();
/* 126 */       String className = classInfo.getName();
/* 127 */       Map map = (Map)this.cache.get(cl);
/* 128 */       if (map != null)
/*     */       {
/* 130 */         BeanInfo info = (BeanInfo)map.get(className);
/* 131 */         if (info != null) {
/* 132 */           return info;
/*     */         }
/*     */       }
/* 135 */       Set constructors = getConstructors(classInfo);
/* 136 */       Set methods = getMethods(classInfo);
/*     */       Set properties;
/*     */       Set properties;
/* 138 */       if (classInfo.isAnnotation())
/* 139 */         properties = getAnnotationProperties(methods);
/*     */       else
/* 141 */         properties = getBeanProperties(methods);
/* 142 */       Set events = getEvents(classInfo);
/*     */ 
/* 144 */       BeanInfo result = createBeanInfo(classAdapter, properties, constructors, methods, events);
/* 145 */       if (map == null)
/*     */       {
/* 147 */         map = new WeakValueHashMap();
/* 148 */         this.cache.put(cl, map);
/*     */       }
/* 150 */       map.put(className, result);
/* 151 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected BeanInfo createBeanInfo(ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events)
/*     */   {
/* 167 */     return new AbstractBeanInfo(this, classAdapter, properties, constructors, methods, events);
/*     */   }
/*     */ 
/*     */   protected Set<ConstructorInfo> getConstructors(ClassInfo classInfo)
/*     */   {
/* 178 */     ConstructorInfo[] cinfos = classInfo.getDeclaredConstructors();
/* 179 */     if ((cinfos == null) || (cinfos.length == 0)) {
/* 180 */       return null;
/*     */     }
/* 182 */     HashSet result = new HashSet();
/* 183 */     for (int i = 0; i < cinfos.length; i++)
/*     */     {
/* 185 */       if ((cinfos[i].isPublic()) && (!cinfos[i].isStatic()))
/* 186 */         result.add(cinfos[i]);
/*     */     }
/* 188 */     return result;
/*     */   }
/*     */ 
/*     */   protected Set<MethodInfo> getMethods(ClassInfo classInfo)
/*     */   {
/* 199 */     HashSet result = new HashSet();
/*     */ 
/* 201 */     while (classInfo != null)
/*     */     {
/* 203 */       MethodInfo[] minfos = classInfo.getDeclaredMethods();
/* 204 */       if ((minfos != null) && (minfos.length > 0))
/*     */       {
/* 206 */         for (int i = 0; i < minfos.length; i++)
/*     */         {
/* 208 */           if ((!result.contains(minfos[i])) && (minfos[i].isPublic()) && (!minfos[i].isStatic()) && (!minfos[i].isVolatile())) {
/* 209 */             result.add(minfos[i]);
/*     */           }
/*     */         }
/*     */       }
/* 213 */       classInfo = classInfo.getSuperclass();
/*     */     }
/*     */ 
/* 216 */     return result;
/*     */   }
/*     */ 
/*     */   protected Set<PropertyInfo> getBeanProperties(Set<MethodInfo> methods)
/*     */   {
/* 227 */     HashMap getters = new HashMap();
/* 228 */     HashMap setters = new HashMap();
/* 229 */     if (!methods.isEmpty())
/*     */     {
/* 231 */       for (MethodInfo methodInfo : methods)
/*     */       {
/* 233 */         String name = methodInfo.getName();
/* 234 */         String upperName = getUpperPropertyName(name);
/* 235 */         if (isGetter(methodInfo))
/*     */         {
/* 237 */           getters.put(upperName, methodInfo);
/*     */         }
/* 239 */         else if (isSetter(methodInfo))
/*     */         {
/* 241 */           List list = (List)setters.get(upperName);
/* 242 */           if (list == null)
/*     */           {
/* 244 */             list = new ArrayList();
/* 245 */             setters.put(upperName, list);
/*     */           }
/* 247 */           list.add(methodInfo);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 252 */     HashSet properties = new HashSet();
/*     */     Iterator i;
/* 253 */     if (!getters.isEmpty())
/*     */     {
/* 255 */       for (i = getters.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 257 */         Map.Entry entry = (Map.Entry)i.next();
/* 258 */         String name = (String)entry.getKey();
/* 259 */         MethodInfo getter = (MethodInfo)entry.getValue();
/* 260 */         MethodInfo setter = null;
/* 261 */         List setterList = (List)setters.remove(name);
/* 262 */         if ((setterList != null) && (setterList.size() != 0))
/*     */         {
/* 264 */           for (int j = 0; j < setterList.size(); j++)
/*     */           {
/* 266 */             MethodInfo thisSetter = (MethodInfo)setterList.get(j);
/* 267 */             TypeInfo pinfo = thisSetter.getParameterTypes()[0];
/* 268 */             if (getter.getReturnType().equals(pinfo) != true)
/*     */               continue;
/* 270 */             setter = thisSetter;
/* 271 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 275 */         String lowerName = getLowerPropertyName(name);
/*     */ 
/* 278 */         AnnotationValue[] annotations = getter.getAnnotations();
/* 279 */         AnnotationValue[] setterAnnotations = null;
/* 280 */         if (setter != null)
/* 281 */           setterAnnotations = setter.getAnnotations();
/* 282 */         if ((annotations == null) || (annotations.length == 0)) {
/* 283 */           annotations = setterAnnotations;
/* 284 */         } else if ((setterAnnotations != null) && (setterAnnotations.length > 0))
/*     */         {
/* 286 */           HashSet merged = new HashSet();
/* 287 */           for (AnnotationValue annotation : annotations)
/* 288 */             merged.add(annotation);
/* 289 */           for (AnnotationValue annotation : setterAnnotations)
/* 290 */             merged.add(annotation);
/* 291 */           annotations = (AnnotationValue[])merged.toArray(new AnnotationValue[merged.size()]);
/*     */         }
/* 293 */         TypeInfo type = getPropertyType(getter, setter);
/* 294 */         properties.add(new AbstractPropertyInfo(lowerName, name, type, getter, setter, annotations));
/*     */       }
/*     */     }
/*     */     Iterator i;
/* 297 */     if (!setters.isEmpty())
/*     */     {
/* 299 */       for (i = setters.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 301 */         Map.Entry entry = (Map.Entry)i.next();
/* 302 */         name = (String)entry.getKey();
/* 303 */         List setterList = (List)entry.getValue();
/* 304 */         for (MethodInfo setter : setterList)
/*     */         {
/* 306 */           TypeInfo pinfo = setter.getParameterTypes()[0];
/* 307 */           String lowerName = getLowerPropertyName(name);
/* 308 */           AnnotationValue[] annotations = setter.getAnnotations();
/* 309 */           properties.add(new AbstractPropertyInfo(lowerName, name, pinfo, null, setter, annotations));
/*     */         }
/*     */       }
/*     */     }
/*     */     String name;
/* 313 */     return properties;
/*     */   }
/*     */ 
/*     */   protected TypeInfo getPropertyType(MethodInfo getter, MethodInfo setter)
/*     */   {
/* 325 */     if (getter == null)
/* 326 */       throw new IllegalArgumentException("Getter should not be null!");
/* 327 */     if (setter == null) {
/* 328 */       return getter.getReturnType();
/*     */     }
/* 330 */     return getter.getReturnType();
/*     */   }
/*     */ 
/*     */   protected Set<PropertyInfo> getAnnotationProperties(Set<MethodInfo> methods)
/*     */   {
/* 341 */     HashSet properties = new HashSet();
/* 342 */     if ((methods != null) && (!methods.isEmpty()))
/*     */     {
/* 344 */       for (MethodInfo method : methods)
/*     */       {
/* 346 */         TypeInfo returnType = method.getReturnType();
/* 347 */         TypeInfo[] parameters = method.getParameterTypes();
/* 348 */         if ((parameters.length == 0) && (!PrimitiveInfo.VOID.equals(returnType)))
/*     */         {
/* 350 */           String name = method.getName();
/* 351 */           properties.add(new AbstractPropertyInfo(name, name, returnType, method, null, method.getAnnotations()));
/*     */         }
/*     */       }
/*     */     }
/* 355 */     return properties;
/*     */   }
/*     */ 
/*     */   protected Set<EventInfo> getEvents(ClassInfo classInfo)
/*     */   {
/* 366 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.beans.info.plugins.AbstractBeanInfoFactory
 * JD-Core Version:    0.6.0
 */