/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*     */ import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public abstract class StateManager
/*     */   implements Externalizable
/*     */ {
/*     */   public static final String STATE_MANAGER = "STATE_MANAGER";
/*  39 */   protected static Logger log = Logger.getLogger(StateManager.class);
/*     */   protected GUID guid;
/*     */   protected long timeout;
/*  54 */   protected transient ReadWriteLock lock = new WriterPreferenceReadWriteLock();
/*     */ 
/*     */   public static StateManager getStateManager(InstanceAdvised obj)
/*     */   {
/*  44 */     return (StateManager)obj._getInstanceAdvisor().getMetaData().getMetaData("STATE_MANAGER", "STATE_MANAGER");
/*     */   }
/*     */ 
/*     */   public static void setStateManager(InstanceAdvised obj, StateManager manager)
/*     */   {
/*  49 */     obj._getInstanceAdvisor().getMetaData().addMetaData("STATE_MANAGER", "STATE_MANAGER", manager, PayloadKey.TRANSIENT);
/*     */   }
/*     */ 
/*     */   public StateManager()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StateManager(GUID guid, long timeout)
/*     */   {
/*  60 */     this.guid = guid;
/*  61 */     this.timeout = timeout;
/*     */   }
/*     */   public ReadWriteLock getLock() {
/*  64 */     return this.lock; } 
/*  65 */   public GUID getGUID() { return this.guid; }
/*     */ 
/*     */   public void acquireWriteLock()
/*     */   {
/*     */     try
/*     */     {
/*  71 */       if (!this.lock.writeLock().attempt(this.timeout))
/*     */       {
/*  73 */         throw new LockAttemptFailure("failed to acquire write lock: " + this.guid);
/*     */       }
/*  75 */       log.trace("writelock acquired for: " + this.guid);
/*     */     }
/*     */     catch (InterruptedException ignored)
/*     */     {
/*  79 */       throw new LockAttemptFailure("failed to acquire write lock: " + this.guid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void acquireReadLock()
/*     */   {
/*     */     try
/*     */     {
/*  87 */       if (!this.lock.readLock().attempt(this.timeout))
/*     */       {
/*  89 */         throw new LockAttemptFailure("failed to acquire read lock: " + this.guid);
/*     */       }
/*  91 */       log.trace("readlock acquired for: " + this.guid);
/*     */     }
/*     */     catch (InterruptedException ignored)
/*     */     {
/*  95 */       throw new LockAttemptFailure("failed to acquire read lock: " + this.guid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void releaseReadLock()
/*     */   {
/* 101 */     this.lock.readLock().release();
/* 102 */     log.trace("readlock released for: " + this.guid);
/*     */   }
/*     */ 
/*     */   public void releaseWriteLock() {
/* 106 */     this.lock.writeLock().release();
/* 107 */     log.trace("writelock released for: " + this.guid);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 113 */     out.writeObject(this.guid);
/* 114 */     out.writeLong(this.timeout);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 120 */     this.guid = ((GUID)in.readObject());
/* 121 */     this.timeout = in.readLong();
/* 122 */     this.lock = new WriterPreferenceReadWriteLock();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.StateManager
 * JD-Core Version:    0.6.0
 */