/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.Query;
/*     */ import javax.management.QueryExp;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition.HAPartitionStateTransfer;
/*     */ import org.jboss.ha.framework.server.ClusterPartitionMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedTxCache
/*     */   implements HAPartition.HAPartitionStateTransfer
/*     */ {
/*  49 */   protected static final Class[] INSERT_TYPES = { Object.class, Object.class };
/*  50 */   protected static final Class[] REMOVE_TYPES = { Object.class };
/*     */ 
/*  68 */   protected static Logger log = Logger.getLogger(DistributedTxCache.class);
/*     */   protected long lockTimeout;
/*     */   protected DistributedSynchronizationManager synchManager;
/*     */   protected DistributedVersionManager versionManager;
/*     */   protected String partitionName;
/*     */   protected HAPartition partition;
/*     */   protected String cacheName;
/*  75 */   protected LRUCache cache = null;
/*     */   protected int maxSize;
/*     */ 
/*     */   public DistributedTxCache(int maxSize, long lockTimeout, String cacheName)
/*     */   {
/*  80 */     this(maxSize, lockTimeout, cacheName, "DefaultPartition");
/*     */   }
/*     */ 
/*     */   public DistributedTxCache(int maxSize, long lockTimeout, String cacheName, String pName)
/*     */   {
/*  85 */     this.lockTimeout = lockTimeout;
/*  86 */     this.partitionName = pName;
/*  87 */     this.maxSize = maxSize;
/*  88 */     this.cacheName = ("DistributedTxCache/" + cacheName);
/*     */   }
/*     */ 
/*     */   protected HAPartition findHAPartitionWithName(String name)
/*     */     throws Exception
/*     */   {
/*  95 */     HAPartition result = null;
/*  96 */     MBeanServer server = MBeanServerLocator.locate();
/*     */ 
/* 100 */     QueryExp exp = Query.and(Query.match(Query.attr("Name"), Query.value("ClusterPartition")), Query.match(Query.attr("PartitionName"), Query.value(name)));
/*     */ 
/* 111 */     Set mbeans = server.queryMBeans(null, exp);
/*     */     Iterator iter;
/* 112 */     if ((mbeans != null) && (mbeans.size() > 0))
/*     */     {
/* 114 */       for (iter = mbeans.iterator(); iter.hasNext(); )
/*     */       {
/* 116 */         ObjectInstance inst = (ObjectInstance)iter.next();
/*     */         try
/*     */         {
/* 119 */           ClusterPartitionMBean cp = (ClusterPartitionMBean)MBeanProxyExt.create(ClusterPartitionMBean.class, inst.getObjectName(), server);
/*     */ 
/* 123 */           result = cp.getHAPartition();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/* 130 */     return result;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 135 */     this.partition = findHAPartitionWithName(this.partitionName);
/*     */ 
/* 141 */     this.partition.registerRPCHandler(this.cacheName, this);
/* 142 */     this.synchManager = new DistributedSynchronizationManager(this.cacheName, null, this.partition);
/* 143 */     this.versionManager = new DistributedVersionManager(this.lockTimeout, this.synchManager);
/* 144 */     this.synchManager.versionManager = this.versionManager;
/* 145 */     this.synchManager.create();
/*     */   }
/*     */ 
/*     */   public synchronized void start() throws Exception
/*     */   {
/* 150 */     this.synchManager.start();
/* 151 */     pullState();
/* 152 */     if (this.cache == null) this.cache = new LRUCache(this.maxSize); 
/*     */   }
/*     */ 
/*     */   protected void pullState()
/*     */     throws Exception
/*     */   {
/* 157 */     Object[] args = new Object[0];
/* 158 */     List rsp = this.partition.callMethodOnCluster(this.cacheName, "getCurrentState", args, null, true);
/* 159 */     if (rsp.size() > 0)
/*     */     {
/* 161 */       setCurrentState((Serializable)rsp.get(0));
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void _insert(Object key, Object obj)
/*     */   {
/* 168 */     this.cache.put(key, obj);
/*     */   }
/*     */ 
/*     */   public void insert(Object key, Object obj) throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 175 */       obj = this.versionManager.makeVersioned(obj);
/* 176 */       if (this.versionManager.isVersioned(obj))
/*     */       {
/* 178 */         log.trace("Inserting versioned object");
/* 179 */         obj = VersionManager.getGUID((InstanceAdvised)obj);
/*     */       }
/*     */       else
/*     */       {
/* 183 */         log.trace("Inserting a non-Versioned object");
/*     */       }
/* 185 */       Object[] args = { key, obj };
/* 186 */       this.partition.callMethodOnCluster(this.cacheName, "_insert", args, INSERT_TYPES, false);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 190 */       ex.printStackTrace();
/* 191 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void _remove(Object key)
/*     */   {
/* 197 */     this.cache.remove(key);
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 202 */     Object[] args = { key };
/*     */     try
/*     */     {
/* 205 */       this.partition.callMethodOnCluster(this.cacheName, "_remove", args, REMOVE_TYPES, false);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 209 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void _flush()
/*     */   {
/* 216 */     this.cache.clear();
/*     */   }
/*     */ 
/*     */   public void flush(Object key)
/*     */   {
/* 221 */     Object[] args = new Object[0];
/*     */     try
/*     */     {
/* 224 */       this.partition.callMethodOnCluster(this.cacheName, "_flush", args, null, false);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 228 */       throw new RuntimeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized Object get(Object key)
/*     */   {
/* 235 */     Object obj = this.cache.get(key);
/* 236 */     if ((obj instanceof GUID))
/*     */     {
/* 238 */       GUID guid = (GUID)obj;
/* 239 */       obj = this.synchManager.getObject(guid);
/*     */     }
/* 241 */     return obj;
/*     */   }
/*     */ 
/*     */   public Serializable getCurrentState()
/*     */   {
/* 246 */     log.trace("getCurrentState called on cache");
/* 247 */     return this.cache;
/*     */   }
/*     */ 
/*     */   public void setCurrentState(Serializable newState)
/*     */   {
/* 252 */     log.trace("setCurrentState called on cache");
/* 253 */     synchronized (this)
/*     */     {
/* 255 */       this.cache = ((LRUCache)newState);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class LRUCache extends LinkedHashMap
/*     */   {
/*     */     private static final long serialVersionUID = -402696519285213913L;
/*     */     private int maxSize;
/*     */ 
/*     */     public LRUCache(int max)
/*     */     {
/*  59 */       super(0.75F, true);
/*  60 */       this.maxSize = max;
/*     */     }
/*     */ 
/*     */     protected boolean removeEldestEntry(Map.Entry eldest) {
/*  64 */       return size() > this.maxSize;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedTxCache
 * JD-Core Version:    0.6.0
 */