/*     */ package org.jboss.aspects.versioned;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class DistributedPOJOState extends StateManager
/*     */   implements DistributedState, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 7640633352012924284L;
/*  54 */   private static Logger log = Logger.getLogger(DistributedPOJOState.class);
/*     */   protected String classname;
/*     */   protected HashMap fieldMap;
/*     */   protected transient TransactionManager tm;
/*     */   protected transient WeakReference advisedRef;
/*  60 */   protected transient TransactionLocal txState = new TransactionLocal();
/*     */   protected transient SynchronizationManager synchManager;
/*     */   protected transient DistributedVersionManager versionManager;
/*     */ 
/*     */   public DistributedPOJOState()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DistributedPOJOState(GUID daguid, long datimeout, Advised advised, DistributedVersionManager versionManager, SynchronizationManager synchManager)
/*     */     throws Exception
/*     */   {
/*  69 */     super(daguid, datimeout);
/*  70 */     this.fieldMap = new HashMap();
/*  71 */     this.classname = advised.getClass().getName();
/*  72 */     InitialContext ctx = new InitialContext();
/*  73 */     this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*  74 */     this.synchManager = synchManager;
/*  75 */     this.versionManager = versionManager;
/*  76 */     this.advisedRef = new WeakReference(advised);
/*     */   }
/*     */ 
/*     */   public InstanceAdvised getObject()
/*     */   {
/*  81 */     if (this.advisedRef != null)
/*     */     {
/*  83 */       return (InstanceAdvised)this.advisedRef.get();
/*     */     }
/*  85 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  90 */     if (!(obj instanceof DistributedPOJOState)) return false;
/*  91 */     DistributedPOJOState pojo = (DistributedPOJOState)obj;
/*  92 */     return this.guid.equals(pojo.guid);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  97 */     return this.guid.hashCode();
/*     */   }
/*     */ 
/*     */   public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager)
/*     */     throws Exception
/*     */   {
/* 104 */     log.trace("building a " + this.classname + " of guid " + this.guid);
/* 105 */     this.versionManager = versionManager;
/* 106 */     this.synchManager = manager;
/* 107 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
/* 108 */     Advised advised = (Advised)clazz.newInstance();
/* 109 */     this.advisedRef = new WeakReference(advised);
/* 110 */     versionManager.addVersioning(this, advised);
/* 111 */     manager.putState(this.guid, this);
/* 112 */     manager.putObject(this.guid, advised);
/*     */ 
/* 114 */     Iterator it = this.fieldMap.values().iterator();
/* 115 */     while (it.hasNext())
/*     */     {
/* 117 */       DistributedFieldUpdate update = (DistributedFieldUpdate)it.next();
/* 118 */       ClassAdvisor advisor = (ClassAdvisor)advised._getAdvisor();
/* 119 */       log.trace("build field " + advisor.getAdvisedFields()[update.getFieldIndex()].getName());
/* 120 */       Object val = update.getNonDereferencedValue();
/* 121 */       if ((val != null) && ((val instanceof VersionReference)))
/*     */       {
/* 123 */         VersionReference ref = (VersionReference)val;
/* 124 */         log.trace("VersionReference.guid: " + ref.getGUID() + " for field " + advisor.getAdvisedFields()[update.getFieldIndex()].getName());
/* 125 */         val = manager.getObject(ref.getGUID());
/* 126 */         if (val == null)
/*     */         {
/* 128 */           DistributedState fieldVal = manager.getState(ref.getGUID());
/* 129 */           val = fieldVal.buildObject(manager, versionManager);
/*     */         }
/* 131 */         ref.set((InstanceAdvised)val);
/*     */       }
/*     */     }
/* 134 */     return advised;
/*     */   }
/*     */ 
/*     */   public HashMap getTxState()
/*     */   {
/* 139 */     return (HashMap)this.txState.get();
/*     */   }
/*     */ 
/*     */   public HashMap getTxState(Transaction tx)
/*     */   {
/* 144 */     return (HashMap)this.txState.get(tx);
/*     */   }
/*     */ 
/*     */   public Object fieldRead(Invocation invocation) throws Throwable
/*     */   {
/* 149 */     acquireReadLock();
/*     */     try
/*     */     {
/* 152 */       FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
/* 153 */       Integer index = new Integer(fieldInvocation.getIndex());
/* 154 */       HashMap map = getTxState();
/* 155 */       if (map == null)
/*     */       {
/* 157 */         map = this.fieldMap;
/*     */       }
/* 159 */       DistributedFieldUpdate update = (DistributedFieldUpdate)map.get(index);
/* 160 */       Object val = update.getValue();
/* 161 */       Object localObject1 = val;
/*     */       return localObject1; } finally { releaseReadLock(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Object fieldWrite(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 171 */     FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
/* 172 */     Integer index = new Integer(fieldInvocation.getIndex());
/* 173 */     Object val = fieldInvocation.getValue();
/*     */ 
/* 175 */     if ((val instanceof Advised))
/*     */     {
/* 177 */       Advised advisedValue = (Advised)val;
/* 178 */       val = this.versionManager.makeVersioned(advisedValue);
/*     */     }
/*     */ 
/* 181 */     Transaction tx = this.tm.getTransaction();
/* 182 */     if (tx == null)
/*     */     {
/* 184 */       acquireWriteLock();
/*     */       try
/*     */       {
/* 188 */         DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
/* 189 */         long versionId = update.getVersionId() + 1L;
/* 190 */         update.setVersionId(versionId);
/* 191 */         update.setValue(val);
/* 192 */         HashMap fieldUpdates = new HashMap();
/* 193 */         fieldUpdates.put(index, update);
/* 194 */         this.synchManager.noTxUpdate(new DistributedPOJOUpdate(this.guid, fieldUpdates));
/* 195 */         Object localObject1 = null;
/*     */         return localObject1; } finally { releaseWriteLock();
/*     */       }
/*     */     }
/*     */ 
/* 203 */     acquireReadLock();
/*     */     try
/*     */     {
/* 206 */       HashMap map = (HashMap)this.txState.get();
/* 207 */       if (map == null)
/*     */       {
/* 209 */         map = new HashMap();
/* 210 */         DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
/* 211 */         DistributedFieldUpdate newUpdate = new DistributedFieldUpdate(val, update.getVersionId() + 1L, index.intValue());
/* 212 */         this.synchManager.registerUpdate(tx, this);
/* 213 */         map.put(index, newUpdate);
/* 214 */         this.txState.set(tx, map);
/*     */       }
/*     */       else
/*     */       {
/* 218 */         DistributedFieldUpdate newUpdate = (DistributedFieldUpdate)map.get(index);
/* 219 */         if (newUpdate == null)
/*     */         {
/* 221 */           DistributedFieldUpdate update = (DistributedFieldUpdate)this.fieldMap.get(index);
/* 222 */           newUpdate = new DistributedFieldUpdate(val, update.getVersionId() + 1L, index.intValue());
/* 223 */           map.put(index, newUpdate);
/*     */         }
/*     */         else
/*     */         {
/* 227 */           newUpdate.setValue(val);
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 233 */       releaseReadLock();
/*     */     }
/*     */ 
/* 236 */     return null;
/*     */   }
/*     */ 
/*     */   public DistributedUpdate createTxUpdate(Transaction tx)
/*     */   {
/* 241 */     HashMap state = getTxState(tx);
/* 242 */     return new DistributedPOJOUpdate(this.guid, state);
/*     */   }
/*     */ 
/*     */   public void checkOptimisticLock(Transaction tx)
/*     */   {
/* 248 */     HashMap state = getTxState(tx);
/* 249 */     Iterator it = state.entrySet().iterator();
/* 250 */     while (it.hasNext())
/*     */     {
/* 252 */       Map.Entry entry = (Map.Entry)it.next();
/* 253 */       Integer index = (Integer)entry.getKey();
/* 254 */       DistributedFieldUpdate update = (DistributedFieldUpdate)entry.getValue();
/* 255 */       DistributedFieldUpdate orig = (DistributedFieldUpdate)this.fieldMap.get(index);
/* 256 */       if (update.getVersionId() <= orig.getVersionId())
/*     */       {
/* 258 */         Advised advised = null;
/* 259 */         if (this.advisedRef != null)
/*     */         {
/* 261 */           advised = (Advised)this.advisedRef.get();
/*     */         }
/* 263 */         if (advised != null)
/*     */         {
/* 265 */           ClassAdvisor advisor = (ClassAdvisor)advised._getAdvisor();
/* 266 */           Field field = advisor.getAdvisedFields()[index.intValue()];
/* 267 */           throw new OptimisticLockFailure("optimistic lock failure for field " + field.getName() + " of class " + field.getDeclaringClass().getName());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void mergeState(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 276 */     HashMap newState = getTxState(tx);
/* 277 */     mergeState(newState);
/*     */   }
/*     */ 
/*     */   public void mergeState(DistributedUpdate update) throws Exception
/*     */   {
/* 282 */     HashMap newState = ((DistributedPOJOUpdate)update).fieldUpdates;
/* 283 */     mergeState(newState);
/*     */   }
/*     */ 
/*     */   public void mergeState(HashMap newState)
/*     */     throws Exception
/*     */   {
/* 289 */     Iterator it = newState.entrySet().iterator();
/* 290 */     while (it.hasNext())
/*     */     {
/* 292 */       Map.Entry entry = (Map.Entry)it.next();
/* 293 */       DistributedFieldUpdate update = (DistributedFieldUpdate)entry.getValue();
/* 294 */       if ((update.getNonDereferencedValue() instanceof VersionReference))
/*     */       {
/* 296 */         VersionReference ref = (VersionReference)update.getNonDereferencedValue();
/* 297 */         if (ref.get() == null) ref.set((InstanceAdvised)this.synchManager.getObject(ref.getGUID()));
/*     */       }
/*     */     }
/* 300 */     this.fieldMap.putAll(newState);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 306 */     super.writeExternal(out);
/* 307 */     out.writeObject(this.classname);
/* 308 */     out.writeObject(this.fieldMap);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 314 */     super.readExternal(in);
/* 315 */     this.classname = ((String)in.readObject());
/* 316 */     this.fieldMap = ((HashMap)in.readObject());
/*     */     try
/*     */     {
/* 319 */       InitialContext ctx = new InitialContext();
/* 320 */       this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 324 */       throw new RuntimeException(ex);
/*     */     }
/* 326 */     this.txState = new TransactionLocal();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.DistributedPOJOState
 * JD-Core Version:    0.6.0
 */