/*    */ package org.jboss.aspects.versioned;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.HashMap;
/*    */ import org.jboss.aop.util.MethodHashing;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public abstract class CollectionStateManager extends StateManager
/*    */   implements Externalizable
/*    */ {
/*    */   protected HashMap methodMap;
/*    */ 
/*    */   protected CollectionStateManager()
/*    */   {
/*    */   }
/*    */ 
/*    */   protected CollectionStateManager(GUID guid, long timeout, HashMap methodMap)
/*    */   {
/* 44 */     super(guid, timeout);
/* 45 */     this.methodMap = methodMap;
/*    */   }
/*    */ 
/*    */   public abstract HashMap getMethodMap();
/*    */ 
/*    */   public Method isManagerMethod(Method method)
/*    */   {
/*    */     try {
/* 54 */       long hash = MethodHashing.methodHash(method);
/* 55 */       return (Method)this.methodMap.get(new Long(hash));
/*    */     }
/*    */     catch (Exception ex) {
/*    */     }
/* 59 */     throw new RuntimeException(ex);
/*    */   }
/*    */ 
/*    */   public Method isManagerMethod(long hash)
/*    */   {
/* 64 */     return (Method)this.methodMap.get(new Long(hash));
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out)
/*    */     throws IOException
/*    */   {
/* 70 */     super.writeExternal(out);
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 76 */     super.readExternal(in);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.versioned.CollectionStateManager
 * JD-Core Version:    0.6.0
 */