/*     */ package org.jboss.aspects.txlock;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.deadlock.DeadlockDetector;
/*     */ import org.jboss.util.deadlock.Resource;
/*     */ 
/*     */ public class QueuedTxLock
/*     */   implements Resource
/*     */ {
/*     */   public static final String TXLOCK = "TxLock";
/*     */   public static final String TIMEOUT = "timeout";
/*     */   private HashMap txLocks;
/*     */   private LinkedList txWaitQueue;
/*     */   private Transaction tx;
/*     */   private boolean synched;
/*     */   private boolean isSynchronized;
/*     */   private Logger log;
/*     */ 
/*     */   public QueuedTxLock()
/*     */   {
/*  58 */     this.txLocks = new HashMap();
/*  59 */     this.txWaitQueue = new LinkedList();
/*     */ 
/*  62 */     this.tx = null;
/*  63 */     this.synched = false;
/*  64 */     this.isSynchronized = false;
/*  65 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public Object getResourceHolder() {
/*  69 */     return this.tx;
/*     */   }
/*     */ 
/*     */   public void sync() throws InterruptedException
/*     */   {
/*  74 */     synchronized (this)
/*     */     {
/*  76 */       while (this.synched)
/*     */       {
/*  78 */         wait();
/*     */       }
/*  80 */       this.synched = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void releaseSync()
/*     */   {
/*  86 */     synchronized (this)
/*     */     {
/*  88 */       this.synched = false;
/*  89 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTransaction(Transaction tx)
/*     */   {
/*  99 */     this.tx = tx;
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */   {
/* 104 */     return this.tx;
/*     */   }
/*     */ 
/*     */   protected TxLock getTxLock(Transaction miTx)
/*     */   {
/* 148 */     TxLock lock = null;
/* 149 */     TxLock key = new TxLock(miTx);
/* 150 */     lock = (TxLock)this.txLocks.get(key);
/* 151 */     if (lock == null)
/*     */     {
/* 153 */       this.txLocks.put(key, key);
/* 154 */       this.txWaitQueue.addLast(key);
/* 155 */       lock = key;
/*     */     }
/* 157 */     return lock;
/*     */   }
/*     */ 
/*     */   protected boolean isTxExpired(Transaction miTx)
/*     */     throws Exception
/*     */   {
/* 164 */     return (miTx != null) && (miTx.getStatus() == 1);
/*     */   }
/*     */ 
/*     */   public boolean lockNoWait(Transaction transaction)
/*     */     throws Exception
/*     */   {
/* 172 */     sync();
/* 173 */     if (this.log.isTraceEnabled()) {
/* 174 */       this.log.trace("lockNoWait tx=" + transaction + " " + toString());
/*     */     }
/*     */     try
/*     */     {
/* 178 */       if ((getTransaction() != null) && (!getTransaction().equals(transaction)))
/*     */       {
/* 180 */         i = 0;
/*     */         return i;
/*     */       }
/* 182 */       setTransaction(transaction);
/* 183 */       int i = 1;
/*     */       return i; } finally { releaseSync(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void schedule(Transaction miTx, Invocation mi)
/*     */     throws Exception
/*     */   {
/* 204 */     boolean trace = this.log.isTraceEnabled();
/* 205 */     sync();
/*     */     try
/*     */     {
/* 208 */       if (trace) this.log.trace("Begin schedule");
/*     */ 
/* 210 */       if (isTxExpired(miTx))
/*     */       {
/* 212 */         this.log.error("Saw rolled back tx=" + miTx);
/* 213 */         throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
/*     */       }
/*     */ 
/* 218 */       waitForTx(mi, miTx, trace);
/* 219 */       if (!this.isSynchronized)
/*     */       {
/* 221 */         this.isSynchronized = true;
/* 222 */         miTx.registerSynchronization(new TxLockSynchronization(null));
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 227 */       releaseSync();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void waitForTx(Invocation mi, Transaction miTx, boolean trace)
/*     */     throws Exception
/*     */   {
/* 239 */     boolean wasScheduled = false;
/*     */ 
/* 244 */     TxLock txLock = null;
/* 245 */     while ((getTransaction() != null) && (!getTransaction().equals(miTx)))
/*     */     {
/*     */       try
/*     */       {
/* 252 */         DeadlockDetector.singleton.deadlockDetection(miTx, this);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 257 */         if ((txLock != null) && (txLock.isQueued))
/*     */         {
/* 259 */           this.txLocks.remove(txLock);
/* 260 */           this.txWaitQueue.remove(txLock);
/*     */         }
/* 262 */         throw e;
/*     */       }
/*     */ 
/* 265 */       wasScheduled = true;
/*     */ 
/* 268 */       if (trace) this.log.trace("Transactional contention on context miTx=" + miTx + " " + toString());
/*     */ 
/* 270 */       if (txLock == null) {
/* 271 */         txLock = getTxLock(miTx);
/*     */       }
/* 273 */       if (trace) this.log.trace("Begin wait on " + txLock + " " + toString());
/*     */ 
/* 276 */       synchronized (txLock)
/*     */       {
/* 278 */         releaseSync();
/*     */         try
/*     */         {
/* 281 */           int txTimeout = 0;
/* 282 */           Integer timeout = (Integer)mi.getMetaData("TxLock", "timeout");
/* 283 */           if (timeout != null) txTimeout = timeout.intValue();
/* 284 */           txLock.wait(txTimeout);
/*     */         }
/*     */         catch (InterruptedException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 291 */       sync();
/*     */ 
/* 293 */       if (trace) this.log.trace("End wait on " + txLock + " " + toString());
/* 294 */       if (!isTxExpired(miTx))
/*     */         continue;
/* 296 */       this.log.error(Thread.currentThread() + "Saw rolled back tx=" + miTx + " waiting for txLock");
/* 297 */       if (txLock.isQueued)
/*     */       {
/* 302 */         this.txLocks.remove(txLock);
/* 303 */         this.txWaitQueue.remove(txLock);
/*     */       }
/* 305 */       else if ((getTransaction() != null) && (getTransaction().equals(miTx)))
/*     */       {
/* 308 */         nextTransaction(trace);
/*     */       }
/* 310 */       if (miTx != null)
/*     */       {
/* 312 */         DeadlockDetector.singleton.removeWaiting(miTx);
/*     */       }
/* 314 */       throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
/*     */     }
/*     */ 
/* 319 */     if (!wasScheduled) setTransaction(miTx);
/*     */   }
/*     */ 
/*     */   protected void nextTransaction(boolean trace)
/*     */   {
/* 333 */     if (!this.synched)
/*     */     {
/* 335 */       throw new IllegalStateException("do not call nextTransaction while not synched!");
/*     */     }
/*     */ 
/* 338 */     setTransaction(null);
/*     */ 
/* 340 */     TxLock thelock = null;
/* 341 */     if (!this.txWaitQueue.isEmpty())
/*     */     {
/* 343 */       thelock = (TxLock)this.txWaitQueue.removeFirst();
/* 344 */       this.txLocks.remove(thelock);
/* 345 */       thelock.isQueued = false;
/*     */ 
/* 348 */       if (thelock.waitingTx != null)
/* 349 */         DeadlockDetector.singleton.removeWaiting(thelock.waitingTx);
/* 350 */       setTransaction(thelock.waitingTx);
/* 351 */       synchronized (thelock)
/*     */       {
/* 355 */         thelock.notifyAll();
/*     */       }
/*     */     }
/* 358 */     if (trace)
/* 359 */       this.log.trace("nextTransaction: " + thelock + " " + toString());
/*     */   }
/*     */ 
/*     */   public void endTransaction()
/*     */   {
/* 364 */     boolean trace = this.log.isTraceEnabled();
/* 365 */     if (trace)
/* 366 */       this.log.trace("endTransaction: " + toString());
/* 367 */     nextTransaction(trace);
/*     */   }
/*     */ 
/*     */   public void endInvocation(Transaction thetx)
/*     */   {
/* 372 */     if (this.log.isTraceEnabled())
/* 373 */       this.log.trace("endInvocation: miTx=" + thetx + " " + toString());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 378 */     StringBuffer buffer = new StringBuffer(100);
/* 379 */     buffer.append(" hash=").append(hashCode());
/* 380 */     buffer.append(" tx=").append(getTransaction());
/* 381 */     buffer.append(" synched=").append(this.synched);
/* 382 */     buffer.append(" queue=").append(this.txWaitQueue);
/* 383 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private final class TxLockSynchronization implements Synchronization
/*     */   {
/*     */     private TxLockSynchronization() {
/*     */     }
/*     */ 
/*     */     public void beforeCompletion() {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status) {
/*     */       try {
/* 396 */         QueuedTxLock.this.sync();
/*     */       }
/*     */       catch (InterruptedException ignored)
/*     */       {
/*     */       }
/* 401 */       QueuedTxLock.access$102(QueuedTxLock.this, false);
/* 402 */       QueuedTxLock.this.endTransaction();
/* 403 */       QueuedTxLock.this.releaseSync();
/*     */     }
/*     */   }
/*     */ 
/*     */   private class TxLock
/*     */   {
/*     */     public Transaction waitingTx;
/*     */     public String threadName;
/*     */     public boolean isQueued;
/*     */ 
/*     */     public TxLock(Transaction trans)
/*     */     {
/* 117 */       this.threadName = Thread.currentThread().toString();
/* 118 */       this.waitingTx = trans;
/* 119 */       this.isQueued = true;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 124 */       if (obj == this) return true;
/*     */ 
/* 126 */       TxLock lock = (TxLock)obj;
/*     */ 
/* 128 */       return lock.waitingTx.equals(this.waitingTx);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 133 */       return this.waitingTx.hashCode();
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 138 */       StringBuffer buffer = new StringBuffer(100);
/* 139 */       buffer.append("TXLOCK waitingTx=").append(this.waitingTx);
/* 140 */       buffer.append(" thread=").append(this.threadName);
/* 141 */       buffer.append(" queued=").append(this.isQueued);
/* 142 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.txlock.QueuedTxLock
 * JD-Core Version:    0.6.0
 */