/*    */ package org.jboss.aspects.tx;
/*    */ 
/*    */ import java.io.ObjectStreamException;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.tm.TransactionPropagationContextFactory;
/*    */ import org.jboss.tm.TransactionPropagationContextUtil;
/*    */ 
/*    */ public class ClientTxPropagationInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 4536126296306191076L;
/* 41 */   public static String TRANSACTION_PROPAGATION_CONTEXT = "TransactionPropagationContext";
/*    */ 
/* 43 */   public static final ClientTxPropagationInterceptor singleton = new ClientTxPropagationInterceptor();
/*    */ 
/*    */   public String getName()
/*    */   {
/* 47 */     return "ClientTxPropagationInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 52 */     TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
/* 53 */     if (tpcFactory != null)
/*    */     {
/* 55 */       Object tpc = tpcFactory.getTransactionPropagationContext();
/* 56 */       if (tpc != null)
/*    */       {
/* 58 */         invocation.getMetaData().addMetaData(TRANSACTION_PROPAGATION_CONTEXT, TRANSACTION_PROPAGATION_CONTEXT, tpc);
/*    */       }
/*    */     }
/* 61 */     return invocation.invokeNext();
/*    */   }
/*    */ 
/*    */   Object readResolve() throws ObjectStreamException {
/* 65 */     return singleton;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.tx.ClientTxPropagationInterceptor
 * JD-Core Version:    0.6.0
 */