/*     */ package org.jboss.aspects.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.NobodyPrincipal;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class RoleBasedAuthorizationInterceptor
/*     */   implements Interceptor
/*     */ {
/*  50 */   protected Logger log = Logger.getLogger(getClass());
/*     */   protected AuthenticationManager securityManager;
/*     */   protected RealmMapping realmMapping;
/*     */ 
/*     */   public RoleBasedAuthorizationInterceptor(AuthenticationManager manager, RealmMapping realmMapping)
/*     */   {
/*  56 */     this.securityManager = manager;
/*  57 */     this.realmMapping = realmMapping;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  62 */     return "RoleBasedAuthorizationInterceptor";
/*     */   }
/*     */ 
/*     */   protected Set getRoleSet(Invocation invocation)
/*     */   {
/*  67 */     Set roles = (Set)invocation.getMetaData("security", "roles");
/*  68 */     if (roles == null) roles = getAnnotationRoleSet(invocation);
/*  69 */     return roles;
/*     */   }
/*     */ 
/*     */   protected Set getAnnotationRoleSet(Invocation invocation)
/*     */   {
/*  75 */     HashSet set = new HashSet();
/*  76 */     Exclude exclude = (Exclude)invocation.resolveAnnotation(Exclude.class);
/*  77 */     if (exclude != null)
/*     */     {
/*  79 */       set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/*  80 */       return set;
/*     */     }
/*  82 */     Unchecked unchecked = (Unchecked)invocation.resolveAnnotation(Unchecked.class);
/*  83 */     if (unchecked != null)
/*     */     {
/*  85 */       set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*  86 */       return set;
/*     */     }
/*  88 */     Permissions permissions = (Permissions)invocation.resolveAnnotation(Permissions.class);
/*  89 */     if (permissions == null)
/*     */     {
/*  92 */       set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*  93 */       return set;
/*     */     }
/*  95 */     for (int i = 0; i < permissions.value().length; i++)
/*     */     {
/*  97 */       set.add(new SimplePrincipal(permissions.value()[i]));
/*     */     }
/*  99 */     return set;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 110 */     if (this.securityManager == null)
/*     */     {
/* 112 */       return invocation.invokeNext();
/*     */     }
/*     */ 
/* 115 */     if (this.realmMapping == null)
/*     */     {
/* 117 */       throw new SecurityException("Role mapping manager has not been set");
/*     */     }
/*     */ 
/* 120 */     Set roles = getRoleSet(invocation);
/* 121 */     if (roles == null)
/*     */     {
/* 129 */       String message = "No method permissions assigned.";
/* 130 */       this.log.error(message);
/* 131 */       throw new SecurityException(message);
/*     */     }
/*     */ 
/* 135 */     RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
/* 136 */     if (!roles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL))
/*     */     {
/* 139 */       if (callerRunAsIdentity == null)
/*     */       {
/* 141 */         Principal principal = SecurityActions.getPrincipal();
/*     */ 
/* 143 */         if (!this.realmMapping.doesUserHaveRole(principal, roles))
/*     */         {
/* 145 */           Set userRoles = this.realmMapping.getUserRoles(principal);
/* 146 */           String msg = "Insufficient permissions, principal=" + principal + ", requiredRoles=" + roles + ", principalRoles=" + userRoles;
/*     */ 
/* 148 */           this.log.error(msg);
/* 149 */           throw new SecurityException(msg);
/*     */         }
/*     */ 
/*     */       }
/* 157 */       else if (!callerRunAsIdentity.doesUserHaveRole(roles))
/*     */       {
/* 159 */         String msg = "Insufficient permissions, runAsPrincipal=" + callerRunAsIdentity.getName() + ", requiredRoles=" + roles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
/*     */ 
/* 161 */         this.log.error(msg);
/* 162 */         throw new SecurityException(msg);
/*     */       }
/*     */     }
/*     */ 
/* 166 */     return invocation.invokeNext();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.RoleBasedAuthorizationInterceptor
 * JD-Core Version:    0.6.0
 */