/*     */ package org.jboss.aspects.remoting;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.DispatcherConnectException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
/*     */ import org.jboss.ha.framework.interfaces.GenericClusteringException;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ClusterChooserInterceptor
/*     */   implements Interceptor, ClusterConstants, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -8666382019058421135L;
/*  43 */   public static final ClusterChooserInterceptor singleton = new ClusterChooserInterceptor();
/*     */ 
/*     */   public String getName()
/*     */   {
/*  47 */     return "ClusterChooserInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  53 */     LoadBalancePolicy lb = (LoadBalancePolicy)invocation.getMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY");
/*  54 */     FamilyWrapper family = (FamilyWrapper)invocation.getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER");
/*     */ 
/*  59 */     int failoverCounter = 0;
/*  60 */     String familyName = family.get().getFamilyName();
/*  61 */     invocation.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY", familyName, PayloadKey.AS_IS);
/*  62 */     InvokerLocator target = (InvokerLocator)lb.chooseTarget(family.get());
/*  63 */     Throwable lastException = null;
/*  64 */     while (target != null)
/*     */     {
/*  66 */       invocation.getMetaData().addMetaData("CLUSTERED_REMOTING", "FAILOVER_COUNTER", new Integer(failoverCounter), PayloadKey.AS_IS);
/*  67 */       invocation.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", target, PayloadKey.AS_IS);
/*  68 */       invocation.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_VIEW_ID", new Long(family.get().getCurrentViewId()), PayloadKey.AS_IS);
/*     */ 
/*  70 */       boolean definitivlyRemoveNodeOnFailure = true;
/*  71 */       lastException = null;
/*     */       try
/*     */       {
/*  77 */         Object rsp = invocation.invokeNext();
/*  78 */         ArrayList newReplicants = (ArrayList)invocation.getResponseAttachment("replicants");
/*  79 */         if (newReplicants != null)
/*     */         {
/*  81 */           long newViewId = ((Long)invocation.getResponseAttachment("viewId")).longValue();
/*  82 */           family.get().updateClusterInfo(newReplicants, newViewId);
/*     */         }
/*  84 */         return rsp;
/*     */       }
/*     */       catch (DispatcherConnectException dce)
/*     */       {
/*  91 */         lastException = dce;
/*     */       }
/*     */       catch (CannotConnectException ex)
/*     */       {
/*  95 */         lastException = ex;
/*     */       }
/*     */       catch (GenericClusteringException gce)
/*     */       {
/*  99 */         lastException = gce;
/*     */ 
/* 104 */         if (gce.getCompletionStatus() == 1)
/*     */         {
/* 109 */           if (family.get().getTargets().size() >= failoverCounter)
/*     */           {
/* 111 */             if (!gce.isDefinitive()) {
/* 112 */               definitivlyRemoveNodeOnFailure = false;
/*     */             }
/*     */           }
/*     */         }
/*     */         else {
/* 117 */           throw new RuntimeException("Clustering exception thrown", gce);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 125 */         if ((t.getCause() instanceof GenericClusteringException))
/*     */         {
/* 127 */           GenericClusteringException gce = (GenericClusteringException)t.getCause();
/* 128 */           lastException = gce;
/*     */ 
/* 133 */           if (gce.getCompletionStatus() == 1)
/*     */           {
/* 138 */             if (family.get().getTargets().size() >= failoverCounter)
/*     */             {
/* 140 */               if (!gce.isDefinitive()) {
/* 141 */                 definitivlyRemoveNodeOnFailure = false;
/*     */               }
/*     */             }
/*     */           }
/*     */           else
/* 146 */             throw new RuntimeException("Clustering exception thrown", gce);
/*     */         }
/*     */         else
/*     */         {
/* 150 */           throw t;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 155 */       family.get().removeDeadTarget(target);
/* 156 */       if (!definitivlyRemoveNodeOnFailure)
/*     */       {
/* 158 */         family.get().resetView();
/*     */       }
/*     */ 
/* 161 */       target = (InvokerLocator)lb.chooseTarget(family.get());
/* 162 */       if (target == null)
/*     */       {
/* 164 */         if (lastException != null)
/*     */         {
/* 166 */           throw new RuntimeException("cluster invocation failed, last exception was: ", lastException);
/*     */         }
/*     */ 
/* 170 */         throw new RuntimeException("cluster invocation failed");
/*     */       }
/*     */ 
/* 173 */       failoverCounter++;
/*     */     }
/*     */ 
/* 176 */     throw new RuntimeException("Unreachable?: Service unavailable.");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.ClusterChooserInterceptor
 * JD-Core Version:    0.6.0
 */