/*     */ package org.jboss.aspects.library;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   public static void setThreadContextClassLoader(ClassLoader loader)
/*     */   {
/* 115 */     if (System.getSecurityManager() == null)
/*     */     {
/* 117 */       SetTcl.NON_PRIVILEGED.setContextClassLoader(loader);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       SetTcl.PRIVILEGED.setContextClassLoader(loader);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static ClassLoader getThreadContextClassLoader()
/*     */   {
/* 127 */     if (System.getSecurityManager() == null)
/*     */     {
/* 129 */       return GetTcl.NON_PRIVILEGED.getContextClassLoader();
/*     */     }
/*     */ 
/* 133 */     return GetTcl.PRIVILEGED.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   public static ClassLoader getClassLoader(Class clazz)
/*     */   {
/* 139 */     if (System.getSecurityManager() == null)
/*     */     {
/* 141 */       return GetClassLoader.NON_PRIVILEGED.getClassLoader(clazz);
/*     */     }
/*     */ 
/* 145 */     return GetClassLoader.PRIVILEGED.getClassLoader(clazz);
/*     */   }
/*     */ 
/*     */   static abstract interface GetClassLoader
/*     */   {
/*  91 */     public static final GetClassLoader PRIVILEGED = new GetClassLoader()
/*     */     {
/*     */       public ClassLoader getClassLoader(Class clazz)
/*     */       {
/*  95 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */         {
/*     */           public ClassLoader run()
/*     */           {
/*  99 */             return this.val$clazz.getClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*  91 */     };
/*     */ 
/* 104 */     public static final GetClassLoader NON_PRIVILEGED = new GetClassLoader()
/*     */     {
/*     */       public ClassLoader getClassLoader(Class clazz)
/*     */       {
/* 108 */         return clazz.getClassLoader();
/*     */       }
/* 104 */     };
/*     */ 
/*     */     public abstract ClassLoader getClassLoader(Class paramClass);
/*     */   }
/*     */ 
/*     */   static abstract interface GetTcl
/*     */   {
/*  65 */     public static final GetTcl PRIVILEGED = new GetTcl()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/*  69 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public ClassLoader run()
/*     */           {
/*  73 */             return Thread.currentThread().getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*  65 */     };
/*     */ 
/*  78 */     public static final GetTcl NON_PRIVILEGED = new GetTcl()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/*  82 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*  78 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static abstract interface SetTcl
/*     */   {
/*  38 */     public static final SetTcl PRIVILEGED = new SetTcl()
/*     */     {
/*     */       public void setContextClassLoader(ClassLoader loader)
/*     */       {
/*  42 */         AccessController.doPrivileged(new PrivilegedAction(loader)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  46 */             Thread.currentThread().setContextClassLoader(this.val$loader);
/*  47 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*  38 */     };
/*     */ 
/*  52 */     public static final SetTcl NON_PRIVILEGED = new SetTcl()
/*     */     {
/*     */       public void setContextClassLoader(ClassLoader loader)
/*     */       {
/*  56 */         Thread.currentThread().setContextClassLoader(loader);
/*     */       }
/*  52 */     };
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.library.SecurityActions
 * JD-Core Version:    0.6.0
 */