/*     */ package org.jboss.aspects.asynch;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class FutureInvocationHandler extends org.jboss.aop.proxy.Proxy
/*     */   implements InvocationHandler, Untransformable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -2343948303742422382L;
/*  52 */   private Map methodMap = new HashMap();
/*     */ 
/*     */   public static Object createFutureProxy(GUID guid, ClassLoader loader, Class[] interfaces)
/*     */     throws Exception
/*     */   {
/*  62 */     FutureInvocationHandler ih = new FutureInvocationHandler();
/*  63 */     ih.instanceAdvisor = new ClassInstanceAdvisor();
/*  64 */     ih.mixins = null;
/*  65 */     ih.interfaces = interfaces;
/*  66 */     ih.guid = guid;
/*  67 */     return java.lang.reflect.Proxy.newProxyInstance(loader, interfaces, ih);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  73 */     if (method.getName().equals("_getInstanceAdvisor"))
/*     */     {
/*  75 */       return _getInstanceAdvisor();
/*     */     }
/*  77 */     if ((method.getName().equals("_setInstanceAdvisor")) && (method.getParameterTypes().length == 1) && (method.getParameterTypes()[0].equals(InstanceAdvisor.class)))
/*     */     {
/*  80 */       _setInstanceAdvisor((InstanceAdvisor)args[0]);
/*  81 */       return null;
/*     */     }
/*     */ 
/*  84 */     Interceptor[] interceptors = this.instanceAdvisor.getInterceptors();
/*  85 */     long hash = MethodHashing.calculateHash(method);
/*  86 */     MethodInvocation invocation = new MethodInvocation(interceptors, hash, method, method, null);
/*  87 */     invocation.setInstanceResolver(this.instanceAdvisor.getMetaData());
/*  88 */     invocation.setArguments(args);
/*  89 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object writeReplace()
/*     */     throws ObjectStreamException
/*     */   {
/*  99 */     return this;
/*     */   }
/*     */ 
/*     */   public Map getMethodMap()
/*     */   {
/* 105 */     return this.methodMap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.FutureInvocationHandler
 * JD-Core Version:    0.6.0
 */